/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.editor.annotation.ext;

import com.unisys.os2200.editor.annotation.ext.UDTEditorLookUpUtility;
import com.unisys.os2200.editor.editors.UDTEditor;
import com.unisys.os2200.editor.editors.UDTEditorSourceViewer;
import com.unisys.tde.core.OS2200CorePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.editors.text.EditorsUI;

public class UDTEditorTextHover
implements ITextHoverExtension2,
ITextHover {
    private ISourceViewer srcViewer;

    public UDTEditorTextHover(ISourceViewer iSourceViewer) {
        this.srcViewer = iSourceViewer;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        String string = "";
        IDocument iDocument = null;
        if (iTextViewer == null || iRegion == null || iTextViewer.getDocument() == null) {
            return "";
        }
        iDocument = iTextViewer.getDocument();
        if (iTextViewer.getDocument() != null) {
            try {
                string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                if (string != null && string.trim().length() > 0) {
                    string = String.valueOf(this.getAbbrevation(iTextViewer, iRegion)) + string;
                }
                iDocument.computeNumberOfLines(string);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (string != null && string.trim().length() > 0) {
            String string2 = "";
            string2 = UDTEditorLookUpUtility.getTextHover(string);
            string = string2 != null && !string2.isEmpty() ? string2 : "";
        }
        return string;
    }

    public String getAbbrevation(ITextViewer iTextViewer, IRegion iRegion) {
        UDTEditor uDTEditor = null;
        IDocument iDocument = null;
        boolean bl = false;
        int n = -1;
        iDocument = iTextViewer.getDocument();
        if (!(iTextViewer instanceof UDTEditorSourceViewer)) {
            return "";
        }
        uDTEditor = ((UDTEditorSourceViewer)iTextViewer).getUdtEditor();
        if (!uDTEditor.isAccPrintFile || uDTEditor.getAcctPrintRec() == null || uDTEditor.getAcctPrintRec().length() == 0) {
            return "";
        }
        try {
            n = iTextViewer.getDocument().getLineOfOffset(iRegion.getOffset());
            String string = iTextViewer.getDocument().get(iDocument.getLineOffset(n), 17);
            String string2 = "";
            int n2 = -1;
            if (string != null && string.length() >= 17) {
                string2 = string.trim();
            }
            if (!string2.contains(" ") && string2.toUpperCase().endsWith("REC") && (n2 = iDocument.getLineOffset(n) + string.indexOf(string2)) == iRegion.getOffset()) {
                bl = true;
            }
            if (!bl) {
                return uDTEditor.getAcctPrintRec();
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Error in  UDTEditorTexthover.getAbbrevation() method", (Throwable)exception);
            exception.printStackTrace();
        }
        return "";
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        try {
            IRegion iRegion = iTextViewer.getDocument().getLineInformationOfOffset(n);
            Point point = iTextViewer.getSelectedRange();
            int n2 = -1;
            try {
                n2 = iTextViewer.getDocument().getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            int n3 = iTextViewer.getDocument().getLineLength(n2);
            if (n3 == point.y + 2) {
                return UDTEditorTextHover.findWord(iTextViewer.getDocument(), n);
            }
            if (n >= point.x && n < point.x + point.y && point.x >= iRegion.getOffset() && point.y < iRegion.getOffset() + iRegion.getLength() && point.y != iRegion.getLength() + 1) {
                return new Region(point.x, point.y);
            }
            return UDTEditorTextHover.findWord(iTextViewer.getDocument(), n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static IRegion findWord(IDocument iDocument, int n) {
        int n2 = -1;
        int n3 = -1;
        try {
            char c;
            int n4 = n;
            while (n4 >= 0) {
                c = iDocument.getChar(n4);
                if (!UDTEditorTextHover.isVariableCharacter(c)) break;
                --n4;
            }
            if (n4 != -1) {
                n2 = n4;
            } else {
                n4 = 0;
            }
            n4 = n;
            int n5 = iDocument.getLength();
            while (n4 < n5) {
                c = iDocument.getChar(n4);
                if (!UDTEditorTextHover.isVariableCharacter(c)) break;
                ++n4;
            }
            n3 = n4;
        }
        catch (BadLocationException badLocationException) {}
        if (n2 >= -1 && n3 > -1) {
            if (n2 == n && n3 == n) {
                return new Region(n, 0);
            }
            if (n2 == n) {
                return new Region(n2, n3 - n2);
            }
            return new Region(n2 + 1, n3 - n2 - 1);
        }
        return null;
    }

    public static boolean isVariableCharacter(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_';
    }

    protected String getTooltipAffordanceString() {
        return EditorsUI.getTooltipAffordanceString();
    }

    public Object getHoverInfo2(ITextViewer iTextViewer, IRegion iRegion) {
        return this.getHoverInfo(iTextViewer, iRegion);
    }
}

