/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import java.nio.ByteBuffer;
import javax.resource.ResourceException;

public class WebtxHeader {
    StringBuffer WebTxStringBuffer;
    ByteBuffer WebTxByteBuffer;
    static final int TRANCODEPOS = 0;
    static final int MAXTRANCODESIZE = 6;
    static final int INTFVERPOS = 6;
    static final char INTFVER = '2';
    static final int BUFLENGTHPOS = 7;
    static final int MAXBUFLENGTHSIZE = 6;
    static final int VIEWNAMEPOS = 13;
    static final int MAXVIEWNAMESIZE = 16;
    static final int FILLERPOS = 29;
    static final int DATAPOS = 32;
    static int MAXDATASIZE;
    protected int datalength = 0;
    protected int databytelength = 0;
    char space = (char)32;

    protected WebtxHeader() throws ResourceException {
        MAXDATASIZE = OS2200AttributeList.maximumCharacters;
        this.WebTxStringBuffer = new StringBuffer(32 + MAXDATASIZE);
        this.WebTxByteBuffer = ByteBuffer.allocate(MAXDATASIZE);
    }

    protected void setTrancode(String trancode) {
        this.WebTxStringBuffer.setLength(32 + this.datalength);
        if (trancode.length() > 6) {
            throw new IllegalArgumentException("Transaction code or function name must be 6 characters or less");
        }
        int i = 0;
        while (i < 6) {
            if (i < trancode.length()) {
                this.WebTxStringBuffer.setCharAt(0 + i, trancode.charAt(i));
            } else {
                this.WebTxStringBuffer.setCharAt(0 + i, this.space);
            }
            ++i;
        }
    }

    protected void setViewname(String viewname) {
        this.WebTxStringBuffer.setLength(32 + this.datalength);
        if (viewname.length() > 16) {
            throw new IllegalArgumentException("View name must be 16 characters or less");
        }
        int i = 0;
        while (i < 16) {
            if (i < viewname.length()) {
                this.WebTxStringBuffer.setCharAt(13 + i, viewname.charAt(i));
            } else {
                this.WebTxStringBuffer.setCharAt(13 + i, this.space);
            }
            ++i;
        }
    }

    protected void setData(String data) {
        this.WebTxStringBuffer.setLength(32 + data.length());
        if (data.length() > MAXDATASIZE) {
            throw new IllegalArgumentException("OS 2200 TIP Connector internal message buffer is not large enough to accommodate transaction message. Increase 'MaximumCharacters' config-property value to " + data.length() + " or more");
        }
        this.datalength = data.length();
        int i = 0;
        while (i < this.datalength) {
            this.WebTxStringBuffer.setCharAt(32 + i, data.charAt(i));
            ++i;
        }
        byte[] dataBytes = data.getBytes();
        this.databytelength = dataBytes.length;
    }

    protected void setData(byte[] txBuffer) {
        this.WebTxByteBuffer = ByteBuffer.wrap(txBuffer);
        this.datalength = txBuffer.length;
        this.databytelength = txBuffer.length;
    }

    protected byte[] getBytecode() {
        this.WebTxStringBuffer.setCharAt(6, '2');
        int i = 0;
        while (i < 3) {
            this.WebTxStringBuffer.setCharAt(29 + i, this.space);
            ++i;
        }
        String str = String.valueOf(32 + this.databytelength);
        i = 0;
        while (i < 6) {
            if (i < str.length()) {
                this.WebTxStringBuffer.setCharAt(7 + i, str.charAt(i));
            } else {
                this.WebTxStringBuffer.setCharAt(7 + i, this.space);
            }
            ++i;
        }
        String WebTxString = this.WebTxStringBuffer.toString();
        byte[] octetsendbuffer = WebTxString.getBytes();
        return octetsendbuffer;
    }

    protected byte[] getBytes() {
        byte[] octetsendbuffer = new byte[this.WebTxByteBuffer.array().length + 32];
        this.WebTxStringBuffer.setCharAt(6, '2');
        int i = 0;
        while (i < 3) {
            this.WebTxStringBuffer.setCharAt(29 + i, this.space);
            ++i;
        }
        String str = String.valueOf(this.databytelength + 32);
        i = 0;
        while (i < 6) {
            if (i < str.length()) {
                this.WebTxStringBuffer.setCharAt(7 + i, str.charAt(i));
            } else {
                this.WebTxStringBuffer.setCharAt(7 + i, this.space);
            }
            ++i;
        }
        String WebTxHeaderString = this.WebTxStringBuffer.substring(0, 32);
        byte[] header = WebTxHeaderString.getBytes();
        i = 0;
        while (i < header.length) {
            octetsendbuffer[i] = header[i];
            ++i;
        }
        i = 0;
        while (i < this.datalength) {
            octetsendbuffer[i + 32] = this.WebTxByteBuffer.get(i);
            ++i;
        }
        return octetsendbuffer;
    }

    protected String getTrancode() {
        StringBuffer trancode = new StringBuffer();
        this.WebTxStringBuffer.setLength(32 + this.datalength);
        trancode.setLength(6);
        int i = 0;
        while (i < 6) {
            trancode.setCharAt(i, this.WebTxStringBuffer.charAt(0 + i));
            ++i;
        }
        return new String(trancode);
    }

    protected String getViewname() {
        int i;
        StringBuffer viewname = new StringBuffer();
        this.WebTxStringBuffer.setLength(32 + this.datalength);
        for (i = 0; i < 16; ++i) {
            if (this.WebTxStringBuffer.charAt(13 + i) == ' ') {
                continue;
            }
            viewname.setLength(16 - i);
            break;
        }
        int j = i;
        int k = 0;
        while (j < 16) {
            viewname.setCharAt(k++, this.WebTxStringBuffer.charAt(13 + j));
            ++j;
        }
        return new String(viewname);
    }
}

