/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200Record;
import java.io.Serializable;

public class OS2200Xoctet
implements OS2200Record,
Serializable {
    private String recordName;
    private String recordShortDescription;
    private byte[] data;
    private int dataLength;
    private static int DEFAULTLENGTH = 512;

    public OS2200Xoctet() {
        try {
            this.data = new byte[OS2200AttributeList.maximumCharacters.intValue()];
        }
        catch (NullPointerException e) {
            this.data = new byte[DEFAULTLENGTH];
        }
        this.recordName = "";
        this.recordShortDescription = "";
    }

    public OS2200Xoctet(String viewName) {
        this.recordName = viewName;
        try {
            this.data = new byte[OS2200AttributeList.maximumCharacters.intValue()];
        }
        catch (NullPointerException e) {
            this.data = new byte[DEFAULTLENGTH];
        }
    }

    public OS2200Xoctet(int bufferSize) {
        this.data = new byte[bufferSize];
    }

    public void setRecordName(String viewName) {
        this.recordName = viewName;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public String getRecordShortDescription() {
        return this.recordShortDescription;
    }

    public void setRecordShortDescription(String recordShortDescription) {
        this.recordShortDescription = recordShortDescription;
    }

    public void setData(byte[] wrByteData) {
        this.data = wrByteData;
        this.dataLength = wrByteData.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.dataLength;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        try {
            return this.getClass().getName();
        }
        catch (Exception e) {
            return "OS2200Xoctet";
        }
    }
}

