/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200Ejb3RemoteObject;
import com.unisys.os2200.connector.OS2200EjbRemoteHome;
import com.unisys.os2200.connector.OS2200EjbRemoteObject;
import com.unisys.os2200.connector.OS2200EjbReturnData;
import com.unisys.os2200.connector.OS2200Header;
import com.unisys.os2200.connector.OS2200HeaderException;
import com.unisys.os2200.connector.OS2200PojoRemoteObject;
import com.unisys.os2200.connector.OS2200Record;
import com.unisys.os2200.connector.OS2200Request;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import com.unisys.os2200.connector.OS2200Xoctet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.Work;
import javax.rmi.PortableRemoteObject;

public class OS2200WorkRequestHandler
implements Work {
    private boolean active = false;
    private InputStream breader;
    private OutputStream bwriter;
    private BufferedWriter writer;
    private Socket socket;
    private long requestNum;
    private static final String className = "OS2200WorkRequestHandler";

    public OS2200WorkRequestHandler(Socket socket, long rc) throws SocketException, IOException {
        this.socket = socket;
        this.requestNum = rc;
        this.socket.setSoTimeout(OS2200AttributeList.requestSocketTO);
        this.bwriter = this.socket.getOutputStream();
        this.breader = this.socket.getInputStream();
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.active = true;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Constructor invoked:  Created new RequestHandler number: " + this.requestNum);
    }

    public void release() {
        this.active = false;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "release", "Unable to close socket connection to the client." + e.getMessage());
        }
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    private void createErrorMsg(int errorCode, String s) {
        try {
            OS2200Header header = new OS2200Header("TIPJ", "2", new Integer(errorCode).toString().trim(), "CHAR", "CHAR", "", "", Integer.toString(s.length() + 72));
            String h = header.toString();
            int size = h.length() + s.length();
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "createErrorMsg", "Response message (" + size + " bytes): >" + h + s + "<");
            this.bwriter.write((header + s).getBytes());
            this.bwriter.flush();
        }
        catch (OS2200HeaderException e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "createErrorMsg", "OS2200HeaderException thrown. Unable to create error message to send back to client. " + e.getMessage());
        }
        catch (IOException e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "createErrorMsg", "IOException thrown. Unable to send error message to the client. " + e.getMessage());
        }
        catch (Exception e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "createErrorMsg", "Exception thrown. Unable to send error message to the client. " + e.getMessage());
        }
    }

    public void run() {
        int msgLen;
        int temp;
        int charsToRead;
        int charsRead;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Entered run(): RequestHandler number = " + this.requestNum);
        char[] message = null;
        byte[] bmessage = null;
        OS2200EjbReturnData data = new OS2200EjbReturnData();
        OS2200Header requestHeader = null;
        if (this.active) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Reading in request header.");
            try {
                byte[] bheader = new byte[72];
                charsRead = 0;
                charsToRead = 72;
                int i = 0;
                while (charsRead < 72) {
                    ++i;
                    temp = this.breader.read(bheader, charsRead, charsToRead);
                    if (temp == -1) {
                        if (i != 1) continue;
                        charsRead = -1;
                        throw new InterruptedIOException("No bytes read on socket connection");
                    }
                    charsRead += temp;
                    charsToRead -= temp;
                }
                String headerString = new String(bheader);
                if (headerString.substring(0, 4).compareTo("TIPJ") != 0) {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "RequestHandler number =" + this.requestNum + ": Invalid pktID. ID should be >" + "TIPJ" + "< but is >" + headerString.substring(0, 4) + "<");
                    this.createErrorMsg(1, "Invalid pktID. ID should be >TIPJ< but is >" + headerString.substring(0, 4) + "<");
                    this.stop();
                }
                if (headerString.substring(4, 5).compareTo("2") != 0) {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "RequestHandler number = " + this.requestNum + ": Invalid intfLevel.  Should be >" + "2" + "< but is >" + headerString.substring(4, 5) + "<");
                    this.createErrorMsg(2, "Invalid intfLevel.  Should be >2< but is >" + headerString.substring(4, 5) + "<");
                    this.stop();
                }
                requestHeader = new OS2200Header(new String(bheader));
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "RequestHandler number = " + this.requestNum + "\n ..OS2200Header Data: \n" + "pktID        : >" + requestHeader.getPktID() + "<\n" + "intfLevel    : >" + requestHeader.getIntfLevel() + "<\n" + "status       : >" + requestHeader.getStatus() + "<\n" + "inputType    : >" + requestHeader.getInputType() + "<\n" + "outputType   : >" + requestHeader.getOutputType() + "<\n" + "beanName     : >" + requestHeader.getBeanName() + "<\n" + "beanType     : >" + requestHeader.getBeanType() + "<\n" + "byteLen      : >" + requestHeader.getByteLen() + "<\n" + "filler       : >" + requestHeader.getFiller() + "<\n");
            }
            catch (OS2200HeaderException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "OS2200HeaderException thrown. Unable to parse OS2200Header. Sending an error back to the client and stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(6, "Unable to parse OS2200Header. " + e.getMessage());
                this.stop();
            }
            catch (InterruptedIOException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "InterruptedIOException thrown. Socket connection to client has timed out.  Sending an error back to the client and stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(8, "Socket connection timed out. " + e.getMessage());
                this.stop();
            }
            catch (SocketException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "SocketException thrown. Socket connection to the client has failed. Stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(9, "SocketException thrown. " + e.getMessage());
                this.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "IOException thrown. Socket connection to the client has failed. Stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(10, "IOException thrown. " + e.getMessage());
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "Exception thrown. Stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(16, "Exception thrown. " + e.getMessage());
                this.stop();
            }
        }
        String beanName = requestHeader.getBeanName().trim();
        String input = requestHeader.getInputType().toUpperCase();
        String output = requestHeader.getOutputType().toUpperCase();
        String beanType = requestHeader.getBeanType().toUpperCase();
        if (input.compareTo("CHAR") != 0 && input.compareTo("BYTE") != 0) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "Invalid value for inputType field in OS2200Header request to target EJB " + beanName + ". inputType = " + input + ".");
            this.createErrorMsg(3, "Invalid value for inputType field in OS2200Header request to target EJB " + beanName + ". inputType = " + input + ".");
            this.stop();
        }
        if (output.compareTo("CHAR") != 0 && output.compareTo("BYTE") != 0) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "Invalid value for outputType field in OS2200Header request to target EJB " + beanName + ". outputType = " + output + ".");
            this.createErrorMsg(4, "Invalid value for outputType field in OS2200Header request to target EJB " + beanName + ". outputtType = " + output + ".");
            this.stop();
        }
        if (beanType.compareTo("REM ") != 0 && beanType.compareTo("EJB2") != 0 && beanType.compareTo("EJB3") != 0 && beanType.compareTo("POJO") != 0) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "Invalid value for the beanType field in the OS2200Header request to target EJB " + beanName + "." + " beanType = " + beanType + ".");
            this.createErrorMsg(5, "Invalid value for the beanType field in the OS2200Header request to target EJB " + beanName + "." + " beanType = " + beanType + ".");
            this.stop();
        }
        if (this.active) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Reading in client request message.");
            try {
                msgLen = new Integer(requestHeader.getByteLen().trim());
                bmessage = new byte[msgLen -= 72];
                charsRead = 0;
                charsToRead = msgLen;
                while (charsRead < msgLen) {
                    temp = this.breader.read(bmessage, charsRead, charsToRead);
                    if (temp == -1) continue;
                    charsRead += temp;
                    charsToRead -= temp;
                }
            }
            catch (InterruptedIOException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "InterruptedIOException thrown. Socket connection to client has timed out.  Sending an error back to the client and stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(8, "Socket connection timed out. " + e.getMessage());
                this.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "IOException thrown. Socket connection to the client has failed. Stopping. Exception is: " + e.getMessage());
                this.createErrorMsg(10, "IOException thrown. " + e.getMessage());
                this.stop();
            }
        }
        if (this.active) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Calling the target EJB.");
            try {
                Object remote;
                InitialContext naming = new InitialContext();
                msgLen = new Integer(requestHeader.getByteLen().trim());
                msgLen -= 72;
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", String.valueOf(beanName) + " is of bean type " + beanType);
                Object o = naming.lookup(beanName);
                if (beanType.compareTo("REM ") == 0 || beanType.compareTo("EJB2") == 0) {
                    OS2200EjbRemoteHome home = (OS2200EjbRemoteHome)PortableRemoteObject.narrow((Object)o, OS2200EjbRemoteHome.class);
                    OS2200EjbRemoteObject remote2 = (OS2200EjbRemoteObject)PortableRemoteObject.narrow((Object)home.create(), OS2200EjbRemoteObject.class);
                    OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Created EJB remote object");
                    if (input.compareTo("CHAR") == 0) {
                        OS2200Request inRecord = new OS2200Request();
                        inRecord.setData(new String(bmessage));
                        data = remote2.os2200EjbService(inRecord);
                    } else {
                        OS2200Xoctet binRecord = new OS2200Xoctet(msgLen);
                        binRecord.setData(bmessage);
                        data = remote2.os2200EjbService(binRecord);
                    }
                } else if (beanType.compareTo("EJB3") == 0) {
                    remote = (OS2200Ejb3RemoteObject)PortableRemoteObject.narrow((Object)o, OS2200Ejb3RemoteObject.class);
                    OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Created EJB3 remote object");
                    if (input.compareTo("CHAR") == 0) {
                        OS2200Request inRecord = new OS2200Request();
                        inRecord.setData(new String(bmessage));
                        data = remote.os2200EjbService(inRecord);
                    } else {
                        OS2200Xoctet binRecord = new OS2200Xoctet(msgLen);
                        binRecord.setData(bmessage);
                        data = remote.os2200EjbService(binRecord);
                    }
                } else if (beanType.compareTo("POJO") == 0) {
                    remote = (OS2200PojoRemoteObject)PortableRemoteObject.narrow((Object)o, OS2200PojoRemoteObject.class);
                    OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Created POJO remote object");
                    if (input.compareTo("CHAR") == 0) {
                        OS2200Request inRecord = new OS2200Request();
                        inRecord.setData(new String(bmessage));
                        data = remote.os2200EjbService(inRecord);
                    } else {
                        OS2200Xoctet binRecord = new OS2200Xoctet(msgLen);
                        binRecord.setData(bmessage);
                        data = remote.os2200EjbService(binRecord);
                    }
                }
            }
            catch (CreateException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "CreateException thrown. Unable to create an instance of the target EJB: " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.createErrorMsg(11, "CreateException thrown. Unable to create an instance of the target EJB: " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.stop();
            }
            catch (NamingException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "NamingException thrown. Unable to find the target EJB: " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.createErrorMsg(12, "NamingException thrown. Unable to find the target EJB: " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.stop();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "RemoteException thrown. Unable to send data to the target EJB: " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.createErrorMsg(13, "RemoteException thrown. Unable to send data to the target EJB: " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.stop();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "ClassCastException thrown in target EJB lookup. " + e.getMessage());
                this.createErrorMsg(14, "ClassCastException thrown in target EJB lookup. " + e.getMessage());
                this.stop();
            }
            catch (EJBException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "EJBException thrown by target EJB. " + e.getMessage());
                this.createErrorMsg(7, "EJBException thrown by target EJB. " + e.getMessage());
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "Exception thrown. " + e.getMessage());
                this.createErrorMsg(16, "Exception thrown. " + e.getMessage());
                this.stop();
            }
        }
        if (this.active) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Sending response back to client.");
            try {
                OS2200Record outRecord = data.getRecord();
                temp = 0;
                if (output.compareTo("CHAR") == 0) {
                    temp = ((OS2200Request)outRecord).getLength() + 72;
                }
                if (output.compareTo("BYTE") == 0) {
                    temp = ((OS2200Xoctet)outRecord).getLength() + 72;
                }
                OS2200Header responseHeader = new OS2200Header("TIPJ", "2", new Integer(data.getRetCode()).toString().trim(), requestHeader.getInputType(), requestHeader.getOutputType(), requestHeader.getBeanName().trim(), requestHeader.getBeanType(), new Integer(temp).toString());
                if (output.compareTo("CHAR") == 0) {
                    this.writer.write(responseHeader + ((OS2200Request)outRecord).getData());
                    this.writer.flush();
                }
                if (output.compareTo("BYTE") == 0) {
                    this.writer.write(responseHeader.toString());
                    this.writer.flush();
                    this.bwriter.write(((OS2200Xoctet)outRecord).getData());
                    this.bwriter.flush();
                }
            }
            catch (OS2200HeaderException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "OS2200HeaderException thrown. Unable to create response header for return from EJB" + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.createErrorMsg(15, "OS2200HeaderException thrown. Unable to create response header for return from EJB " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "IOException thrown. Unable to write response to client for EJB " + requestHeader.getBeanName().trim() + ". " + e.getMessage());
                this.stop();
            }
        }
        if (this.active) {
            this.stop();
        }
    }

    public synchronized void stop() {
        this.active = false;
        try {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "stop", "Closing socket connection to client.");
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "stop", "IOException thrown. Unable to close socket connection to the client." + e.getMessage());
        }
    }
}

