/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200InboundWork;
import com.unisys.os2200.connector.OS2200ResourceAdapterMetaData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class OS2200ResourceAdapter
implements ResourceAdapter,
Serializable {
    private boolean started = false;
    protected static boolean debug;
    protected static boolean loggingEnabled;
    protected static boolean validLogFilename;
    protected static PrintWriter OS2200LogWriter;
    protected static Logger logger;
    private transient WorkManager workManager;
    private OS2200InboundWork inboundWork;
    private OS2200ResourceAdapter raReference = null;
    private OS2200ResourceAdapterMetaData osMetaData;
    private static final int logFileByteSize = 5000000;
    private static final int logFileCycles = 5;
    private static final String className = "OS2200ResourceAdapter";

    static {
        validLogFilename = false;
        OS2200LogWriter = null;
        logger = null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        OS2200LogWriter = out;
    }

    public static PrintWriter getLogWriter() {
        return OS2200LogWriter;
    }

    public static void logEvent(Level level, String sourceClass, String sourceMethod, String msg) {
        if (!loggingEnabled && !debug || level.equals(Level.FINE) && !debug) {
            return;
        }
        if (validLogFilename) {
            msg = msg.concat("\n--------------------------------------------");
            logger.logp(level, sourceClass, sourceMethod, msg);
        } else {
            Date current = new Date();
            OS2200LogWriter.println("OS 2200 TIP Connector: <" + current.toString() + "> " + sourceClass + " " + sourceMethod + "\n" + level.getName() + ": " + msg + "\n--------------------------------------------");
            OS2200LogWriter.flush();
        }
    }

    public String getServerName() throws ResourceException {
        return OS2200AttributeList.serverName;
    }

    public String[] getServerName_array() {
        return OS2200AttributeList.serverNames;
    }

    public void setServerName(String ip) throws ResourceException {
        OS2200AttributeList.serverName = ip;
        OS2200AttributeList.serverNames = OS2200ResourceAdapter.parseTokensToStringArray(ip, ";,");
    }

    public String getPortNumber() throws ResourceException {
        return OS2200AttributeList.portNumber;
    }

    public void setPortNumber(String port) throws ResourceException {
        OS2200AttributeList.portNumber = port;
    }

    public Integer getConnectionTO() throws ResourceException {
        return OS2200AttributeList.connectionTO;
    }

    public void setConnectionTO(Integer timeout) throws ResourceException {
        OS2200AttributeList.connectionTO = timeout;
    }

    public Boolean getUseSecureConnection() throws ResourceException {
        return OS2200AttributeList.useSecureConnection;
    }

    public void setUseSecureConnection(Boolean secureConnectionValue) throws ResourceException {
        OS2200AttributeList.useSecureConnection = secureConnectionValue;
    }

    public String getUserName() throws ResourceException {
        if (OS2200AttributeList.userName == null) {
            return new String("");
        }
        return OS2200AttributeList.userName;
    }

    public void setUserName(String name) throws ResourceException {
        OS2200AttributeList.userName = name;
    }

    public String getPassword() throws ResourceException {
        if (OS2200AttributeList.password == null) {
            return new String("");
        }
        return OS2200AttributeList.password;
    }

    public void setPassword(String pw) throws ResourceException {
        OS2200AttributeList.password = pw;
    }

    public Integer getMaximumCharacters() throws ResourceException {
        return OS2200AttributeList.maximumCharacters;
    }

    public void setMaximumCharacters(Integer maxCharsInt) throws ResourceException {
        OS2200AttributeList.maximumCharacters = maxCharsInt;
    }

    public Boolean getDebug() throws ResourceException {
        return OS2200AttributeList.debug;
    }

    public void setDebug(Boolean debugValue) throws ResourceException {
        OS2200AttributeList.debug = debugValue;
        debug = debugValue;
    }

    public Boolean getLoggingEnabled() throws ResourceException {
        return OS2200AttributeList.loggingEnabled;
    }

    public void setLoggingEnabled(Boolean logging) throws ResourceException {
        OS2200AttributeList.loggingEnabled = logging;
        loggingEnabled = logging;
    }

    public String getLogFilename() throws ResourceException {
        return OS2200AttributeList.logFilename;
    }

    public static void setLogFilename(String filename) throws ResourceException {
        try {
            if (logger != null) {
                return;
            }
            File logFile = new File(filename);
            File logFileDir = logFile.getParentFile();
            if (logFileDir != null && !logFileDir.exists()) {
                logFileDir.mkdirs();
            }
            SimpleFormatter logFormatter = new SimpleFormatter();
            FileHandler logFileHandler = new FileHandler(filename, 5000000, 5, true);
            logFileHandler.setFormatter(logFormatter);
            logger = Logger.getAnonymousLogger();
            logger.addHandler(logFileHandler);
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.FINE);
        }
        catch (IOException ioe) {
            ResourceException re = new ResourceException("OS2200ResourceAdapter.setLogfilename(): Exception creating log file " + ioe.getMessage());
            re.initCause((Throwable)ioe);
            System.out.println("OS2200ResourceAdapter.setLogfilename(): Exception creating log file. " + ioe.getMessage());
            System.out.println("Using System.out for log file. ");
            OS2200LogWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
            validLogFilename = false;
            logger = null;
            return;
        }
        validLogFilename = true;
        OS2200AttributeList.logFilename = filename;
    }

    public Integer getInPort() {
        return OS2200AttributeList.inPort;
    }

    public void setInPort(Integer port) {
        OS2200AttributeList.inPort = port;
    }

    public Boolean getUseInboundSecureConnection() throws ResourceException {
        return OS2200AttributeList.useInboundSecureConnection;
    }

    public void setUseInboundSecureConnection(Boolean secureConnectionValue) throws ResourceException {
        OS2200AttributeList.useInboundSecureConnection = secureConnectionValue;
    }

    public Integer getRequestSocketTO() {
        return OS2200AttributeList.requestSocketTO;
    }

    public void setRequestSocketTO(Integer timeout) {
        OS2200AttributeList.requestSocketTO = timeout;
    }

    public Integer getServerSocketTO() {
        return OS2200AttributeList.serverSocketTO;
    }

    public void setServerSocketTO(Integer timeout) {
        OS2200AttributeList.serverSocketTO = timeout;
    }

    protected OS2200ResourceAdapter getRaReference() {
        return this.raReference;
    }

    public void start(BootstrapContext bc) throws ResourceAdapterInternalException {
        this.raReference = this;
        OS2200LogWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        this.osMetaData = new OS2200ResourceAdapterMetaData();
        OS2200ResourceAdapter.logEvent(Level.INFO, className, "start", String.valueOf(this.osMetaData.getAdapterName()) + " starting: Java property values" + "\n" + "    Java version = " + System.getProperty("java.version") + "\n" + "    Java vendor = " + System.getProperty("java.vendor") + "\n" + "    Java home = " + System.getProperty("java.home") + "\n" + "    Java classpath = " + System.getProperty("java.class.path") + "\n" + "    OS name = " + System.getProperty("os.name") + "\n" + "    OS version = " + System.getProperty("os.version") + "\n" + "    User directory = " + System.getProperty("user.dir"));
        try {
            if (this.started) {
                return;
            }
            this.started = true;
            this.workManager = bc.getWorkManager();
            this.inboundWork = new OS2200InboundWork(this.workManager);
            this.workManager.startWork((Work)this.inboundWork);
        }
        catch (IOException e) {
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException(e.getMessage());
            raie.initCause((Throwable)e);
            throw raie;
        }
        catch (WorkException e) {
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException(e.getMessage());
            raie.initCause((Throwable)e);
            throw raie;
        }
        OS2200ResourceAdapter.logEvent(Level.INFO, className, "start", String.valueOf(this.osMetaData.getAdapterName()) + " Version " + this.osMetaData.getAdapterVersion() + ": started...");
    }

    public void stop() {
        this.inboundWork.release();
        OS2200ResourceAdapter.logEvent(Level.INFO, className, "stop", String.valueOf(this.osMetaData.getAdapterName()) + " stopped.");
    }

    public void endpointActivation(MessageEndpointFactory bc, ActivationSpec arg1) throws ResourceException {
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "endpointActivation", "Entering method endpointActivation for " + this);
        throw new NotSupportedException();
    }

    public void endpointDeactivation(MessageEndpointFactory bc, ActivationSpec arg1) {
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "endpointDeactivation", "Entering method endpointDeactivation for " + this);
    }

    public XAResource[] getXAResources(ActivationSpec[] bc) throws ResourceException {
        return null;
    }

    protected WorkManager getWorkManager() {
        return this.workManager;
    }

    public static String[] parseTokensToStringArray(String tokens, String delim) {
        StringTokenizer st = delim == null ? new StringTokenizer(tokens) : new StringTokenizer(tokens, delim);
        String[] returnStrings = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            returnStrings[index] = st.nextToken().trim();
            ++index;
        }
        return returnStrings;
    }
}

