/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200ManagedConnection;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionMetaData;

public class OS2200ManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private OS2200ManagedConnection mc;
    private String eisProductName;
    private String eisProductVersion;
    private String userName;
    private int maxConnections;
    private static final String className = "OS2200ManagedConnectionMetaData";

    public OS2200ManagedConnectionMetaData(OS2200ManagedConnection mc) throws ResourceException {
        this.mc = mc;
        this.eisProductName = "OS 2200 ClearPath";
        this.eisProductVersion = "13.1";
        this.maxConnections = 50;
    }

    public String getEISProductName() throws ResourceException {
        if (this.mc.isDestroyed()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getEISProductName", "IllegalState Exception thrown.");
            throw new IllegalStateException("OS 2200 Connector: ManagedConnection has been destroyed.");
        }
        return this.eisProductName;
    }

    public String getEISProductVersion() throws ResourceException {
        if (this.mc.isDestroyed()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getEISProductVersion", "IllegalState Exception thrown.");
            throw new IllegalStateException("OS 2200 Connector: ManagedConnection has been destroyed.");
        }
        return this.eisProductVersion;
    }

    public int getMaxConnections() throws ResourceException {
        if (this.mc.isDestroyed()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getMaxConnections", "IllegalState Exception thrown.");
            throw new IllegalStateException("OS 2200 Connector: ManagedConnection has been destroyed.");
        }
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "getMaxConnections", "getMaxConnections() invoked.");
        return this.maxConnections;
    }

    public String getUserName() throws ResourceException {
        if (this.mc.isDestroyed()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getUserName", "IllegalState Exception thrown.");
            throw new IllegalStateException("OS 2200 Connector: ManagedConnection has been destroyed.");
        }
        return this.userName;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.mc.isDestroyed()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getLogWriter", "IllegalState Exception thrown.");
            throw new IllegalStateException("OS 2200 Connector: ManagedConnection has been destroyed.");
        }
        return this.mc.getLogWriter();
    }
}

