/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200ConnectionFactory;
import com.unisys.os2200.connector.OS2200ConnectionRequestInfo;
import com.unisys.os2200.connector.OS2200Credentials;
import com.unisys.os2200.connector.OS2200ManagedConnection;
import com.unisys.os2200.connector.OS2200ParseXML;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import com.unisys.os2200.connector.OS2200ResourceAdapterMetaData;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class OS2200ManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private String factoryID;
    private Integer defaultConnectionTO = new Integer(0);
    private Integer defaultMaxChars = new Integer(512);
    private static final int managedConnectionMax = 200;
    private int currentManagedConnections = 0;
    protected static PrintWriter logWriter = null;
    protected static PrintWriter OS2200LogWriter = null;
    private static boolean raXmlParsed = false;
    private static final String className = "OS2200ManagedConnectionFactory";

    public OS2200ManagedConnectionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OS2200ManagedConnectionFactory(boolean nonmanaged) throws ResourceException, FileNotFoundException {
        Class<OS2200ManagedConnectionFactory> clazz = OS2200ManagedConnectionFactory.class;
        synchronized (OS2200ManagedConnectionFactory.class) {
            if (raXmlParsed) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            String filename = OS2200ParseXML.raxml("LogFilename");
            OS2200ResourceAdapter.setLogFilename(filename);
            String debug = OS2200ParseXML.raxml("Debug");
            if (debug.equalsIgnoreCase("true")) {
                this.setDebug(new Boolean(true));
            } else {
                this.setDebug(new Boolean(false));
            }
            String logFlag = OS2200ParseXML.raxml("LoggingEnabled");
            if (logFlag.equalsIgnoreCase("true")) {
                this.setLoggingEnabled(new Boolean(true));
            } else {
                this.setLoggingEnabled(new Boolean(false));
            }
            OS2200ResourceAdapterMetaData osMetaData = new OS2200ResourceAdapterMetaData();
            OS2200ResourceAdapter.logEvent(Level.INFO, className, "constructor", String.valueOf(osMetaData.getAdapterName()) + " Version " + osMetaData.getAdapterVersion() + ": started...");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Connector is non-managed.");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "LogFilename from ra.xml = " + this.getLogFilename());
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "LoggingEnabled from ra.xml = " + this.getLoggingEnabled());
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Debug from ra.xml = " + this.getDebug());
            String serverName = OS2200ParseXML.raxml("ServerName");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "ServerName from ra.xml = " + serverName);
            this.setServerName(serverName);
            String portNumber = OS2200ParseXML.raxml("PortNumber");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "PortNumber from ra.xml = " + portNumber);
            this.setPortNumber(portNumber);
            String connectionTOString = OS2200ParseXML.raxml("ConnectionTO");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "ConnectionTO from ra.xml = " + connectionTOString);
            if (connectionTOString == null) {
                this.setConnectionTO(this.defaultConnectionTO);
            } else {
                Integer ConnectionTOInt = new Integer(connectionTOString);
                this.setConnectionTO(ConnectionTOInt);
            }
            String secureConnectionString = OS2200ParseXML.raxml("UseSecureConnection");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "UseSecureConnection from ra.xml = " + secureConnectionString);
            if (secureConnectionString.equalsIgnoreCase("true")) {
                this.setUseSecureConnection(new Boolean(true));
            } else {
                this.setUseSecureConnection(new Boolean(false));
            }
            String userName = OS2200ParseXML.raxml("UserName");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "UserName from ra.xml = " + userName);
            this.setUserName(userName);
            String password = OS2200ParseXML.raxml("Password");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Password from ra.xml = " + password);
            this.setPassword(password);
            String maxCharsString = OS2200ParseXML.raxml("MaximumCharacters");
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "MaxChars from ra.xml = " + maxCharsString);
            if (maxCharsString == null) {
                this.setMaximumCharacters(this.defaultMaxChars);
            } else {
                Integer maxCharsInt = new Integer(maxCharsString);
                this.setMaximumCharacters(maxCharsInt);
            }
            raXmlParsed = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        OS2200ConnectionFactory cf = new OS2200ConnectionFactory(this, cxManager);
        OS2200ResourceAdapter.logEvent(Level.INFO, className, "createConnectionFactory(ConnectionManager)", "OS2200ConnectionFactory created.");
        return cf;
    }

    public Object createConnectionFactory() throws ResourceException {
        OS2200ConnectionFactory cf = new OS2200ConnectionFactory(this, null);
        OS2200ResourceAdapter.logEvent(Level.INFO, className, "createConnectionFactory", "OS2200ConnectionFactory created.");
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (this.currentManagedConnections >= 200) {
            EISSystemException re = new EISSystemException("OS 2200 Connector: EIS OS 2200 ResourceException: Maximum (200) connections exceeded.");
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "createManagedConnection", "ResourceException thrown. Maximum (200) connections exceeded.");
            throw re;
        }
        try {
            OS2200ConnectionRequestInfo OS2200info = (OS2200ConnectionRequestInfo)info;
            PasswordCredential credentials = OS2200Credentials.getCredentials(this, subject, OS2200info);
            OS2200ManagedConnection osMc = new OS2200ManagedConnection(this, OS2200info, credentials, false, false);
            OS2200ResourceAdapter.logEvent(Level.INFO, className, "createManagedConnection", "OS2200ManagedConnection created.");
            ++this.currentManagedConnections;
            return osMc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EISSystemException re = new EISSystemException("OS 2200 Connector: EIS OS 2200 EISSystemException: " + ex.getMessage());
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "createManagedConnection", "EIS OS 2200 EISSystemException thrown in createManagedConnection(): " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (connectionSet == null || connectionSet.isEmpty()) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "matchManagedConnections", "connection set is empty");
            return null;
        }
        for (Object obj : connectionSet) {
            OS2200ManagedConnection mc;
            OS2200ConnectionRequestInfo mcInfo;
            if (!(obj instanceof OS2200ManagedConnection) || !info.equals((Object)(mcInfo = (mc = (OS2200ManagedConnection)obj).getConnectionRequestInfo()))) continue;
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "matchManagedConnections", "Connection matched.");
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return logWriter;
    }

    public String getFactoryID() {
        return this.factoryID;
    }

    public void setFactoryID(String factoryID) {
        this.factoryID = factoryID;
    }

    public String getServerName() throws ResourceException {
        return OS2200AttributeList.serverName;
    }

    public String[] getServerName_array() {
        return OS2200AttributeList.serverNames;
    }

    public void setServerName(String ip) throws ResourceException {
        OS2200AttributeList.serverName = ip;
        OS2200AttributeList.serverNames = OS2200ResourceAdapter.parseTokensToStringArray(ip, ";,");
    }

    public String getPortNumber() throws ResourceException {
        return OS2200AttributeList.portNumber;
    }

    public void setPortNumber(String port) throws ResourceException {
        OS2200AttributeList.portNumber = port;
    }

    public Integer getConnectionTO() throws ResourceException {
        return OS2200AttributeList.connectionTO;
    }

    public void setConnectionTO(Integer timeout) throws ResourceException {
        OS2200AttributeList.connectionTO = timeout;
    }

    public String getUserName() throws ResourceException {
        if (OS2200AttributeList.userName == null) {
            return new String("");
        }
        return OS2200AttributeList.userName;
    }

    public void setUserName(String name) throws ResourceException {
        OS2200AttributeList.userName = name;
    }

    public String getPassword() throws ResourceException {
        if (OS2200AttributeList.password == null) {
            return new String("");
        }
        return OS2200AttributeList.password;
    }

    public void setPassword(String pw) throws ResourceException {
        OS2200AttributeList.password = pw;
    }

    public Boolean getUseSecureConnection() throws ResourceException {
        return OS2200AttributeList.useSecureConnection;
    }

    public void setUseSecureConnection(Boolean secureConnectionValue) throws ResourceException {
        OS2200AttributeList.useSecureConnection = secureConnectionValue;
    }

    public Integer getMaximumCharacters() throws ResourceException {
        return OS2200AttributeList.maximumCharacters;
    }

    public void setMaximumCharacters(Integer maxChars) throws ResourceException {
        OS2200AttributeList.maximumCharacters = maxChars;
    }

    public Boolean getDebug() throws ResourceException {
        return OS2200AttributeList.debug;
    }

    public void setDebug(Boolean debugValue) throws ResourceException {
        OS2200ResourceAdapter.debug = debugValue;
        OS2200AttributeList.debug = debugValue;
    }

    public Boolean getLoggingEnabled() throws ResourceException {
        return OS2200AttributeList.loggingEnabled;
    }

    public void setLoggingEnabled(Boolean logging) throws ResourceException {
        OS2200ResourceAdapter.loggingEnabled = logging;
        OS2200AttributeList.loggingEnabled = logging;
    }

    public String getLogFilename() throws ResourceException {
        return OS2200AttributeList.logFilename;
    }

    public void setLogFilename(String filename) throws ResourceException {
        OS2200ResourceAdapter.setLogFilename(filename);
    }

    public Integer getInPort() {
        return OS2200AttributeList.inPort;
    }

    public void setInPort(Integer port) {
        OS2200AttributeList.inPort = port;
    }

    public Boolean getInboundUseSecureConnection() throws ResourceException {
        return OS2200AttributeList.useInboundSecureConnection;
    }

    public void setInboundUseSecureConnection(Boolean secureConnectionValue) throws ResourceException {
        OS2200AttributeList.useInboundSecureConnection = secureConnectionValue;
    }

    public Integer getRequestSocketTO() {
        return OS2200AttributeList.requestSocketTO;
    }

    public void setRequestSocketTO(Integer timeout) {
        OS2200AttributeList.requestSocketTO = timeout;
    }

    public Integer getServerSocketTO() {
        return OS2200AttributeList.serverSocketTO;
    }

    public void setServerSocketTO(Integer timeout) {
        OS2200AttributeList.serverSocketTO = timeout;
    }

    protected void decCurrentManagedConnections() {
        --this.currentManagedConnections;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof OS2200ManagedConnectionFactory) {
            String v1 = ((OS2200ManagedConnectionFactory)obj).getFactoryID();
            String v2 = this.factoryID;
            return v1 == null ? v2 == null : v1.equals(v2);
        }
        return false;
    }

    public int hashCode() {
        if (this.factoryID == null) {
            return new String("").hashCode();
        }
        return this.factoryID.hashCode();
    }
}

