/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200Connection;
import com.unisys.os2200.connector.OS2200ConnectionRequestInfo;
import com.unisys.os2200.connector.OS2200Credentials;
import com.unisys.os2200.connector.OS2200ManagedConnectionFactory;
import com.unisys.os2200.connector.OS2200ManagedConnectionMetaData;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import com.unisys.os2200.connector.WebtxHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class OS2200ManagedConnection
implements ManagedConnection {
    private OS2200ManagedConnectionFactory mcf;
    private Socket socket;
    private OS2200ManagedConnectionMetaData metaData;
    private PasswordCredential passCred;
    private String serverName;
    private String[] serverNames;
    private String portNumber;
    private String ENTER_USERID = "Enter your user-id/password and clearance level:";
    private String WAIT_LII = "*WAIT-LAST INPUT IGNORED*";
    private String SESSION_OK = "Current session number:";
    protected OS2200ConnectionRequestInfo cxRequestInfo;
    private int mcState;
    private boolean destroyed;
    private OutputStream outStream;
    private InputStream inStream;
    private PrintWriter logWriter;
    private transient HashSet connections = new HashSet(50);
    private Vector listeners;
    private WebtxHeader txHeader;
    private static final int WLII_RETRY_PERIOD = 60;
    private static final int AUTH_RETRY_PERIOD = 300;
    private static final int SESSION_OPEN_TIMEOUT_PERIOD = 4000;
    private byte[] OS2200DataIn;
    private byte[] OS2200DataOut;
    private byte[] OS2200UserPW;
    protected static final int MC_READY_STATE = 0;
    protected static final int MC_ACTIVE_STATE = 1;
    protected static final int MC_DESTROYED_STATE = 2;
    protected static final int MC_CLEAN_STATE = 3;
    protected static final int MAX_CONNECTIONS = 50;
    private static final String className = "OS2200ManagedConnection";

    OS2200ManagedConnection(OS2200ManagedConnectionFactory mcf, OS2200ConnectionRequestInfo requestInfo, PasswordCredential credentials, boolean supportsXA, boolean supportsLocalTx) throws ResourceException {
        if (requestInfo == null) {
            requestInfo = new OS2200ConnectionRequestInfo();
            requestInfo.setServerName(OS2200AttributeList.serverName);
            requestInfo.setPort(OS2200AttributeList.portNumber);
        }
        this.serverName = requestInfo.getServerName();
        this.serverNames = requestInfo.getServerName_array();
        this.portNumber = requestInfo.getPort();
        this.setMaximumCharacters(OS2200AttributeList.maximumCharacters);
        this.cxRequestInfo = requestInfo;
        this.setLogWriter(OS2200ResourceAdapter.getLogWriter());
        this.mcf = mcf;
        this.passCred = credentials;
        this.metaData = new OS2200ManagedConnectionMetaData(this);
        this.listeners = new Vector();
        this.txHeader = new WebtxHeader();
        this.OS2200DataIn = new byte[2 * this.getMaximumCharacters() + 32];
        this.OS2200DataOut = new byte[2 * this.getMaximumCharacters() + 32];
        this.connect();
        this.mcState = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws IllegalStateException, ResourceAdapterInternalException, ResourceException {
        PasswordCredential pc = null;
        this.checkIfDestroyed();
        if (subject != null) {
            pc = OS2200Credentials.getCredentials(this.mcf, subject, (OS2200ConnectionRequestInfo)connectionRequestInfo);
            if (pc == null) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getConnection", "SecurityException thrown: Invalid Password Credential.");
                throw new SecurityException("Invalid Password Credential.");
            }
        } else {
            String user = ((OS2200ConnectionRequestInfo)connectionRequestInfo).getUser();
            String password = ((OS2200ConnectionRequestInfo)connectionRequestInfo).getPassword();
            pc = new PasswordCredential(user, password.toCharArray());
        }
        if (!OS2200Credentials.isPasswordCredentialEqual(pc, this.passCred)) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "getConnection", "SecurityException thrown: Principal does not match. Reauthentication not supported.");
            throw new SecurityException("Principal does not match. Reauthentication not supported.");
        }
        OS2200Connection connection = new OS2200Connection(this);
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            this.connections.add(connection);
        }
        this.mcState = 1;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "getConnection", "getConnection() invoked.");
        return connection;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener instanceof ConnectionEventListener) {
            this.listeners.addElement(listener);
        }
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "addConnectionEventListener", "addConnectionEventListener() invoked.");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener instanceof ConnectionEventListener) {
            this.listeners.removeElement(listener);
        }
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "removeConnectionEventListener", "removeConnectionEventListener() invoked.");
    }

    public void associateConnection(Object connection) throws ResourceException, IllegalStateException {
        this.checkIfDestroyed();
        if (!(connection instanceof OS2200Connection)) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "associateConnection", "Resource Exception thrown. Invalid connection object.");
            throw new ResourceException("Invalid connection object on associateConnection() " + connection);
        }
        OS2200Connection con = (OS2200Connection)connection;
        con.associateConnection(this);
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "associateConnection", "associateConnection() invoked.");
    }

    public void cleanup() throws ResourceException, IllegalStateException {
        this.checkIfDestroyed();
        if (this.mcState == 0) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "cleanup", "cleanup() invoked with no active connections.");
            return;
        }
        if (this.mcState != 1) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "cleanup", "Illegal State Exception thrown. Invalid managedConnection state.");
            throw new IllegalStateException("Invalid managedConnection state");
        }
        for (OS2200Connection connection : this.connections) {
            connection.close();
        }
        this.mcState = 0;
        this.connections.clear();
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "cleanup", "cleanup() invoked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException, IllegalStateException, CommException {
        if (this.destroyed) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "destroy", "Illegal State Exception thrown. OS2200ManagedConnection already destroyed.");
            throw new IllegalStateException("OS2200ManagedConnection already destroyed");
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            if (!this.connections.isEmpty()) {
                try {
                    Iterator iterator = this.connections.iterator();
                    OS2200Connection connection = null;
                    while (iterator.hasNext()) {
                        connection = (OS2200Connection)iterator.next();
                        this.connections.remove(connection);
                    }
                    this.mcState = 2;
                }
                catch (Exception e) {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "destroy", "CommException thrown. " + e.getMessage() + ".");
                    CommException ce = new CommException(e.getMessage());
                    ce.initCause((Throwable)e);
                    throw ce;
                }
            }
        }
        this.mcf.decCurrentManagedConnections();
        this.mcf = null;
        this.cxRequestInfo = null;
        this.passCred = null;
        this.OS2200DataIn = null;
        this.OS2200DataOut = null;
        this.OS2200UserPW = null;
        this.connections = null;
        this.destroyed = true;
        this.mcState = 2;
        OS2200ResourceAdapter.logEvent(Level.INFO, className, "destroy", "OS2200ManagedConnection destroyed.");
    }

    private void connect() throws ResourceException {
        int i = 0;
        while (i < this.serverNames.length) {
            block11: {
                try {
                    if (this.cxRequestInfo.getSecureConnection()) {
                        OS2200ResourceAdapter.logEvent(Level.FINE, className, "connect", "Using secured connection (SSL/TLS).");
                        SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
                        SSLSocket sslSocket = (SSLSocket)sslFact.createSocket(OS2200AttributeList.serverNames[i], Integer.parseInt(this.portNumber));
                        if (sslSocket == null && i == OS2200AttributeList.serverNames.length - 1) {
                            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connect", "Socket Exception thrown. No peer SSL socket available.");
                            throw new SocketException("No peer SSL socket available");
                        }
                        sslSocket.startHandshake();
                        this.socket = sslSocket;
                    } else {
                        OS2200ResourceAdapter.logEvent(Level.FINE, className, "connect", "Using unsecured connection.");
                        this.socket = new Socket(this.serverNames[i], Integer.parseInt(this.portNumber));
                        if (this.socket == null) {
                            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connect", "Socket Exception thrown. No peer socket available.");
                            throw new SocketException("No peer socket available");
                        }
                    }
                    this.outStream = this.socket.getOutputStream();
                    this.inStream = this.socket.getInputStream();
                    OS2200ResourceAdapter.logEvent(Level.FINE, className, "connect", "Socket created.");
                    if (!this.passCred.getUserName().equals("")) {
                        this.socket.setSoTimeout(4000);
                        String dataRead = this.read();
                        dataRead = dataRead.substring(32, dataRead.length());
                        if (!this.authenticateUser(dataRead)) {
                            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connect", "User authentication failed. ");
                            throw new ResourceException("User authentication failed.");
                        }
                        dataRead = this.read();
                        OS2200ResourceAdapter.logEvent(Level.FINE, className, "connect", "User " + this.passCred.getUserName() + " authenticated.");
                    }
                    this.setConnectionTODefault();
                }
                catch (SocketTimeoutException ste) {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connect", "Socket Timeout Exception thrown. No response from 'session open'. " + ste.getMessage() + ".");
                    CommException ce = new CommException("Socket Timeout. No response from 'session open'. " + ste.getMessage() + ".");
                    ce.initCause((Throwable)ste);
                    if (i >= OS2200AttributeList.serverNames.length - 1) {
                        throw ce;
                    }
                }
                catch (IOException ioe) {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connect", "IO Exception thrown. " + ioe.getMessage() + ".");
                    ResourceException re = new ResourceException(ioe.getMessage());
                    re.initCause((Throwable)ioe);
                    if (i < OS2200AttributeList.serverNames.length - 1) break block11;
                    throw re;
                }
            }
            ++i;
        }
    }

    private void readWebtxHeader() throws ResourceException, CommException, SocketTimeoutException {
        int bytesRead = 0;
        try {
            int bytesToRead = 32;
            int i = 0;
            while (bytesRead < 32) {
                String headerData;
                ++i;
                int temp = this.inStream.read(this.OS2200DataIn, bytesRead, bytesToRead);
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "readWebtxHeader", "Number of bytes read = " + temp);
                if (temp == -1) {
                    if (i != 1) continue;
                    bytesRead = -1;
                    break;
                }
                bytesToRead -= temp;
                if ((bytesRead += temp) == 32 || this.verifyResponse(headerData = new String(this.OS2200DataIn, 0, bytesRead), 60)) continue;
                this.writeWebtxHeader();
                this.flushConnectRequest();
                this.readWebtxHeader();
                return;
            }
        }
        catch (SocketTimeoutException ste) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readWebtxHeader", "Socket Timeout Exception thrown. " + ste.getMessage() + ".");
            throw ste;
        }
        catch (IOException e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readWebtxHeader", "IO Exception thrown. " + e.getMessage() + ".");
            CommException ce = new CommException(e.getMessage());
            ce.initCause((Throwable)e);
            throw ce;
        }
        if (bytesRead == -1) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readWebtxHeader", "Resource Exception thrown. No data read from connection.");
            throw new ResourceException("No data read from connection");
        }
        if (bytesRead != 32) {
            String badHeaderData = new String(this.OS2200DataIn, 0, bytesRead);
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readWebtxHeader", "Resource Exception thrown. Invalid WebTx Header on reading data from connection. WebTx Header read = " + badHeaderData);
            throw new ResourceException("Invalid WebTx Header on reading data from connection WebTx Header read = " + badHeaderData);
        }
    }

    private void readWebtxHeaderData(int byteLen) throws ResourceException, CommException {
        try {
            int bytesRead = 0;
            int bytesToRead = byteLen;
            while (bytesRead < byteLen) {
                int temp = this.inStream.read(this.OS2200DataIn, 32 + bytesRead, bytesToRead);
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "readWebtxHeaderData", "Number of bytes read = " + temp);
                if (temp == -1) continue;
                bytesRead += temp;
                bytesToRead -= temp;
            }
            return;
        }
        catch (SocketTimeoutException ste) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readWebtxHeaderData", "Socket Timeout Exception thrown. " + ste.getMessage() + ".");
            CommException ce = new CommException(ste.getMessage());
            ce.initCause((Throwable)ste);
            throw ce;
        }
        catch (IOException e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readWebtxHeaderData", "IO Exception thrown. " + e.getMessage() + ".");
            CommException ce = new CommException(e.getMessage());
            this.sendEvent(5, (Exception)ce);
            ce.initCause((Throwable)e);
            throw ce;
        }
    }

    private void writeWebtxHeader() throws ResourceException, CommException {
        try {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "writeWebtxHeader", "bytelength = " + (this.txHeader.databytelength + 32));
            this.outStream.write(this.OS2200DataOut, 0, this.txHeader.databytelength + 32);
        }
        catch (SocketException e) {
            OS2200ResourceAdapter.logEvent(Level.WARNING, className, "writeWebtxHeader", "Socket Exception thrown, try to reconnect: " + e.getMessage() + ".");
            this.connect();
            try {
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "writeWebtxHeader", "New connection granted, retry write. ");
                this.outStream.write(this.OS2200DataOut, 0, this.txHeader.databytelength + 32);
            }
            catch (IOException ioe) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "writeWebtxHeader", "IO Exception thrown. " + ioe.getMessage() + ".");
                CommException ioce = new CommException(ioe.getMessage());
                this.sendEvent(5, (Exception)ioce);
                ioce.initCause((Throwable)ioe);
                throw ioce;
            }
        }
        catch (IOException e) {
            OS2200ResourceAdapter.logEvent(Level.WARNING, className, "writeWebtxHeader", "IO Exception thrown, try to reconnect: " + e.getMessage() + ".");
            this.connect();
            try {
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "writeWebtxHeader", "New connection granted, retry write. ");
                this.outStream.write(this.OS2200DataOut, 0, this.txHeader.databytelength + 32);
            }
            catch (IOException ioe) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "writeWebtxHeader", "IO Exception thrown. " + ioe.getMessage() + ".");
                CommException ioce = new CommException(ioe.getMessage());
                this.sendEvent(5, (Exception)ioce);
                ioce.initCause((Throwable)ioe);
                throw ioce;
            }
        }
    }

    private void flushConnectRequest() throws ResourceException, CommException {
        try {
            this.outStream.flush();
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "flushConnectRequest", "flushConnectRequest() invoked.");
        }
        catch (IOException e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "flushConnectRequest", "IO Exception thrown. " + e.getMessage() + ".");
            CommException ce = new CommException("IO Exception on flushConnectRequest().");
            this.sendEvent(5, (Exception)ce);
            ce.initCause((Throwable)e);
            throw ce;
        }
    }

    protected String read() throws ResourceException, SocketTimeoutException {
        try {
            this.readWebtxHeader();
            String dataReadHdr = new String(this.OS2200DataIn, 0, 32);
            String dataLengthStr = new String(this.OS2200DataIn, 7, 6);
            dataLengthStr = dataLengthStr.trim();
            Integer dataLengthInt = new Integer(dataLengthStr);
            int dataLength = dataLengthInt - 32;
            if (dataLength > this.getMaximumCharacters()) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "read", "ResourceException thrown. Internal message buffer is not large enough to accommodate transaction message.");
                throw new ResourceException("OS 2200 TIP Connector internal message buffer is not large enough to accommodate transaction message. Increase 'MaximumCharacters' config-property value to " + dataLength + " or more.");
            }
            this.readWebtxHeaderData(dataLength);
            String dataReadUser = new String(this.OS2200DataIn, 32, dataLength);
            if (!this.verifyResponse(dataReadUser, 60)) {
                this.writeWebtxHeader();
                this.flushConnectRequest();
                String dataRead = this.read();
                return dataRead;
            }
            String dataRead = dataReadHdr.concat(dataReadUser);
            return dataRead;
        }
        catch (NumberFormatException nfe) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "read", "WebTx Header read = " + new String(this.OS2200DataIn, 0, 32));
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "read", "Number Format Exception thrown. WebTxHeader data length field invalid.");
            ResourceException re = new ResourceException("Number Format Exception in WebTxHeader data length field.");
            re.initCause((Throwable)nfe);
            throw re;
        }
    }

    protected void write(String functionName, String viewName, String wrData) throws ResourceException {
        this.txHeader.setTrancode(functionName);
        this.txHeader.setViewname(viewName);
        this.txHeader.setData(wrData);
        this.OS2200DataOut = this.txHeader.getBytecode();
        if (this.txHeader.datalength > this.getMaximumCharacters()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "write", "ResourceException thrown. Internal message buffer is not large enough to accommodate transaction message.");
            throw new ResourceException("OS 2200 TIP Connector internal message buffer is not large enough to accommodate transaction message. Increase 'MaximumCharacters' config-property value to " + this.txHeader.datalength + " or more.");
        }
        this.writeWebtxHeader();
        this.flushConnectRequest();
    }

    protected String execute(String functionName, String viewName, String wrData) throws ResourceException {
        String dataRead;
        try {
            this.write(functionName, viewName, wrData);
        }
        catch (IllegalArgumentException iae) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Illegal Argument Exception thrown. " + iae.getMessage() + ".");
            ResourceException re = new ResourceException(iae.getMessage());
            re.initCause((Throwable)iae);
            throw re;
        }
        try {
            dataRead = this.read();
        }
        catch (SocketTimeoutException ste) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Socket Timeout Exception thrown. " + ste.getMessage() + ".");
            ResourceException re = new ResourceException(ste.getMessage());
            re.initCause((Throwable)ste);
            throw re;
        }
        return dataRead;
    }

    protected ByteBuffer readBytes() throws ResourceException, SocketTimeoutException {
        try {
            this.readWebtxHeader();
            String dataReadHdr = new String(this.OS2200DataIn, 0, 32);
            String dataLengthStr = new String(this.OS2200DataIn, 7, 6);
            dataLengthStr = dataLengthStr.trim();
            Integer dataLengthInt = new Integer(dataLengthStr);
            int dataLength = dataLengthInt - 32;
            if (dataLength > this.getMaximumCharacters()) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readBytes", "ResourceException thrown. Internal message buffer is not large enough to accommodate transaction message.");
                throw new ResourceException("OS 2200 TIP Connector internal message buffer is not large enough to accommodate transaction message. Increase 'MaximumCharacters' config-property value to " + dataLength + " or more.");
            }
            this.readWebtxHeaderData(dataLength);
            ByteBuffer dataRead = ByteBuffer.allocate(dataLength + 32);
            String dataReadUser = new String(this.OS2200DataIn, 32, dataLength);
            if (!this.verifyResponse(dataReadUser, 60)) {
                this.writeWebtxHeader();
                this.flushConnectRequest();
                dataRead = this.readBytes();
                dataRead.rewind();
                return dataRead;
            }
            dataRead.put(this.OS2200DataIn, 0, dataLength + 32);
            dataRead.rewind();
            return dataRead;
        }
        catch (NumberFormatException nfe) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "readBytes", "WebTx Header read = " + new String(this.OS2200DataIn, 0, 32));
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "readBytes", "Number Format Exception thrown. WebTxHeader data length field invalid.");
            ResourceException re = new ResourceException("Number Format Exception in WebTxHeader data length field.");
            re.initCause((Throwable)nfe);
            throw re;
        }
    }

    protected void writeBytes(String functionName, String viewName, ByteBuffer wrData) throws ResourceException {
        this.txHeader.setTrancode(functionName);
        this.txHeader.setViewname(viewName);
        this.txHeader.setData(wrData.array());
        this.OS2200DataOut = this.txHeader.getBytes();
        if (this.txHeader.datalength > this.getMaximumCharacters()) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "writeBytes", "ResourceException thrown. Internal message buffer is not large enough to accommodate transaction message.");
            throw new ResourceException("OS 2200 TIP Connector internal message buffer is not large enough to accommodate transaction message. Increase 'MaximumCharacters' config-property value to " + this.txHeader.datalength + " or more.");
        }
        this.writeWebtxHeader();
        this.flushConnectRequest();
    }

    protected ByteBuffer executeBytes(String functionName, String viewName, ByteBuffer wrData) throws ResourceException {
        ByteBuffer dataRead;
        try {
            this.writeBytes(functionName, viewName, wrData);
        }
        catch (IllegalArgumentException iae) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "executeBytes", "Illegal Argument Exception thrown. " + iae.getMessage() + ".");
            ResourceException re = new ResourceException(iae.getMessage());
            re.initCause((Throwable)iae);
            throw re;
        }
        try {
            dataRead = this.readBytes();
        }
        catch (SocketTimeoutException ste) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "executeBytes", "Socket Timeout Exception thrown. " + ste.getMessage() + ".");
            ResourceException re = new ResourceException(ste.getMessage());
            re.initCause((Throwable)ste);
            throw re;
        }
        return dataRead;
    }

    private boolean verifyResponse(String response, int waitValue) throws ResourceException {
        boolean returnValue = true;
        if ((response = response.trim()).equalsIgnoreCase(this.WAIT_LII)) {
            try {
                Thread.sleep(waitValue);
            }
            catch (InterruptedException ie) {
                OS2200ResourceAdapter.logEvent(Level.INFO, className, "verifyResponse", "Interrupted Exception caught and ignored.");
            }
            OS2200ResourceAdapter.logEvent(Level.INFO, className, "verifyResponse", "*WAIT-LAST INPUT INGORED* received; retry attempted after " + waitValue + " milliseconds.");
            returnValue = false;
        }
        return returnValue;
    }

    private boolean authenticateUser(String response) throws IOException, ResourceException {
        boolean authenticateValue = false;
        boolean bytesRead = false;
        int bytesToRead = this.SESSION_OK.length();
        String userString = new String("");
        String authenticateResponse = response;
        if ((authenticateResponse = authenticateResponse.trim()).equalsIgnoreCase(this.ENTER_USERID)) {
            int authenticateLength;
            WebtxHeader authenticateHeader = new WebtxHeader();
            authenticateHeader.setTrancode(" ");
            authenticateHeader.setViewname("");
            userString = userString.concat(this.passCred.getUserName());
            userString = userString.concat("/");
            userString = userString.concat(new String(this.passCred.getPassword()));
            authenticateHeader.setData(userString);
            this.OS2200UserPW = new byte[userString.length() + 32];
            this.OS2200UserPW = authenticateHeader.getBytecode();
            do {
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "authenticateUser", "Number of bytes written = " + this.OS2200UserPW.length);
                this.outStream.write(this.OS2200UserPW, 0, this.OS2200UserPW.length);
                this.flushConnectRequest();
                this.readWebtxHeader();
                String authenticateReadHdr = new String(this.OS2200DataIn, 0, 32);
                String authenticateLengthStr = new String(this.OS2200DataIn, 7, 6);
                authenticateLengthStr = authenticateLengthStr.trim();
                authenticateLength = new Integer(authenticateLengthStr) - 32;
                if (authenticateLength > this.getMaximumCharacters()) {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "authenticateUser", "ResourceException thrown. Internal message buffer is not large enough to accomodate authentication message.");
                    throw new ResourceException("OS 2200 TIP Connector internal message buffer is not large enough to accomodate authentication message. Increase 'MaximumCharacters' config-property value to " + authenticateLength + " or more.");
                }
                this.readWebtxHeaderData(authenticateLength);
            } while (!this.verifyResponse(authenticateResponse = new String(this.OS2200DataIn, 32, authenticateLength), 300));
            String authenticateResponseDataTrimmed = authenticateResponse.substring(0, this.SESSION_OK.length());
            if (authenticateResponseDataTrimmed.equalsIgnoreCase(this.SESSION_OK)) {
                authenticateValue = true;
            }
        }
        return authenticateValue;
    }

    private void checkIfDestroyed() throws IllegalStateException {
        if (this.mcState == 2) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "checkIfDestroyed", "Illegal State Exception thrown. Managed connection already destroyed.");
            throw new IllegalStateException("Managed connection already destroyed");
        }
    }

    public void addConnection(OS2200Connection connection) {
        this.connections.add(connection);
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "addConnection", "addConnection() invoked.");
    }

    public void removeConnection(OS2200Connection connection) {
        this.connections.remove(connection);
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "removeConnection", "removeConnection() invoked.");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        OS2200ResourceAdapter.logEvent(Level.WARNING, className, "getLocalTransaction", "NotSupportedException thrown. LocalTransaction not supported.");
        throw new NotSupportedException("LocalTransaction not supported.");
    }

    public XAResource getXAResource() throws ResourceException {
        OS2200ResourceAdapter.logEvent(Level.WARNING, className, "getXAResource", "NotSupportedException thrown. XAResource not supported.");
        throw new NotSupportedException("XAResource not supported.");
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.metaData;
    }

    public String getServerName() throws ResourceException {
        return OS2200AttributeList.serverName;
    }

    public String[] getServerName_array() {
        return OS2200AttributeList.serverNames;
    }

    public void setServerName(String ip) throws ResourceException {
        OS2200AttributeList.serverName = ip;
        OS2200AttributeList.serverNames = OS2200ResourceAdapter.parseTokensToStringArray(this.serverName, ";,");
    }

    public String getPortNumber() throws ResourceException {
        return OS2200AttributeList.portNumber;
    }

    public void setPortNumber(String port) throws ResourceException {
        OS2200AttributeList.portNumber = port;
    }

    public Integer getConnectionTO() throws ResourceException {
        return OS2200AttributeList.connectionTO;
    }

    public void setConnectionTO(Integer timeout) throws ResourceException {
        OS2200AttributeList.connectionTO = timeout;
    }

    public Boolean getUseSecureConnection() throws ResourceException {
        return OS2200AttributeList.useSecureConnection;
    }

    public void setUseSecureConnection(Boolean secureConnectionValue) throws ResourceException {
        OS2200AttributeList.useSecureConnection = secureConnectionValue;
    }

    public Integer getMaximumCharacters() throws ResourceException {
        return OS2200AttributeList.maximumCharacters;
    }

    public void setMaximumCharacters(Integer maxChars) throws ResourceException {
        OS2200AttributeList.maximumCharacters = maxChars;
    }

    public Integer getInPort() throws ResourceException {
        return OS2200AttributeList.inPort;
    }

    public void setInPort(Integer port) throws ResourceException {
        OS2200AttributeList.inPort = port;
    }

    public Boolean getInboundUseSecureConnection() throws ResourceException {
        return OS2200AttributeList.useInboundSecureConnection;
    }

    public void setInboundUseSecureConnection(Boolean secureConnectionValue) throws ResourceException {
        OS2200AttributeList.useInboundSecureConnection = secureConnectionValue;
    }

    public Integer getRequestSocketTO() throws ResourceException {
        return OS2200AttributeList.requestSocketTO;
    }

    public void setRequestSocketTO(Integer timeout) throws ResourceException {
        OS2200AttributeList.requestSocketTO = timeout;
    }

    public Integer getServerSocketTO() throws ResourceException {
        return OS2200AttributeList.serverSocketTO;
    }

    public void setServerSocketTO(Integer timeout) throws ResourceException {
        OS2200AttributeList.serverSocketTO = timeout;
    }

    public OS2200ConnectionRequestInfo getConnectionRequestInfo() {
        return this.cxRequestInfo;
    }

    protected void setConnectionTODefault() throws ResourceException {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.setSoTimeout(this.cxRequestInfo.getTimeout());
            }
        }
        catch (SocketException se) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "setConnectionTODefault", "Socket Exception thrown. " + se.getMessage() + ".");
            ResourceException re = new ResourceException(se.getMessage());
            re.initCause((Throwable)se);
            throw re;
        }
    }

    protected void sendEvent(int eventType, Exception ex) {
        ConnectionEvent ce = null;
        ConnectionEventListener l = null;
        Vector list = (Vector)this.listeners.clone();
        ce = ex == null ? new ConnectionEvent((ManagedConnection)this, eventType) : new ConnectionEvent((ManagedConnection)this, eventType, ex);
        int i = 0;
        while (i < list.size()) {
            l = (ConnectionEventListener)list.elementAt(i);
            l.connectionClosed(ce);
            ++i;
        }
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "sendEvent", "sendEvent(eventType, exception) invoked: eventType = " + eventType);
    }

    protected void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        ConnectionEvent ce = null;
        ConnectionEventListener l = null;
        Vector list = (Vector)this.listeners.clone();
        ce = ex == null ? new ConnectionEvent((ManagedConnection)this, eventType) : new ConnectionEvent((ManagedConnection)this, eventType, ex);
        ce.setConnectionHandle(connectionHandle);
        int i = 0;
        while (i < list.size()) {
            l = (ConnectionEventListener)list.elementAt(i);
            l.connectionClosed(ce);
            ++i;
        }
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "sendEvent", "sendEvent(eventType, exception, connectionHandle) invoked: eventType = " + eventType);
    }

    protected OS2200ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    protected int getCurrentState() {
        return this.mcState;
    }

    public synchronized boolean isDestroyed() {
        return this.mcState == 2;
    }
}

