/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200Connection;
import com.unisys.os2200.connector.OS2200InteractionSpec;
import com.unisys.os2200.connector.OS2200ManagedConnection;
import com.unisys.os2200.connector.OS2200Record;
import com.unisys.os2200.connector.OS2200Request;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import com.unisys.os2200.connector.OS2200Xoctet;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapterInternalException;

public class OS2200Interaction
implements Interaction {
    private static final int INPUT_RECORD = 0;
    private static final int OUTPUT_RECORD = 1;
    private static final int IDLE_STATE = 1;
    private static final int ACTIVE_STATE = 2;
    private static final int CLOSED_STATE = 3;
    private int state;
    OS2200ManagedConnection mc;
    private OS2200Connection connection;
    private static final String className = "OS2200Interaction";

    public OS2200Interaction(OS2200Connection connection) throws ResourceException, ResourceAdapterInternalException {
        if (connection == null) {
            NullPointerException npe = new NullPointerException("OS2200Connection is null.");
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException("OS2200Connection is null.");
            raie.initCause((Throwable)npe);
            throw raie;
        }
        this.connection = connection;
        this.mc = connection.getManagedConnection();
        this.state = 1;
    }

    public void clearWarnings() throws ResourceException {
        this.verifyInteractionState();
    }

    public void close() throws ResourceException {
        this.setState(3);
        this.connection.destroyInteraction(this);
        this.connection = null;
    }

    protected void closeInteraction() throws IllegalStateException {
        if (this.state == 3) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "closeInteraction", "IllegalState Exception thrown. Interaction already Closed.");
            throw new IllegalStateException("Interaction already Closed");
        }
        this.state = 3;
        this.connection = null;
    }

    public Record execute(InteractionSpec iSpec, Record inRecord) throws ResourceException, ResourceAdapterInternalException {
        boolean result = false;
        this.setState(2);
        OS2200Record outRecord = inRecord instanceof OS2200Request ? new OS2200Request() : new OS2200Xoctet();
        try {
            if (!(iSpec instanceof OS2200InteractionSpec)) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. Invalid InteractionSpec!");
                throw new ResourceException("Invalid InteractionSpec!");
            }
            OS2200InteractionSpec OS2200Ispec = (OS2200InteractionSpec)iSpec;
            int interactionVerb = OS2200Ispec.getInteractionVerb();
            String functionName = OS2200Ispec.getFunctionName();
            switch (interactionVerb) {
                case 0: {
                    this.verifyRecord(inRecord, 0);
                    result = inRecord instanceof OS2200Request ? this.mcWrite(functionName, (OS2200Request)inRecord) : this.mcWrite(functionName, (OS2200Xoctet)inRecord);
                    break;
                }
                case 2: {
                    result = outRecord instanceof OS2200Request ? this.mcRead((OS2200Request)outRecord) : this.mcRead((OS2200Xoctet)outRecord);
                    break;
                }
                case 1: {
                    this.verifyRecord(inRecord, 0);
                    result = inRecord instanceof OS2200Request ? this.mcExecute(functionName, (OS2200Request)inRecord, (OS2200Request)outRecord) : this.mcExecute(functionName, (OS2200Xoctet)inRecord, (OS2200Xoctet)outRecord);
                    break;
                }
                default: {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. Illegal verb = " + interactionVerb);
                    throw new ResourceException("Illegal verb = " + interactionVerb);
                }
            }
        }
        catch (ResourceException re) {
            this.setState(1);
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. " + re.getMessage());
            throw re;
        }
        this.setState(1);
        if (result) {
            return outRecord;
        }
        return null;
    }

    public boolean execute(InteractionSpec iSpec, Record inRecord, Record outRecord) throws ResourceException {
        this.setState(2);
        boolean result = false;
        try {
            if (!(iSpec instanceof OS2200InteractionSpec)) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. Invalid InteractionSpec!");
                throw new ResourceException("Invalid InteractionSpec!");
            }
            OS2200InteractionSpec OS2200Ispec = (OS2200InteractionSpec)iSpec;
            int interactionVerb = OS2200Ispec.getInteractionVerb();
            String functionName = OS2200Ispec.getFunctionName();
            switch (interactionVerb) {
                case 0: {
                    this.verifyRecord(inRecord, 0);
                    result = inRecord instanceof OS2200Request ? this.mcWrite(functionName, (OS2200Request)inRecord) : this.mcWrite(functionName, (OS2200Xoctet)inRecord);
                    break;
                }
                case 2: {
                    this.verifyRecord(outRecord, 1);
                    result = outRecord instanceof OS2200Request ? this.mcRead((OS2200Request)outRecord) : this.mcRead((OS2200Xoctet)outRecord);
                    break;
                }
                case 1: {
                    this.verifyRecord(inRecord, 0);
                    this.verifyRecord(outRecord, 1);
                    if (inRecord instanceof OS2200Request && outRecord instanceof OS2200Request) {
                        result = this.mcExecute(functionName, (OS2200Request)inRecord, (OS2200Request)outRecord);
                        break;
                    }
                    if (inRecord instanceof OS2200Xoctet && outRecord instanceof OS2200Xoctet) {
                        result = this.mcExecute(functionName, (OS2200Xoctet)inRecord, (OS2200Xoctet)outRecord);
                        break;
                    }
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. OS2200Record mismatch: Input and output records must be of the same OS2200Record subclass.");
                    throw new ResourceException("OS2200Record mismatch: Input and output records must be of the same OS2200Record subclass.");
                }
                default: {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. Illegal verb = " + interactionVerb);
                    throw new ResourceException("illegal verb = " + interactionVerb);
                }
            }
        }
        catch (ResourceException re) {
            this.setState(1);
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "execute", "Resource Exception thrown. " + re.getMessage());
            throw re;
        }
        this.setState(1);
        return result;
    }

    public synchronized Connection getConnection() {
        return this.state == 3 ? null : this.connection;
    }

    public ResourceWarning getWarnings() throws ResourceException {
        this.verifyInteractionState();
        return null;
    }

    protected void finalize() {
        try {
            if (this.state != 3) {
                this.closeInteraction();
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    private void verifyInteractionState() throws IllegalStateException {
        if (this.state == 3) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "verifyInteractionState", "Resource Exception thrown. OS2200Interaction is closed.");
            throw new IllegalStateException("OS2200Interaction is closed");
        }
        if (this.connection == null) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "verifyInteractionState", "Resource Exception thrown. Connection is not active.");
            throw new IllegalStateException("Connection is not active.");
        }
    }

    private boolean mcRead(OS2200Request record) throws ResourceException {
        String rdData;
        if (this.mc == null) {
            return false;
        }
        try {
            rdData = this.mc.read();
        }
        catch (SocketTimeoutException ste) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "mcRead", "Socket Timeout Exception thrown. " + ste.getMessage());
            ResourceException re = new ResourceException(ste.getMessage());
            re.initCause((Throwable)ste);
            throw re;
        }
        if (rdData.length() == 0) {
            return false;
        }
        String data = rdData.substring(32, rdData.length());
        record.setData(data);
        String rdView = rdData.substring(13, 29);
        record.setRecordName(rdView);
        return true;
    }

    private boolean mcWrite(String functionName, OS2200Request record) throws ResourceException {
        OS2200ManagedConnection mc = this.connection.getManagedConnection();
        if (mc == null) {
            return false;
        }
        String wrData = new String(record.getData());
        String viewName = new String(record.getRecordName());
        mc.write(functionName, viewName, wrData);
        return true;
    }

    private boolean mcExecute(String functionName, OS2200Request inRecord, OS2200Request outRecord) throws ResourceException {
        if (this.mc == null) {
            return false;
        }
        String wrData = new String(inRecord.getData());
        String viewName = new String(inRecord.getRecordName());
        String rdData = this.mc.execute(functionName, viewName, wrData);
        String data = rdData.substring(32, rdData.length());
        outRecord.setData(data);
        String rdView = rdData.substring(13, 29);
        outRecord.setRecordName(rdView);
        return true;
    }

    private boolean mcRead(OS2200Xoctet record) throws ResourceException {
        ByteBuffer rdData;
        if (this.mc == null) {
            return false;
        }
        try {
            rdData = this.mc.readBytes();
        }
        catch (SocketTimeoutException ste) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "mcRead", "Socket Timeout Exception thrown. " + ste.getMessage());
            ResourceException re = new ResourceException(ste.getMessage());
            re.initCause((Throwable)ste);
            throw re;
        }
        int byteDataLen = rdData.array().length;
        if (byteDataLen == 0) {
            return false;
        }
        byte[] byteData = new byte[byteDataLen - 32];
        rdData.position(32);
        rdData.get(byteData, 0, byteDataLen - 32);
        record.setData(byteData);
        byte[] byteRecordName = new byte[16];
        rdData.position(13);
        rdData.get(byteRecordName, 0, 16);
        record.setRecordName(new String(byteRecordName));
        return true;
    }

    private boolean mcWrite(String functionName, OS2200Xoctet record) throws ResourceException {
        OS2200ManagedConnection mc = this.connection.getManagedConnection();
        if (mc == null) {
            return false;
        }
        ByteBuffer wrData = ByteBuffer.wrap(record.getData());
        String viewName = new String(record.getRecordName());
        mc.writeBytes(functionName, viewName, wrData);
        return true;
    }

    private boolean mcExecute(String functionName, OS2200Xoctet inRecord, OS2200Xoctet outRecord) throws ResourceException {
        if (this.mc == null) {
            return false;
        }
        ByteBuffer wrData = ByteBuffer.wrap(inRecord.getData());
        String viewName = new String(inRecord.getRecordName());
        ByteBuffer rdData = this.mc.executeBytes(functionName, viewName, wrData);
        int byteDataLen = rdData.array().length;
        if (byteDataLen == 0) {
            return false;
        }
        byte[] byteData = new byte[byteDataLen - 32];
        rdData.position(32);
        rdData.get(byteData, 0, byteDataLen - 32);
        outRecord.setData(byteData);
        byte[] byteRecordName = new byte[16];
        rdData.position(13);
        rdData.get(byteRecordName, 0, 16);
        outRecord.setRecordName(new String(byteRecordName));
        return true;
    }

    private void verifyRecord(Record record, int recordType) throws ResourceException {
        if (record == null) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "verifyRecord", "Resource Exception thrown. Record = null.");
            throw new ResourceException("Null " + (recordType == 0 ? "input" : "output") + " record!");
        }
        if (!(record instanceof OS2200Request) && !(record instanceof OS2200Xoctet)) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "verifyRecord", "Resource Exception thrown. Record is not an instance of OS2200Record.");
            throw new ResourceException("Unknown " + (recordType == 0 ? "input" : "output") + " record!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) throws IllegalStateException, ResourceAdapterInternalException {
        OS2200Interaction oS2200Interaction = this;
        synchronized (oS2200Interaction) {
            if (newState < 1 || newState > 3) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "setState", "Illegal State exception thrown. State change is illegal.");
                throw new IllegalStateException("Unknown state: " + newState);
            }
            switch (this.state) {
                case 3: {
                    if (newState == 3) {
                        OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "setState", "Illegal State exception thrown. Interaction already closed.");
                        throw new IllegalStateException("Interaction already closed");
                    }
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "setState", "Illegal State exception thrown. Interaction is closed.");
                    throw new IllegalStateException("Interaction is closed");
                }
                case 1: {
                    this.state = newState;
                    break;
                }
                case 2: {
                    if (newState == 3) {
                        OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "setState", "Illegal State exception thrown. Interaction is active.");
                        throw new IllegalStateException("Interaction is active");
                    }
                    this.state = newState;
                    break;
                }
                default: {
                    OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "setState", "Resource Adapter Internal Exception thrown. Interaction in unknown state.");
                    throw new ResourceAdapterInternalException("Interaction in unknown state " + this.state);
                }
            }
        }
    }
}

