/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import com.unisys.os2200.connector.OS2200WorkRequestHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;

public class OS2200InboundWork
implements Work {
    private boolean active = false;
    private int maxRH;
    private long requestCount = 0L;
    private ServerSocket ss;
    private SSLServerSocket sslSvrSocket;
    private Socket s;
    private SSLSocket ssls;
    private WorkManager workManager;
    private static final String className = "OS2200InboundWork";

    public OS2200InboundWork(WorkManager workManager) throws IOException, SocketException, UnknownHostException {
        this.workManager = workManager;
        if (OS2200AttributeList.useInboundSecureConnection.booleanValue()) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Using inbound secured connection (SSL/TLS).");
            SSLServerSocketFactory sslSrvFact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.sslSvrSocket = (SSLServerSocket)sslSrvFact.createServerSocket(OS2200AttributeList.inPort, this.maxRH, null);
            this.ss = this.sslSvrSocket;
        } else {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Using inbound unsecured connection.");
            this.ss = new ServerSocket(OS2200AttributeList.inPort, this.maxRH, null);
        }
        this.ss.setSoTimeout(OS2200AttributeList.serverSocketTO);
        this.active = true;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "Inbound server socket created.");
    }

    public void release() {
        this.active = false;
        try {
            if (!this.ss.isClosed()) {
                this.ss.close();
                OS2200ResourceAdapter.logEvent(Level.INFO, className, "release", "Inbound server socket connection closed.");
            }
        }
        catch (IOException e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "release", "Unable to close the inbound server socket.");
        }
    }

    public void run() {
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "run", "Entering run() in OS2200InboundWork");
        while (this.active) {
            try {
                if (OS2200AttributeList.useInboundSecureConnection.booleanValue()) {
                    this.ssls = (SSLSocket)this.sslSvrSocket.accept();
                    this.s = this.ssls;
                } else {
                    this.s = this.ss.accept();
                }
                ++this.requestCount;
                OS2200WorkRequestHandler inboundWorkRequest = new OS2200WorkRequestHandler(this.s, this.requestCount);
                this.workManager.startWork((Work)inboundWorkRequest);
            }
            catch (InterruptedIOException e) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "The inbound server socket for the OS 2200 Connector inbound listener has timed out.  Shutting down the OS 2200 Connector inbound listener. InterruptedIOException thrown: " + e.getMessage());
                this.release();
            }
            catch (SocketException se) {
                if (!this.active) continue;
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "SocketException thrown. " + se.getMessage());
            }
            catch (IOException ioe) {
                OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "run", "IOException thrown. " + ioe.getMessage());
                this.release();
            }
            catch (WorkException workException) {
                // empty catch block
            }
        }
    }
}

