/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200HeaderException;

public class OS2200Header {
    private String headerStr = "";
    private String pktID = "";
    private String intfLevel = "";
    private String status = "";
    private String inputType = "";
    private String outputType = "";
    private String beanName = "";
    private String beanType = "";
    private String byteLen = "";
    private String filler = "";
    private static final int pktID_start = 0;
    private static final int intfLevel_start = 4;
    private static final int status_start = 5;
    private static final int inputType_start = 8;
    private static final int outputType_start = 12;
    private static final int beanName_start = 16;
    private static final int beanType_start = 52;
    private static final int byteLen_start = 56;
    private static final int filler_start = 66;
    private static final int pktID_size = 4;
    private static final int intfLevel_size = 1;
    private static final int status_size = 3;
    private static final int inputType_size = 4;
    private static final int outputType_size = 4;
    private static final int beanName_size = 36;
    private static final int beanType_size = 4;
    private static final int byteLen_size = 10;
    private static final int filler_size = 6;
    public static final String HEADER_ID = "TIPJ";
    public static final int HEADER_SIZE = 72;
    public static final String VERSION1 = "1";
    public static final String VERSION2 = "2";
    public static final String CHAR = "CHAR";
    public static final String BYTE = "BYTE";
    public static final String REMOTE = "REM ";
    public static final String EJB2 = "EJB2";
    public static final String EJB3 = "EJB3";
    public static final String POJO = "POJO";
    public static final int ERR_OK = 0;
    public static final int ERR_PKTID = 1;
    public static final int ERR_INFLEVEL = 2;
    public static final int ERR_INPUTTYPE = 3;
    public static final int ERR_OUTPUTTYPE = 4;
    public static final int ERR_BEANTYPE = 5;
    public static final int ERR_OS2200HeaderException_Request = 6;
    public static final int ERR_EJBException = 7;
    public static final int ERR_InterruptedIOException = 8;
    public static final int ERR_SocketException = 9;
    public static final int ERR_IOException = 10;
    public static final int ERR_CreateException = 11;
    public static final int ERR_NamingException = 12;
    public static final int ERR_RemoteException = 13;
    public static final int ERR_ClassCastException = 14;
    public static final int ERR_OS2200HeaderException_Response = 15;
    public static final int ERR_Exception = 16;

    public OS2200Header(String headerStr) throws OS2200HeaderException {
        int len = headerStr.length();
        if (len != 72) {
            throw new OS2200HeaderException("Invalid size for input header string.  Length = " + len + " Input = >" + headerStr + "<");
        }
        this.headerStr = headerStr;
        this.parse();
    }

    public OS2200Header(String pktID, String intfLevel, String status, String inputType, String outputType, String beanName, String beanType, String byteLen) throws OS2200HeaderException {
        StringBuffer temp;
        this.pktID = pktID;
        this.intfLevel = intfLevel;
        this.status = status;
        this.inputType = inputType;
        this.outputType = outputType;
        this.beanName = beanName;
        this.beanType = beanType;
        int len = 3 - status.length();
        if (len > 0) {
            temp = this.createFilledStringBuffer(len, '0');
            status = String.valueOf(temp.toString()) + status;
        }
        status.trim();
        if (status.length() == 0) {
            status = new String("000");
        }
        this.status = status;
        len = 10 - byteLen.length();
        if (len > 0) {
            temp = this.createFilledStringBuffer(len, '0');
            byteLen = String.valueOf(temp.toString()) + byteLen;
        }
        this.byteLen = byteLen;
        this.filler = this.createFilledStringBuffer(6, ' ').toString();
        this.unparse();
    }

    private StringBuffer addField(StringBuffer buf, String fieldName, String field, int maxLen) throws OS2200HeaderException {
        int len = field.length();
        if (len > maxLen) {
            throw new OS2200HeaderException("Invalid size for field " + fieldName + ".  value: >" + field + "< size: " + len);
        }
        if (len < maxLen) {
            StringBuffer temp = this.createFilledStringBuffer(maxLen - len, ' ');
            field = String.valueOf(field) + temp.toString();
            if (fieldName.compareTo("pktID") == 0) {
                this.pktID = field;
            }
            if (fieldName.compareTo("intfLevel") == 0) {
                this.intfLevel = field;
            }
            if (fieldName.compareTo("status") == 0) {
                this.status = field;
            }
            if (fieldName.compareTo("inputType") == 0) {
                this.inputType = field;
            }
            if (fieldName.compareTo("outputType") == 0) {
                this.outputType = field;
            }
            if (fieldName.compareTo("beanName") == 0) {
                this.beanName = field;
            }
            if (fieldName.compareTo("beanType") == 0) {
                this.beanType = field;
            }
            if (fieldName.compareTo("byteLen") == 0) {
                this.byteLen = field;
            }
            if (fieldName.compareTo("filler") == 0) {
                this.filler = field;
            }
        }
        buf.append(field);
        return buf;
    }

    private StringBuffer createFilledStringBuffer(int len, char filler) {
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            buf.append(filler);
            ++i;
        }
        return buf;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public String getByteLen() {
        return this.byteLen;
    }

    public String getFiller() {
        return this.filler;
    }

    public String getHeaderStr() {
        return this.headerStr;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getIntfLevel() {
        return this.intfLevel;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String getPktID() {
        return this.pktID;
    }

    public String getStatus() {
        return this.status;
    }

    private void parse() {
        this.pktID = this.headerStr.substring(0, 4);
        this.intfLevel = this.headerStr.substring(4, 5);
        this.status = this.headerStr.substring(5, 8);
        if (this.status.equals("   ")) {
            this.status = new String("000");
        }
        this.inputType = this.headerStr.substring(8, 12);
        this.outputType = this.headerStr.substring(12, 16);
        this.beanName = this.headerStr.substring(16, 52);
        this.beanType = this.headerStr.substring(52, 56);
        this.byteLen = this.headerStr.substring(56, 66);
        this.filler = this.headerStr.substring(66);
    }

    public String toString() {
        return this.getHeaderStr();
    }

    private void unparse() throws OS2200HeaderException {
        StringBuffer buf = new StringBuffer(72);
        buf = this.addField(buf, "pktID", this.pktID, 4);
        buf = this.addField(buf, "intfLevel", this.intfLevel, 1);
        buf = this.addField(buf, "status", this.status, 3);
        buf = this.addField(buf, "inputType", this.inputType, 4);
        buf = this.addField(buf, "outputType", this.outputType, 4);
        buf = this.addField(buf, "beanName", this.beanName, 36);
        buf = this.addField(buf, "beanType", this.beanType, 4);
        buf = this.addField(buf, "byteLen", this.byteLen, 10);
        buf = this.addField(buf, "filler", this.filler, 6);
        this.headerStr = buf.toString();
    }
}

