/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200ConnectionRequestInfo;
import com.unisys.os2200.connector.OS2200ManagedConnectionFactory;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

final class OS2200Credentials {
    private static final String className = "OS2200Credentials";

    OS2200Credentials() {
    }

    static PasswordCredential getCredentials(OS2200ManagedConnectionFactory managedConnectionFactory, Subject subject, OS2200ConnectionRequestInfo requestInfo) throws SecurityException {
        String user = null;
        String password = null;
        PasswordCredential passwordCredential = null;
        if (subject != null) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "getCredentials", "Subject used.");
            passwordCredential = OS2200CredentialAction.getCredentials(subject, managedConnectionFactory);
            if (passwordCredential == null) {
                throw new SecurityException("INVALID_PASSWORD_CREDENTIAL");
            }
        } else {
            if (requestInfo == null) {
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "getCredentials", "ConnectionRequestInfo is null.");
                user = OS2200AttributeList.userName;
                password = OS2200AttributeList.password;
                if (user == null) {
                    user = new String("");
                }
                if (password == null) {
                    password = new String("");
                }
            } else {
                OS2200ResourceAdapter.logEvent(Level.FINE, className, "getCredentials", "ConnectionRequestInfo used.");
                user = requestInfo.getUser();
                password = requestInfo.getPassword();
            }
            passwordCredential = new PasswordCredential(user, password.toCharArray());
        }
        return passwordCredential;
    }

    public static boolean isEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (!OS2200Credentials.isEqual(a.getUserName(), b.getUserName())) {
            return false;
        }
        String p1 = null;
        String p2 = null;
        if (a.getPassword() != null) {
            p1 = new String(a.getPassword());
        }
        if (b.getPassword() != null) {
            p2 = new String(b.getPassword());
        }
        return OS2200Credentials.isEqual(p1, p2);
    }

    private static final class OS2200CredentialAction
    implements PrivilegedAction {
        private Subject subject;
        private ManagedConnectionFactory managedConnectionFactory;

        public OS2200CredentialAction(Subject subject, ManagedConnectionFactory managedConnectionFactory) {
            this.subject = subject;
            this.managedConnectionFactory = managedConnectionFactory;
        }

        public Object run() {
            Set<PasswordCredential> credentials = this.subject.getPrivateCredentials(PasswordCredential.class);
            PasswordCredential passwordCredential = null;
            for (PasswordCredential currentCredential : credentials) {
                ManagedConnectionFactory credentialManagedConnectionFactory = currentCredential.getManagedConnectionFactory();
                if (credentialManagedConnectionFactory == null || !credentialManagedConnectionFactory.equals((Object)this.managedConnectionFactory)) continue;
                passwordCredential = currentCredential;
                break;
            }
            return passwordCredential;
        }

        static PasswordCredential getCredentials(Subject subject, ManagedConnectionFactory managedConnectionFactory) {
            OS2200CredentialAction credentialAction = new OS2200CredentialAction(subject, managedConnectionFactory);
            PasswordCredential passwordCredential = (PasswordCredential)AccessController.doPrivileged(credentialAction);
            return passwordCredential;
        }
    }
}

