/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import javax.resource.cci.ConnectionSpec;

public class OS2200ConnectionSpec
implements ConnectionSpec {
    private String serverName;
    private String[] serverNames;
    private String port;
    private String user;
    private String password;
    private int timeout;
    private boolean secureConnection;

    public OS2200ConnectionSpec() {
        this.setServerName(OS2200AttributeList.serverName);
        this.port = OS2200AttributeList.portNumber;
        Integer intTimeout = OS2200AttributeList.connectionTO;
        this.timeout = intTimeout;
        Boolean booleanSecureConnection = OS2200AttributeList.useSecureConnection;
        this.secureConnection = booleanSecureConnection;
        this.user = OS2200AttributeList.userName;
        this.password = OS2200AttributeList.password;
        if (this.user == null) {
            this.user = new String("");
        }
        if (this.password == null) {
            this.password = new String("");
        }
    }

    public OS2200ConnectionSpec(String server, String port) {
        this.port = port;
        this.setServerName(server);
        Integer intTimeout = OS2200AttributeList.connectionTO;
        this.timeout = intTimeout;
        Boolean booleanSecureConnection = OS2200AttributeList.useSecureConnection;
        this.secureConnection = booleanSecureConnection;
        this.user = OS2200AttributeList.userName;
        this.password = OS2200AttributeList.password;
        if (this.user == null) {
            this.user = new String("");
        }
        if (this.password == null) {
            this.password = new String("");
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String[] getServerName_array() {
        return this.serverNames;
    }

    public void setServerName(String newServerName) {
        this.serverName = newServerName;
        this.serverNames = OS2200ResourceAdapter.parseTokensToStringArray(this.serverName, ";,");
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String newPort) {
        this.port = newPort;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int newTimeout) {
        this.timeout = newTimeout;
    }

    public boolean getSecureConnection() {
        return this.secureConnection;
    }

    public void setSecureConnection(boolean newSecureConnection) {
        this.secureConnection = newSecureConnection;
    }

    private boolean isEqual(Object oldValue, Object newValue) {
        if (oldValue == null) {
            return newValue == null;
        }
        return oldValue.equals(newValue);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof OS2200ConnectionSpec)) {
            return false;
        }
        OS2200ConnectionSpec spec = (OS2200ConnectionSpec)object;
        return this.isEqual(this.serverName, spec.getServerName()) && this.isEqual(this.port, spec.getPort()) && this.timeout == spec.getTimeout() && this.secureConnection == spec.getSecureConnection() && this.isEqual(this.user, spec.getUser()) && this.isEqual(this.password, spec.getPassword());
    }
}

