/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200AttributeList;
import com.unisys.os2200.connector.OS2200ConnectionSpec;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import javax.resource.spi.ConnectionRequestInfo;

public class OS2200ConnectionRequestInfo
implements ConnectionRequestInfo {
    private String serverName;
    private String[] serverNames;
    private String port;
    private int timeout;
    private boolean secureConnection;
    private String user;
    private String password;

    OS2200ConnectionRequestInfo() {
        Integer intTimeout = OS2200AttributeList.connectionTO;
        this.timeout = intTimeout;
        Boolean booleanSecureConnection = OS2200AttributeList.useSecureConnection;
        this.secureConnection = booleanSecureConnection;
        this.user = OS2200AttributeList.userName;
        this.password = OS2200AttributeList.password;
        if (this.user == null) {
            this.user = new String("");
        }
        if (this.password == null) {
            this.password = new String("");
        }
    }

    OS2200ConnectionRequestInfo(OS2200ConnectionSpec properties) {
        if (properties == null) {
            return;
        }
        this.serverName = properties.getServerName();
        this.serverNames = properties.getServerName_array();
        this.port = properties.getPort();
        this.timeout = properties.getTimeout();
        this.secureConnection = properties.getSecureConnection();
        this.user = properties.getUser();
        this.password = properties.getPassword();
        if (this.user == null) {
            this.user = new String("");
        }
        if (this.password == null) {
            this.password = new String("");
        }
    }

    OS2200ConnectionRequestInfo(String user, String password) {
        Integer intTimeout = OS2200AttributeList.connectionTO;
        this.timeout = intTimeout;
        Boolean booleanSecureConnection = OS2200AttributeList.useSecureConnection;
        this.secureConnection = booleanSecureConnection;
        this.user = user;
        this.password = password;
        if (this.user == null) {
            this.user = new String("");
        }
        if (this.password == null) {
            this.password = new String("");
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String getServerName() {
        return this.serverName;
    }

    public String[] getServerName_array() {
        return this.serverNames;
    }

    protected void setServerName(String ipAddress) {
        this.serverName = ipAddress;
        this.serverNames = OS2200ResourceAdapter.parseTokensToStringArray(ipAddress, ";,");
    }

    protected String getPort() {
        return this.port;
    }

    protected void setPort(String port) {
        this.port = port;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected void setTimeout(int newTimeout) {
        this.timeout = newTimeout;
    }

    protected boolean getSecureConnection() {
        return this.secureConnection;
    }

    protected void setSecureConnection(boolean newSecureConnection) {
        this.secureConnection = newSecureConnection;
    }

    private boolean isEqual(Object thisProperty, Object callerProperty) {
        if (thisProperty == null) {
            return callerProperty == null;
        }
        return thisProperty.equals(callerProperty);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConnectionRequestInfo)) {
            return false;
        }
        OS2200ConnectionRequestInfo requestInfo = (OS2200ConnectionRequestInfo)object;
        return this.isEqual(this.serverName, requestInfo.getServerName()) && this.isEqual(this.port, requestInfo.getPort()) && this.timeout == requestInfo.getTimeout() && this.secureConnection == requestInfo.getSecureConnection() && this.isEqual(this.user, requestInfo.getUser()) && this.isEqual(this.password, requestInfo.getPassword());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

