/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200ConnectionManager;
import com.unisys.os2200.connector.OS2200ConnectionRequestInfo;
import com.unisys.os2200.connector.OS2200ConnectionSpec;
import com.unisys.os2200.connector.OS2200ManagedConnectionFactory;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import com.unisys.os2200.connector.OS2200ResourceAdapterMetaData;
import java.io.Serializable;
import java.util.logging.Level;
import javax.naming.Reference;
import javax.resource.NotSupportedException;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class OS2200ConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private static final String className = "OS2200ConnectionFactory";

    protected OS2200ConnectionFactory(ManagedConnectionFactory mcf, ConnectionManager cm) throws ResourceException {
        this.mcf = mcf;
        this.cm = cm == null ? new OS2200ConnectionManager() : cm;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "OS2200ConnectionFactory(mcf, cm) constructor invoked.");
    }

    public Connection getConnection() throws ResourceException {
        Connection con = null;
        OS2200ConnectionSpec connSpec = new OS2200ConnectionSpec(((OS2200ManagedConnectionFactory)this.mcf).getServerName(), ((OS2200ManagedConnectionFactory)this.mcf).getPortNumber());
        OS2200ConnectionRequestInfo info = new OS2200ConnectionRequestInfo(connSpec);
        con = (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)info);
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "getConnection", "getConnection() invoked.");
        return con;
    }

    public Connection getConnection(ConnectionSpec properties) throws ResourceException {
        OS2200ConnectionSpec connSpec = (OS2200ConnectionSpec)properties;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "getConnection", "serverName = " + connSpec.getServerName());
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "getConnection", "port = " + connSpec.getPort());
        Connection con = null;
        OS2200ConnectionRequestInfo info = new OS2200ConnectionRequestInfo(connSpec);
        con = (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)info);
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "getConnection", "getConnection(connSpec) invoked.");
        return con;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return new OS2200ResourceAdapterMetaData();
    }

    public RecordFactory getRecordFactory() throws ResourceException, NotSupportedException {
        throw new NotSupportedException("RecordFactory not supported");
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }
}

