/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200ManagedConnection;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import java.util.Vector;
import java.util.logging.Level;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public class OS2200ConnectionEventListener
implements ConnectionEventListener {
    private Vector listeners = new Vector();
    private OS2200ManagedConnection mc;
    private static final String className = "OS2200ConnectionEventListener";

    public OS2200ConnectionEventListener(ManagedConnection mc) {
        this.mc = (OS2200ManagedConnection)mc;
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        Vector list = (Vector)this.listeners.clone();
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent((ManagedConnection)this.mc, eventType) : new ConnectionEvent((ManagedConnection)this.mc, eventType, ex);
        if (connectionHandle != null) {
            ce.setConnectionHandle(connectionHandle);
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            ConnectionEventListener l = (ConnectionEventListener)list.elementAt(i);
            switch (eventType) {
                case 1: {
                    l.connectionClosed(ce);
                    break;
                }
                case 2: {
                    l.localTransactionStarted(ce);
                    break;
                }
                case 3: {
                    l.localTransactionCommitted(ce);
                    break;
                }
                case 4: {
                    l.localTransactionRolledback(ce);
                    break;
                }
                case 5: {
                    l.connectionErrorOccurred(ce);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + eventType);
                }
            }
            ++i;
        }
    }

    public void addConnectorListener(ConnectionEventListener l) {
        this.listeners.addElement(l);
    }

    public void removeConnectorListener(ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void connectionClosed(ConnectionEvent event) {
        try {
            this.mc.destroy();
        }
        catch (Exception e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connectionClosed", "Exception thrown. " + e.getMessage());
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            this.mc.destroy();
        }
        catch (Exception e) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "connectionErrorOccurred", "Exception thrown. " + e.getMessage());
        }
    }
}

