/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.connector;

import com.unisys.os2200.connector.OS2200ConnectionMetaData;
import com.unisys.os2200.connector.OS2200Interaction;
import com.unisys.os2200.connector.OS2200ManagedConnection;
import com.unisys.os2200.connector.OS2200ManagedConnectionMetaData;
import com.unisys.os2200.connector.OS2200ResourceAdapter;
import java.util.logging.Level;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapterInternalException;

public class OS2200Connection
implements Connection {
    protected OS2200ManagedConnection mc;
    private Object connectionLock;
    private boolean closed;
    private static final String className = "OS2200Connection";

    OS2200Connection(OS2200ManagedConnection mc) throws ResourceAdapterInternalException, ResourceException {
        if (mc == null) {
            NullPointerException npe = new NullPointerException("OS2200Connection.OS2200Connection() constructor: OS2200ManagedConnection is null.");
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException("OS2200Connection.OS2200Connection() constructor: OS2200ManagedConnection is null.");
            raie.initCause((Throwable)npe);
            throw raie;
        }
        this.mc = mc;
        this.connectionLock = new Object();
        this.closed = false;
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "constructor", "OS2200Connection() constructor invoked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IllegalStateException, ResourceException {
        if (this.mc == null) {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "close", "OS2200ManagedConnection is NULL.");
            return;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            this.mc.removeConnection(this);
            this.mc.setConnectionTODefault();
            this.mc.sendEvent(1, null, this);
            this.mc = null;
            this.closed = true;
        }
        OS2200ResourceAdapter.logEvent(Level.FINE, className, "close", "OS2200Connection is closed.");
    }

    public Interaction createInteraction() throws ResourceException, ResourceAdapterInternalException {
        return new OS2200Interaction(this);
    }

    public LocalTransaction getLocalTransaction() throws NotSupportedException, IllegalStateException {
        OS2200ResourceAdapter.logEvent(Level.WARNING, className, "getLocalTransaction", "NotSupported Exception thrown in getLocalTransaction(): LocalTransaction not supported.");
        throw new NotSupportedException("LocalTransaction not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionMetaData getMetaData() throws ResourceException {
        OS2200ConnectionMetaData ccMetaData = null;
        Object object = this.connectionLock;
        synchronized (object) {
            OS2200ManagedConnectionMetaData mcMetaData = (OS2200ManagedConnectionMetaData)this.mc.getMetaData();
            ccMetaData = new OS2200ConnectionMetaData(mcMetaData);
        }
        return ccMetaData;
    }

    public ResultSetInfo getResultSetInfo() throws NotSupportedException, IllegalStateException {
        OS2200ResourceAdapter.logEvent(Level.WARNING, className, "getresultSetInfo", "NotSupported Exception thrown: ResultSetInfo not supported.");
        throw new NotSupportedException("ResultSetInfo not supported");
    }

    protected void finalize() {
        try {
            OS2200ResourceAdapter.logEvent(Level.FINE, className, "finalize", "finalize() invoked by JVM Garbage Collector.");
            if (!this.closed) {
                this.close();
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyInteraction(OS2200Interaction interaction) {
        if (interaction == null) {
            return;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OS2200ManagedConnection getManagedConnection() throws IllegalStateException {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.mc;
        }
    }

    protected void associateConnection(OS2200ManagedConnection newMc) throws IllegalStateException {
        try {
            this.checkIfValid();
        }
        catch (ResourceException ex) {
            OS2200ResourceAdapter.logEvent(Level.SEVERE, className, "associateConnection", "IllegalState Exception thrown: Connection is invalid.");
            throw new IllegalStateException("Connection is invalid");
        }
        this.mc.removeConnection(this);
        newMc.addConnection(this);
        this.mc = newMc;
    }

    private void checkIfValid() throws ResourceException {
        if (this.mc == null) {
            throw new ResourceException("Connection is invalid");
        }
    }
}

