/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.dms.classBuilder;

import com.unisys.os2200.dms.classBuilder.ClassUtilities;
import com.unisys.os2200.dms.classBuilder.ElementaryItem;
import com.unisys.os2200.dms.classBuilder.GroupItem;
import com.unisys.os2200.dms.classBuilder.ItemContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class RecordContainer {
    private static final String I_AUTOMATIC = "AUTOMATIC";
    private static final String I_BIG_DECIMAL = "BigDecimal";
    private static final String I_BIG_INTEGER = "BigInteger";
    private static final String I_DEPENDING_ON = "dependingOn";
    private static final String I_ITEM = "item";
    private static final String I_ITEM_LEVEL = "itemLevel";
    private static final String I_ITEM_NAME = "subschemaItemName";
    private static final String I_ITEM_SUBSCHEMA_CODE = "subschemaItemCode";
    private static final String I_MANUAL = "MANUAL";
    private static final String I_MAX_OCCURS = "maxOccurs";
    private static final String I_MIN_OCCURS = "minOccurs";
    private static final String I_NUM_OCCURS = "numOccurs";
    private static final String I_OCCURS = "occurs";
    private static final String I_OWNER = "OWNER";
    private static final String I_RECORD_NAME = "subschemaRecordName";
    private static final String I_TYPE = "javaType";
    private static final String I_RESULT = "result";
    private static final String I_REDEF_ITEM = "redefinitionItem";
    private String dmsName;
    private String packageName;
    private boolean hasBigDecimal;
    private boolean hasBigInteger;
    private boolean hasGroupItem;
    private boolean hasRepeatingItem;
    private ArrayList<ItemContainer> itemContainers;
    private ArrayList<String> automaticSets;
    private ArrayList<String> manualSets;
    private ArrayList<String> ownedSets;
    private int setMembershipCount;
    private int odoIndex;
    private int itemIndex;
    private NodeList items;

    RecordContainer(Element element, String string) throws Exception {
        this.packageName = string;
        this.itemContainers = new ArrayList();
        this.automaticSets = new ArrayList();
        this.manualSets = new ArrayList();
        this.ownedSets = new ArrayList();
        this.hasBigDecimal = false;
        this.hasBigInteger = false;
        this.hasGroupItem = false;
        this.hasRepeatingItem = false;
        this.dmsName = ClassUtilities.getTextNodeValue(element, I_RECORD_NAME);
        this.items = element.getElementsByTagName(I_ITEM);
        this.itemIndex = 0;
        this.odoIndex = 0;
        this.setMembershipCount = 0;
        this.processItems(null);
    }

    void addSetAssociation(String string, String string2) throws Exception {
        if (string2.equals(I_OWNER)) {
            this.ownedSets.add(string);
        } else if (string2.equals(I_AUTOMATIC)) {
            this.automaticSets.add(string);
            ++this.setMembershipCount;
        } else if (string2.equals(I_MANUAL)) {
            this.manualSets.add(string);
            ++this.setMembershipCount;
        } else {
            throw new Exception();
        }
    }

    String getRecordName() {
        return this.dmsName;
    }

    private void processItems(GroupItem groupItem) throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        while (this.itemIndex < this.items.getLength() && bl) {
            ItemContainer itemContainer;
            boolean bl3;
            Element element = (Element)this.items.item(this.itemIndex);
            int n = 1;
            int n2 = -1;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = Integer.parseInt(ClassUtilities.getTextNodeValue(element, I_ITEM_LEVEL));
            int n4 = Integer.parseInt(ClassUtilities.getTextNodeValue(element, I_ITEM_SUBSCHEMA_CODE));
            String string = ClassUtilities.getTextNodeValue(element, I_ITEM_NAME);
            String string2 = ClassUtilities.getTextNodeValue(element, I_TYPE);
            if (string2 != null) {
                if (string2.equals(I_BIG_DECIMAL)) {
                    this.hasBigDecimal = true;
                } else if (string2.equals(I_BIG_INTEGER)) {
                    this.hasBigInteger = true;
                }
            }
            if (element.getElementsByTagName(I_OCCURS).item(0) != null) {
                this.hasRepeatingItem = true;
                Element element2 = (Element)element.getElementsByTagName(I_OCCURS).item(0);
                if (element2.getElementsByTagName(I_NUM_OCCURS).item(0) != null) {
                    n = Integer.parseInt(ClassUtilities.getTextNodeValue(element2, I_NUM_OCCURS));
                } else if (element2.getElementsByTagName(I_MAX_OCCURS).item(0) != null) {
                    bl2 = false;
                    bl5 = true;
                    ++this.odoIndex;
                    n = Integer.parseInt(ClassUtilities.getTextNodeValue(element2, I_MAX_OCCURS));
                    n2 = Integer.parseInt(ClassUtilities.getTextNodeValue(element2, I_MIN_OCCURS));
                    this.setDependingOnItem(ClassUtilities.getTextNodeValue(element2, I_DEPENDING_ON));
                } else {
                    throw new Exception();
                }
            }
            if (element.getElementsByTagName(I_RESULT).item(0) != null) {
                bl4 = true;
            }
            if (element.getElementsByTagName(I_REDEF_ITEM).item(0) != null) {
                bl6 = true;
            }
            boolean bl7 = bl3 = bl2 && !bl6;
            if (n3 == 1) {
                if (string2 != null) {
                    itemContainer = new ElementaryItem(string, string2, 0, 1, -1, false, false);
                    this.itemContainers.add(itemContainer);
                }
                ++this.itemIndex;
                continue;
            }
            if (groupItem != null) {
                if (n3 > groupItem.getItemLevel()) {
                    if (string2 != null) {
                        itemContainer = new ElementaryItem(string, string2, n4, n, n2, bl3, bl4);
                        if (bl5) {
                            itemContainer.setODOItemIndex(this.odoIndex);
                        }
                        groupItem.addSubItem(itemContainer);
                        ++this.itemIndex;
                        continue;
                    }
                    itemContainer = new GroupItem(string, n3, n, n2, n4, bl4);
                    if (bl5) {
                        itemContainer.setODOItemIndex(this.odoIndex);
                    }
                    ++this.itemIndex;
                    this.processItems((GroupItem)itemContainer);
                    groupItem.addSubItem(itemContainer);
                    continue;
                }
                bl = false;
                continue;
            }
            if (string2 != null) {
                itemContainer = new ElementaryItem(string, string2, n4, n, n2, bl3, bl4);
                if (bl5) {
                    itemContainer.setODOItemIndex(this.odoIndex);
                }
                this.itemContainers.add(itemContainer);
                ++this.itemIndex;
                continue;
            }
            itemContainer = new GroupItem(string, n3, n, n2, n4, bl4);
            if (bl5) {
                itemContainer.setODOItemIndex(this.odoIndex);
            }
            this.hasGroupItem = true;
            ++this.itemIndex;
            this.processItems((GroupItem)itemContainer);
            this.itemContainers.add(itemContainer);
        }
    }

    private void setDependingOnItem(String string) {
        for (int i = 0; i < this.itemContainers.size(); ++i) {
            ElementaryItem elementaryItem;
            if (!(this.itemContainers.get(i) instanceof ElementaryItem) || !string.equals((elementaryItem = (ElementaryItem)this.itemContainers.get(i)).getName())) continue;
            elementaryItem.setAsDependent();
            break;
        }
    }

    void writeImplFile(String string) throws Exception {
        ItemContainer itemContainer;
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(string + ClassUtilities.processClassName(this.dmsName) + "Impl.java");
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println("package com.unisys.os2200.dms.custom." + this.packageName + ";");
        printStream.println();
        if (this.hasBigDecimal) {
            printStream.println("import java.math.BigDecimal;");
        }
        if (this.hasBigInteger) {
            printStream.println("import java.math.BigInteger;");
        }
        printStream.println("import com.unisys.os2200.dms.impl.*;");
        printStream.println("import com.unisys.os2200.dms.*;");
        printStream.println();
        printStream.println("public final class " + ClassUtilities.processClassName(this.dmsName) + "Impl extends DMSRecordImpl implements " + ClassUtilities.processClassName(this.dmsName) + " {");
        if (this.hasRepeatingItem || this.hasGroupItem) {
            printStream.println("    private int groupHandle = 0;");
        }
        printStream.println();
        printStream.println("    public " + ClassUtilities.processClassName(this.dmsName) + "Impl(DMSDatabaseManagerImpl databaseManager,");
        printStream.println(String.format("%1$" + (ClassUtilities.processClassName(this.dmsName).length() + 16) + "s", "") + "int recordType,");
        printStream.println(String.format("%1$" + (ClassUtilities.processClassName(this.dmsName).length() + 16) + "s", "") + "long databaseKey,");
        printStream.println(String.format("%1$" + (ClassUtilities.processClassName(this.dmsName).length() + 16) + "s", "") + "DMSRecordData recordData) throws DMSException {");
        printStream.println("        super(databaseManager, recordType, databaseKey, recordData);");
        printStream.println("    }");
        for (n = 0; n < this.itemContainers.size(); ++n) {
            itemContainer = this.itemContainers.get(n);
            itemContainer.writeImplMethods(printStream, "    ", n + 1);
        }
        for (n = 0; n < this.ownedSets.size(); ++n) {
            printStream.println();
            printStream.println("    public DMSRecordSet get" + ClassUtilities.processMethodName(this.ownedSets.get(n)) + "() throws DMSException {");
            printStream.println("        return getRecordSet(" + this.packageName + ".S_" + ClassUtilities.processStaticFinalName(this.ownedSets.get(n)) + ");");
            printStream.println("    }");
        }
        for (n = 0; n < this.automaticSets.size(); ++n) {
            printStream.println();
            printStream.println("    public DMSRecordSet get" + ClassUtilities.processMethodName(this.automaticSets.get(n)) + "() throws DMSException {");
            printStream.println("        return getRecordSet(" + this.packageName + ".S_" + ClassUtilities.processStaticFinalName(this.automaticSets.get(n)) + ");");
            printStream.println("    }");
        }
        for (n = 0; n < this.manualSets.size(); ++n) {
            printStream.println();
            printStream.println("    public DMSRecordSet get" + ClassUtilities.processMethodName(this.manualSets.get(n)) + "() throws DMSException {");
            printStream.println("        return getRecordSet(" + this.packageName + ".S_" + ClassUtilities.processStaticFinalName(this.manualSets.get(n)) + ");");
            printStream.println("    }");
            printStream.println();
            printStream.println("    public void removeFrom" + ClassUtilities.processMethodName(this.manualSets.get(n)) + "() throws DMSException {");
            printStream.println("        remove(" + this.packageName + ".S_" + ClassUtilities.processStaticFinalName(this.manualSets.get(n)) + ");");
            printStream.println("    }");
        }
        if (this.hasRepeatingItem) {
            printStream.println();
            printStream.println("    private void verifyOccurrence(int occurrence, int upperLimit) throws DMSException {");
            printStream.println("        if  (occurrence < 1 || occurrence > upperLimit) {");
            printStream.println("            throw new DMSException(retrieveText(DMSMessageKey.INVALID_OCCURRENCE));");
            printStream.println("        }");
            printStream.println("    }");
        }
        for (n = 0; n < this.itemContainers.size(); ++n) {
            if (!(this.itemContainers.get(n) instanceof GroupItem)) continue;
            itemContainer = (GroupItem)this.itemContainers.get(n);
            ((GroupItem)itemContainer).writeInnerImplClass(printStream, "    ");
        }
        printStream.println("}");
    }

    void writeInterfaceFile(String string, boolean bl) throws Exception {
        ItemContainer itemContainer;
        int n;
        File file = new File(string + ClassUtilities.processClassName(this.dmsName) + ".java");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println("package com.unisys.os2200.dms.custom." + this.packageName + ";");
        printStream.println();
        printStream.println("import com.unisys.os2200.dms.*;");
        if (this.setMembershipCount > 1 && !bl) {
            printStream.println("import java.util.List;");
        }
        if (this.hasBigDecimal) {
            printStream.println("import java.math.BigDecimal;");
        }
        if (this.hasBigInteger) {
            printStream.println("import java.math.BigInteger;");
        }
        printStream.println();
        printStream.println("public interface " + ClassUtilities.processClassName(this.dmsName) + " {");
        for (n = 0; n < this.itemContainers.size(); ++n) {
            if (!(this.itemContainers.get(n) instanceof ElementaryItem)) continue;
            itemContainer = (ElementaryItem)this.itemContainers.get(n);
            ((ElementaryItem)itemContainer).writeStaticFinal(printStream, "    ");
        }
        if (!bl) {
            printStream.println();
            printStream.println("    /**");
            printStream.println("     * Get the database key for this record.");
            printStream.println("     * @return");
            printStream.println("     *    DMSDatabaseKey instance");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    DMSDatabaseKey getDatabaseKey() throws DMSException;");
            printStream.println();
            printStream.println("    /**");
            printStream.println("     * Deletes the record.  If the record is the owner of a set, the members");
            printStream.println("     * of the set are also deleted.");
            printStream.println("     * @throws DMSException thrown if an error occurs while deleting the record");
            printStream.println("     */");
            printStream.println("    void delete() throws DMSException;");
            if (this.ownedSets.size() > 0) {
                printStream.println();
                printStream.println("    /**");
                printStream.println("     * Deletes the record.  If the record is the owner of a set, deletes");
                printStream.println("     * automatic members of the set.");
                printStream.println("     * @throws DMSException");
                printStream.println("     */");
                printStream.println("    void deleteAll() throws DMSException;");
                printStream.println();
                printStream.println("    /**");
                printStream.println("     * Deletes the record.  If the record is the owner of a set, the set must not");
                printStream.println("     * contain any automatic or manual members.");
                printStream.println("     * @throws DMSException thrown if an error occurs while deleting the record");
                printStream.println("     */");
                printStream.println("    void deleteIfEmpty() throws DMSException;");
            }
            printStream.println();
            printStream.println("    /** Keep the lock on a record.");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    void keepLock() throws DMSException;");
            printStream.println();
            printStream.println("    /** Updates the record in the database.");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    void modify() throws DMSException;");
            if (this.setMembershipCount > 0) {
                printStream.println();
                printStream.println("    /** Updates the record in the database.  Also, the record is linked to a new owner");
                printStream.println("     * in the specified recordSet.");
                printStream.println("     * @param recordSet a DMSRecordSet instance");
                printStream.println("     * @throws DMSException");
                printStream.println("     */");
                printStream.println("    void modify(DMSRecordSet recordSet) throws DMSException;");
            }
            if (this.setMembershipCount > 1) {
                printStream.println();
                printStream.println("    /** Updates the record in the database.  Also, the record is linked to new owners in the");
                printStream.println("     * record sets which are in the specified list of recordSets.");
                printStream.println("     * @param recordSets a java.util.ArrayList instance that contains references to one or more");
                printStream.println("     * DMSRecordSet instances");
                printStream.println("     * @throws DMSException");
                printStream.println("     */");
                printStream.println("    void modify(List<DMSRecordSet> recordSets) throws DMSException;");
            }
            if (this.automaticSets.size() == 0) {
                printStream.println();
                printStream.println("    /**");
                printStream.println("     * Stores a new record in the database.");
                printStream.println("     * @throws DMSException thrown if an error occurs while storing the record");
                printStream.println("     */");
                printStream.println("    void store() throws DMSException;");
            } else if (this.automaticSets.size() == 1) {
                printStream.println();
                printStream.println("    /**");
                printStream.println("     * Stores the new record in the database.  This method should only be used if the record");
                printStream.println("     * is an automatic member of a single set.  Insertion of the new record into the specified");
                printStream.println("     * recordSet is based on the ORDER clause in the schema and the currently selected record");
                printStream.println("     * in the recordSet instance.");
                printStream.println("     * @param recordSet a DMSRecordSet instance");
                printStream.println("     * @throws DMSException thrown if an error occurs while storing the record");
                printStream.println("     */");
                printStream.println("    void store(DMSRecordSet recordSet) throws DMSException;");
            } else if (this.automaticSets.size() > 1) {
                printStream.println();
                printStream.println("    /**");
                printStream.println("     * Stores the new record in the database.  This method should only be used if the record");
                printStream.println("     * is an automatic member of multiple record sets.  Insertion of the new record into each");
                printStream.println("     * recordSet in the list of specified recordSets is based on the ORDER clause in the schema ");
                printStream.println("     * and the currently selected record in each recordSet.");
                printStream.println("     * @param recordSets a java.util.List instance that contains references to one or more");
                printStream.println("     * DMSRecordSet instances");
                printStream.println("     * @throws DMSException thrown if an error occurs while storing the record");
                printStream.println("     */");
                printStream.println("    void store(List<DMSRecordSet> recordSets) throws DMSException;");
            }
            if (this.manualSets.size() > 0) {
                printStream.println();
                printStream.println("    /**");
                printStream.println("     * Removes the record from all manual recordSets in which it participates.");
                printStream.println("     * @throws DMSException");
                printStream.println("     */");
                printStream.println("    void removeAll() throws DMSException;");
            }
        }
        printStream.println();
        printStream.println("    /**");
        printStream.println("     * Transforms DMS record data to an XML Document.");
        printStream.println("     * @return");
        printStream.println("     *    an XML document as a string");
        printStream.println("     * @throws DMSException");
        printStream.println("     */");
        printStream.println("    public String toXML() throws DMSException;");
        printStream.println();
        printStream.println("    /**");
        printStream.println("     * Transforms DMS record data to an XML Document, or XML fragment.");
        printStream.println("     * @param fragment - specify true to generate an XML fragment, or false to");
        printStream.println("     * generate an XML Document");
        printStream.println("     * @param encoding - XML encoding.  For example, \"UTF-8\"");
        printStream.println("     * @return");
        printStream.println("     *    an XML document, or XML fragment as a string");
        printStream.println("     * @throws DMSException");
        printStream.println("     */");
        printStream.println("    public String toXML(boolean fragment, String encoding) throws DMSException;");
        for (n = 0; n < this.itemContainers.size(); ++n) {
            itemContainer = this.itemContainers.get(n);
            itemContainer.writeInterfaceMethods(printStream, "    ");
        }
        for (n = 0; n < this.ownedSets.size(); ++n) {
            printStream.println();
            printStream.println("    /**");
            printStream.println("     * Get a recordset");
            printStream.println("     * @return");
            printStream.println("     *    DMSRecordSet instance");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    DMSRecordSet get" + ClassUtilities.processMethodName(this.ownedSets.get(n)) + "() throws DMSException;");
        }
        for (n = 0; n < this.automaticSets.size(); ++n) {
            printStream.println();
            printStream.println("    /**");
            printStream.println("     * Get a recordset");
            printStream.println("     * @return");
            printStream.println("     *    DMSRecordSet instance");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    DMSRecordSet get" + ClassUtilities.processMethodName(this.automaticSets.get(n)) + "() throws DMSException;");
        }
        for (n = 0; n < this.manualSets.size(); ++n) {
            printStream.println();
            printStream.println("    /**");
            printStream.println("     * Get a recordset");
            printStream.println("     * @return");
            printStream.println("     *    DMSRecordSet instance");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    DMSRecordSet get" + ClassUtilities.processMethodName(this.manualSets.get(n)) + "() throws DMSException;");
            printStream.println();
            printStream.println("    /**");
            printStream.println("     * Removes the record from the manual recordSet");
            printStream.println("     * @throws DMSException");
            printStream.println("     */");
            printStream.println("    void removeFrom" + ClassUtilities.processMethodName(this.manualSets.get(n)) + "() throws DMSException;");
        }
        for (n = 0; n < this.itemContainers.size(); ++n) {
            if (!(this.itemContainers.get(n) instanceof GroupItem)) continue;
            itemContainer = (GroupItem)this.itemContainers.get(n);
            ((GroupItem)itemContainer).writeInnerInterface(printStream, "    ");
        }
        printStream.println("}");
        printStream.close();
        fileOutputStream.close();
    }
}

