/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.dms.classBuilder;

import com.unisys.os2200.dms.classBuilder.ClassUtilities;
import com.unisys.os2200.dms.classBuilder.ElementaryItem;
import com.unisys.os2200.dms.classBuilder.ItemContainer;
import java.io.PrintStream;
import java.util.ArrayList;

final class GroupItem
extends ItemContainer {
    private ArrayList<ItemContainer> members;
    private int itemLevel;

    GroupItem(String string, int n, int n2, int n3, int n4, boolean bl) {
        super(string, n2, n3, n4, bl);
        this.itemLevel = n;
        this.members = new ArrayList();
    }

    void addSubItem(ItemContainer itemContainer) {
        if (this.isResult()) {
            itemContainer.setAsResult();
        }
        this.members.add(itemContainer);
    }

    int getItemLevel() {
        return this.itemLevel;
    }

    void writeImplMethods(PrintStream printStream, String string, int n) {
        String string2 = ClassUtilities.processClassName(super.getName());
        if (this.getMaxNumOccurs() > 1) {
            if (super.getODOItemIndex() > 0) {
                printStream.println();
                printStream.println(string + "public " + string2 + " add" + string2 + "() throws DMSException {");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    int index = addItem(repeaterHandle, " + super.getSubschemaCode() + ", " + super.getODOItemIndex() + ");");
                printStream.println(string + "    return get" + string2 + "(index);");
                printStream.println(string + "}");
                printStream.println();
                printStream.println(string + "public " + string2 + " add" + string2 + "(int insertAt) throws DMSException {");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    int index = addItem(repeaterHandle, " + super.getSubschemaCode() + ", insertAt, " + super.getODOItemIndex() + ");");
                printStream.println(string + "    return get" + string2 + "(index);");
                printStream.println(string + "}");
                printStream.println();
                printStream.println(string + "public void remove" + string2 + "(int occurrence) throws DMSException {");
                printStream.println(string + "    verifyOccurrence(occurrence, " + this.getMaxNumOccurs() + ");");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    removeItem(repeaterHandle, occurrence, " + super.getODOItemIndex() + ");");
                printStream.println(string + "}");
                printStream.println();
                printStream.println(string + "public void remove" + string2 + "(int fromIndex, int toIndex) throws DMSException {");
                printStream.println(string + "    verifyOccurrence(fromIndex, " + this.getMaxNumOccurs() + ");");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    removeItemRange(repeaterHandle, fromIndex, toIndex, " + super.getODOItemIndex() + ");");
                printStream.println(string + "}");
            }
            printStream.println();
            printStream.println(string + "public " + string2 + " get" + string2 + "(int occurrence) throws DMSException {");
            printStream.println(string + "    verifyOccurrence(occurrence, " + this.getMaxNumOccurs() + ");");
            printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
            printStream.println(string + "    return new " + string2 + "Impl(acquireItemHandle(repeaterHandle, occurrence));");
            printStream.println(string + "}");
            printStream.println();
            printStream.println(string + "public int getMax" + string2 + "Occurrences() {");
            printStream.println(string + "    return " + this.getMaxNumOccurs() + ";");
            printStream.println(string + "}");
            if (this.getMinNumOccurs() != -1) {
                printStream.println();
                printStream.println(string + "public int getMin" + string2 + "Occurrences() {");
                printStream.println(string + "    return " + this.getMinNumOccurs() + ";");
                printStream.println(string + "}");
            }
        } else {
            printStream.println();
            printStream.println(string + "public " + string2 + " get" + string2 + "() throws DMSException {");
            printStream.println(string + "    return new " + string2 + "Impl(acquireItemHandle(groupHandle, " + n + "));");
            printStream.println(string + "}");
        }
    }

    void writeInnerImplClass(PrintStream printStream, String string) {
        ItemContainer itemContainer;
        int n;
        String string2 = ClassUtilities.processClassName(this.getName());
        printStream.println();
        printStream.println(string + "public final class " + string2 + "Impl implements " + string2 + " {");
        printStream.println(string + "    private int groupHandle = -1;");
        printStream.println();
        printStream.println(string + "    " + string2 + "Impl(int groupHandle) throws DMSException {");
        printStream.println(string + "        super();");
        printStream.println(string + "        this.groupHandle = groupHandle;");
        printStream.println(string + "    }");
        for (n = 0; n < this.members.size(); ++n) {
            itemContainer = this.members.get(n);
            itemContainer.writeInnerImplMethods(printStream, string + "    ", n + 1);
        }
        for (n = 0; n < this.members.size(); ++n) {
            if (!(this.members.get(n) instanceof GroupItem)) continue;
            itemContainer = (GroupItem)this.members.get(n);
            ((GroupItem)itemContainer).writeInnerImplClass(printStream, string + "    ");
        }
        printStream.println(string + "}");
    }

    void writeInnerImplMethods(PrintStream printStream, String string, int n) {
        String string2 = ClassUtilities.processClassName(this.getName());
        if (this.getMaxNumOccurs() > 1) {
            if (super.getODOItemIndex() > 0) {
                printStream.println();
                printStream.println(string + "public " + string2 + " add" + string2 + "() throws DMSException {");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    int index = addItem(repeaterHandle, " + super.getSubschemaCode() + ", " + super.getODOItemIndex() + ");");
                printStream.println(string + "    return get" + string2 + "(index);");
                printStream.println(string + "}");
                printStream.println();
                printStream.println(string + "public " + string2 + " add" + string2 + "(int insertAt) throws DMSException {");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    int index = addItem(repeaterHandle, " + super.getSubschemaCode() + ", insertAt, " + super.getODOItemIndex() + ");");
                printStream.println(string + "    return get" + string2 + "(index);");
                printStream.println(string + "}");
                printStream.println();
                printStream.println(string + "public void remove" + string2 + "(int occurrence) throws DMSException {");
                printStream.println(string + "    verifyOccurrence(occurrence, " + this.getMaxNumOccurs() + ");");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    removeItem(repeaterHandle, occurrence, " + super.getODOItemIndex() + ");");
                printStream.println(string + "}");
                printStream.println();
                printStream.println(string + "public void remove" + string2 + "(int fromIndex, int toIndex) throws DMSException {");
                printStream.println(string + "    verifyOccurrence(fromIndex, " + this.getMaxNumOccurs() + ");");
                printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
                printStream.println(string + "    removeItemRange(repeaterHandle, fromIndex, toIndex, " + super.getODOItemIndex() + ");");
                printStream.println(string + "}");
            }
            printStream.println(string + "public " + string2 + " get" + string2 + "(int occurrence) throws DMSException {");
            printStream.println(string + "    verifyOccurrence(occurrence, " + this.getMaxNumOccurs() + ");");
            printStream.println(string + "    int repeaterHandle = acquireItemHandle(groupHandle, " + n + ");");
            printStream.println(string + "    return new " + string2 + "Impl(acquireItemHandle(repeaterHandle, occurrence));");
            printStream.println(string + "}");
            printStream.println();
            printStream.println(string + "public int getMax" + string2 + "Occurrences() {");
            printStream.println(string + "    return " + this.getMaxNumOccurs() + ";");
            printStream.println(string + "}");
            if (this.getMinNumOccurs() != -1) {
                printStream.println();
                printStream.println(string + "public int getMin" + string2 + "Occurrences() {");
                printStream.println(string + "    return " + this.getMinNumOccurs() + ";");
                printStream.println(string + "}");
            }
        } else {
            printStream.println();
            printStream.println(string + "public " + string2 + " get" + string2 + "() throws DMSException {");
            printStream.println(string + "    return new " + string2 + "Impl(acquireItemHandle(groupHandle, " + n + "));");
            printStream.println(string + "}");
        }
    }

    void writeInnerInterface(PrintStream printStream, String string) {
        ItemContainer itemContainer;
        int n;
        printStream.println();
        printStream.println(string + "public interface " + ClassUtilities.processClassName(this.getName()) + " {");
        for (n = 0; n < this.members.size(); ++n) {
            if (!(this.members.get(n) instanceof ElementaryItem)) continue;
            itemContainer = (ElementaryItem)this.members.get(n);
            ((ElementaryItem)itemContainer).writeStaticFinal(printStream, string + "    ");
        }
        for (n = 0; n < this.members.size(); ++n) {
            itemContainer = this.members.get(n);
            itemContainer.writeInterfaceMethods(printStream, string + "    ");
        }
        for (n = 0; n < this.members.size(); ++n) {
            if (!(this.members.get(n) instanceof GroupItem)) continue;
            itemContainer = (GroupItem)this.members.get(n);
            ((GroupItem)itemContainer).writeInnerInterface(printStream, string + "    ");
        }
        printStream.println(string + "}");
    }

    void writeInterfaceMethods(PrintStream printStream, String string) {
        String string2 = ClassUtilities.processClassName(this.getName());
        if (this.getMaxNumOccurs() > 1) {
            if (super.getODOItemIndex() > 0) {
                printStream.println();
                printStream.println(string + "/**");
                printStream.println(string + " * Add a group item occurrence");
                printStream.println(string + " * @return");
                printStream.println(string + " *    a group item instance");
                printStream.println(string + " * @throws DMSException");
                printStream.println(string + " */");
                printStream.println(string + string2 + " add" + string2 + "() throws DMSException;");
                printStream.println();
                printStream.println(string + "/**");
                printStream.println(string + " * Add a group item occurrence");
                printStream.println(string + " * @param insertAt - location to insert the new item");
                printStream.println(string + " * @return");
                printStream.println(string + " *    a group item instance");
                printStream.println(string + " * @throws DMSException");
                printStream.println(string + " */");
                printStream.println(string + string2 + " add" + string2 + "(int insertAt) throws DMSException;");
                printStream.println();
                printStream.println(string + "/**");
                printStream.println(string + " * Remove the specified group item occurrence");
                printStream.println(string + " * @param occurrence - item occurrence number");
                printStream.println(string + " * @throws DMSException");
                printStream.println(string + " */");
                printStream.println(string + "void remove" + string2 + "(int occurrence) throws DMSException;");
                printStream.println();
                printStream.println(string + "/**");
                printStream.println(string + " * Remove the specified group item occurrence");
                printStream.println(string + " * @param fromIndex - index of first item to remove");
                printStream.println(string + " * @param toIndex - index after last item to remove");
                printStream.println(string + " * @throws DMSException");
                printStream.println(string + " */");
                printStream.println(string + "void remove" + string2 + "(int fromIndex, int toIndex) throws DMSException;");
            }
            printStream.println();
            printStream.println(string + "/**");
            printStream.println(string + " * Get the specified group item occurrence");
            printStream.println(string + " * @param occurrence - item occurrence number");
            printStream.println(string + " * @return");
            printStream.println(string + " *    the group item instance");
            printStream.println(string + " * @throws DMSException");
            printStream.println(string + " */");
            printStream.println(string + string2 + " get" + string2 + "(int occurrence) throws DMSException;");
            printStream.println();
            printStream.println(string + "/**");
            printStream.println(string + " * Get the maximum number of occurrences for the repeating group item");
            printStream.println(string + " * @return");
            printStream.println(string + " *    the maximum number of occurrences");
            printStream.println(string + " */");
            printStream.println(string + "int getMax" + string2 + "Occurrences();");
            if (this.getMinNumOccurs() != -1) {
                printStream.println();
                printStream.println(string + "/**");
                printStream.println(string + " * Get the minimum number of occurrences for the repeating group item");
                printStream.println(string + " * @return");
                printStream.println(string + " *    the minimum number of occurrences");
                printStream.println(string + " */");
                printStream.println(string + "int getMin" + string2 + "Occurrences();");
            }
        } else {
            printStream.println();
            printStream.println(string + "/**");
            printStream.println(string + " * Get the group item");
            printStream.println(string + " * @return");
            printStream.println(string + " *    the group item");
            printStream.println(string + " * @throws DMSException");
            printStream.println(string + " */");
            printStream.println(string + string2 + " get" + string2 + "() throws DMSException;");
        }
    }
}

