/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.dms.classBuilder;

import com.unisys.os2200.dms.classBuilder.ClassUtilities;
import com.unisys.os2200.dms.classBuilder.RecordContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

final class ClassGenerator {
    private static final String I_AREA = "area";
    private static final String I_AREA_NAME = "subschemaAreaName";
    private static final String I_AREA_SUBSCHEMA_CODE = "subschemaAreaCode";
    private static final String I_DATA_NAME = "subschemaDataName";
    private static final String I_DATA_SUBSCHEMA_CODE = "subschemaDataNameCode";
    private static final String I_DATABASE_DATA_NAME = "databaseDataName";
    private static final String I_MEMBER = "member";
    private static final String I_MEMBER_NAME = "subschemaMemberName";
    private static final String I_OWNER = "OWNER";
    private static final String I_RECORD = "record";
    private static final String I_RECORD_NAME = "subschemaRecordName";
    private static final String I_RECORD_SUBSCHEMA_CODE = "subschemaRecordCode";
    private static final String I_SDDL_DATETIME = "sddlDateTime";
    private static final String I_SET = "set";
    private static final String I_SET_NAME = "subschemaSetName";
    private static final String I_SET_OWNER = "subschemaOwnerName";
    private static final String I_SET_MEMBERSHIP = "membershipType";
    private static final String I_SET_SUBSCHEMA_CODE = "subschemaSetCode";
    private static final String I_SUBSCHEMA_FILE = "subschemaFile";
    private static final String I_SUBSCHEMA_NAME = "subschemaName";
    private static final String I_SUBSCHEMA_QUALIFIER = "subschemaFileQualifier";
    private static final String I_VERSION = "sddlXmlVersion";
    private static final String[] SUPPORTED_XML_VERSIONS = new String[]{"3", "2"};
    private ArrayList<RecordContainer> myRecords;
    private Document schemaDoc;
    private String outputPath;
    private String packageName;
    private String buildXmlPath;

    ClassGenerator(String string, String string2) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.schemaDoc = documentBuilder.parse(string);
        this.validateXMLVersion();
        try {
            this.buildXmlPath = string2;
            this.packageName = ClassUtilities.processClassName(this.getSubschemaName());
            this.outputPath = string2 + "com" + File.separator + "unisys" + File.separator + "os2200" + File.separator + "dms" + File.separator + "custom" + File.separator + this.packageName + File.separator;
            File file = new File(this.outputPath);
            if (!file.exists() && !file.mkdirs()) {
                throw new Exception(ClassUtilities.getLocalizedMessage("0110"));
            }
            this.myRecords = new ArrayList();
            NodeList nodeList = this.schemaDoc.getElementsByTagName(I_RECORD);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                RecordContainer recordContainer = new RecordContainer((Element)nodeList.item(i), this.packageName);
                this.myRecords.add(recordContainer);
            }
            this.processSets();
        }
        catch (Exception exception) {
            throw new Exception(ClassUtilities.getLocalizedMessage("0070"));
        }
    }

    private void addSetAccessor(String string, String string2, String string3) throws Exception {
        for (int i = 0; i < this.myRecords.size(); ++i) {
            RecordContainer recordContainer = this.myRecords.get(i);
            if (!recordContainer.getRecordName().equals(string)) continue;
            recordContainer.addSetAssociation(string2, string3);
            break;
        }
    }

    private void checkFiles(boolean bl) throws Exception {
        int n;
        String[] stringArray = new String[this.myRecords.size() + 3];
        stringArray[0] = this.outputPath + "DMSDatabaseInfoImpl.java";
        stringArray[1] = this.outputPath + "ObjectFactoryImpl.java";
        stringArray[2] = this.outputPath + this.packageName + ".java";
        for (n = 0; n < this.myRecords.size(); ++n) {
            RecordContainer recordContainer = this.myRecords.get(n);
            stringArray[n + 3] = this.outputPath + ClassUtilities.processClassName(recordContainer.getRecordName());
        }
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = n + 1; i < stringArray.length; ++i) {
                if (!stringArray[n].equals(stringArray[i])) continue;
                throw new Exception(ClassUtilities.getLocalizedMessage("0050", stringArray[n]));
            }
        }
        if (!bl) {
            for (n = 0; n < stringArray.length; ++n) {
                File file = new File(stringArray[n]);
                if (!file.exists()) continue;
                throw new Exception(ClassUtilities.getLocalizedMessage("0040", file.getName()));
            }
        }
    }

    private String getSubschemaFileName() {
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_SUBSCHEMA_FILE);
        Node node = nodeList.item(0);
        Element element = (Element)node;
        String string = element.getFirstChild().getNodeValue().trim();
        if (this.getTipValue() == 0 && (node = (nodeList = this.schemaDoc.getElementsByTagName(I_SUBSCHEMA_QUALIFIER)).item(0)) != null) {
            element = (Element)node;
            string = element.getFirstChild().getNodeValue().trim() + "*" + string;
        }
        return string;
    }

    private String getSubschemaName() {
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_SUBSCHEMA_NAME);
        Node node = nodeList.item(0);
        Element element = (Element)node;
        return element.getFirstChild().getNodeValue().trim();
    }

    private String getSubschemaTimestamp() {
        NamedNodeMap namedNodeMap = this.schemaDoc.getFirstChild().getAttributes();
        return namedNodeMap.getNamedItem(I_SDDL_DATETIME).getNodeValue().trim();
    }

    private int getTipValue() {
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_SUBSCHEMA_FILE);
        Element element = (Element)nodeList.item(0);
        String string = element.getAttribute("Tip").trim();
        int n = 0;
        if (string.equals("true")) {
            n = 1;
        }
        return n;
    }

    private void processSets() throws Exception {
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_SET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = ClassUtilities.getTextNodeValue(element, I_SET_NAME);
            String string2 = ClassUtilities.getTextNodeValue(element, I_SET_OWNER);
            if (string2 != null) {
                this.addSetAccessor(string2, string, I_OWNER);
            }
            NodeList nodeList2 = element.getElementsByTagName(I_MEMBER);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                element = (Element)nodeList2.item(j);
                Element element2 = (Element)element.getElementsByTagName(I_MEMBER_NAME).item(0);
                String string3 = ((Text)element2.getFirstChild()).getData().trim();
                element2 = (Element)element.getElementsByTagName(I_SET_MEMBERSHIP).item(0);
                String string4 = ((Text)element2.getFirstChild()).getData().trim();
                this.addSetAccessor(string3, string, string4);
            }
        }
    }

    private void validateXMLVersion() throws Exception {
        NamedNodeMap namedNodeMap = this.schemaDoc.getFirstChild().getAttributes();
        boolean bl = false;
        if (namedNodeMap.getLength() != 0) {
            String string = namedNodeMap.getNamedItem(I_VERSION).getNodeValue();
            for (int i = 0; i < SUPPORTED_XML_VERSIONS.length; ++i) {
                if (!SUPPORTED_XML_VERSIONS[i].equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new Exception(ClassUtilities.getLocalizedMessage("0080"));
            }
        } else {
            throw new Exception(ClassUtilities.getLocalizedMessage("0090"));
        }
    }

    void writeBuildXml() throws Exception {
        try {
            this.writeBuildXmlFile();
        }
        catch (Exception exception) {
            throw new Exception(ClassUtilities.getLocalizedMessage("0060", exception.getLocalizedMessage()));
        }
    }

    void writeClasses(boolean bl, boolean bl2) throws Exception {
        this.checkFiles(bl);
        try {
            this.writePackageInterface();
            this.writeDatabaseInfoFile();
            this.writeObjectImplFile();
            for (int i = 0; i < this.myRecords.size(); ++i) {
                RecordContainer recordContainer = this.myRecords.get(i);
                recordContainer.writeInterfaceFile(this.outputPath, bl2);
                recordContainer.writeImplFile(this.outputPath);
            }
        }
        catch (Exception exception) {
            throw new Exception(ClassUtilities.getLocalizedMessage("0060", exception.getLocalizedMessage()));
        }
    }

    private void writeBuildXmlFile() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.buildXmlPath + "build.xml");
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<project name=\"Custom Classes Script\" default=\"jar\" basedir=\".\">");
        printStream.println("<!-- =================================");
        printStream.println("     Properties are immutable (first definition always wins).");
        printStream.println("     You can set a different subschema.name on the command line");
        printStream.println("     using the -Dproperty=value option. For example:");
        printStream.println("     >ant -Dsubschema.name=" + this.packageName);
        printStream.println("     ================================= -->");
        printStream.println("    <property name=\"subschema.name\" value=\"" + this.packageName + "\"/>");
        printStream.println();
        printStream.println("    <!-- internal properties -->");
        printStream.println("    <property name=\"jar.file\" value=\"${subschema.name}.jar\"/>");
        printStream.println("    <property name=\"package\" value=\"com/unisys/os2200/dms/custom/${subschema.name}\"/>");
        printStream.println("    <property name=\"temp.dir\" value=\"${basedir}/temp\"/>");
        printStream.println();
        printStream.println("<!-- =================================");
        printStream.println("     target: Compile custom classes");
        printStream.println("     ================================= -->");
        printStream.println("    <target name=\"compile\">");
        printStream.println("        <available property=\"dmsra.jar.in.classpath\" classname=\"com.unisys.os2200.dms.DMSException\">");
        printStream.println("            <classpath>");
        printStream.println("                <pathelement location=\"dmsra.jar\" />");
        printStream.println("            </classpath>");
        printStream.println("        </available>");
        printStream.println("        <fail unless=\"dmsra.jar.in.classpath\">dmsra.jar must be in the CLASSPATH</fail>");
        printStream.println("        <mkdir dir=\"${temp.dir}/bin\"/>");
        printStream.println("        <javac");
        printStream.println("            source=\"1.5\"");
        printStream.println("            target=\"1.5\"");
        printStream.println("            destdir=\"${temp.dir}/bin\"");
        printStream.println("            srcdir=\"${package}\"");
        printStream.println("            debug=\"yes\"");
        printStream.println("            debuglevel=\"source,lines\">");
        printStream.println("        </javac>");
        printStream.println("    </target>");
        printStream.println();
        printStream.println("<!-- =================================");
        printStream.println("     target: Jar custom classes");
        printStream.println("     ================================= -->");
        printStream.println("    <target name=\"jar\" depends=\"compile\">");
        printStream.println("        <available property=\"subschema.class.found\"");
        printStream.println("         classname=\"com.unisys.os2200.dms.custom.${subschema.name}.${subschema.name}\">");
        printStream.println("            <classpath>");
        printStream.println("               <pathelement location=\"${temp.dir}/bin\"/>");
        printStream.println("            </classpath>");
        printStream.println("        </available>");
        printStream.println("        <fail unless=\"subschema.class.found\">");
        printStream.println("            Invalid subschema name: ${subschema.name}");
        printStream.println("            First character must be uppercase and remaining characters lowercase");
        printStream.println("        </fail>");
        printStream.println("        <jar jarfile=\"${jar.file}\">");
        printStream.println("            <fileset dir=\"${temp.dir}/bin\"");
        printStream.println("                includes=\"${package}/*.class\"/>");
        printStream.println("            <fileset dir=\"${basedir}\"");
        printStream.println("                includes=\"${package}/*.java\"/>");
        printStream.println("        </jar>");
        printStream.println("        <delete dir=\"${temp.dir}\" failonerror=\"false\" />");
        printStream.println("    </target>");
        printStream.println("</project>");
        printStream.close();
    }

    private void writeDatabaseInfoFile() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputPath + "DMSDatabaseInfoImpl.java");
        PrintStream printStream = new PrintStream(fileOutputStream);
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_AREA);
        printStream.println("package com.unisys.os2200.dms.custom." + this.packageName + ";");
        printStream.println();
        printStream.println("import com.unisys.os2200.dms.*;");
        printStream.println("import com.unisys.os2200.dms.impl.*;");
        printStream.println("import com.unisys.os2200.dms.custom.DMSDatabaseInfo;");
        printStream.println();
        printStream.println("public class DMSDatabaseInfoImpl extends DMSObject implements DMSDatabaseInfo {");
        printStream.println();
        printStream.println("    private static final String SUBSCHEMA_NAME = \"" + this.getSubschemaName() + "\";");
        printStream.println("    private static final String SUBSCHEMA_FILE_NAME = \"" + this.getSubschemaFileName() + "\";");
        printStream.println("    private static final String SUBSCHEMA_TIMESTAMP = \"" + this.getSubschemaTimestamp() + "\";");
        printStream.println("    private static final int IS_TIP_FILE = " + this.getTipValue() + ";");
        printStream.println("    private static final int MAX_AREA_NAMES = " + nodeList.getLength() + ";");
        printStream.println();
        printStream.println("    private final String[] areaNames;");
        printStream.println();
        printStream.println("    public DMSDatabaseInfoImpl() {");
        printStream.println("        this.areaNames = new String[MAX_AREA_NAMES];");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = ClassUtilities.processStaticFinalName(ClassUtilities.getTextNodeValue(element, I_AREA_NAME));
            printStream.println("        this.areaNames[" + i + "] = " + this.packageName + ".AN_" + string + ";");
        }
        printStream.println("    }");
        printStream.println();
        printStream.println("    public int getAreaID(String areaName) throws DMSException {");
        printStream.println("        int areaID = -1;");
        printStream.println();
        printStream.println("        for (int index = 0; index < this.areaNames.length; index++ ) {");
        printStream.println("            if ( this.areaNames[index].equals(areaName) ) {");
        printStream.println("                areaID = index + 1;");
        printStream.println("                break;");
        printStream.println("            }");
        printStream.println("        }");
        printStream.println();
        printStream.println("        if (areaID == -1) {");
        printStream.println("            throw new DMSException(retrieveText(DMSMessageKey.UNABLE_TO_DETERMINE_AREAID));");
        printStream.println("        }");
        printStream.println();
        printStream.println("        return areaID;");
        printStream.println("    }");
        printStream.println();
        printStream.println("    public String getAreaName(Integer areaID) throws DMSException {");
        printStream.println();
        printStream.println("        if ( areaID <= 0 || areaID > MAX_AREA_NAMES ) {");
        printStream.println("            throw new DMSException(retrieveText(DMSMessageKey.INVALID_AREAID));");
        printStream.println("        }");
        printStream.println();
        printStream.println("        return this.areaNames[areaID - 1];");
        printStream.println("    }");
        printStream.println();
        printStream.println("    public String getSubschemaName() {");
        printStream.println("        return SUBSCHEMA_NAME;");
        printStream.println("    }");
        printStream.println();
        printStream.println("    public String getSubschemaFileName() {");
        printStream.println("        return SUBSCHEMA_FILE_NAME;");
        printStream.println("    }");
        printStream.println();
        printStream.println("    public String getSubschemaTimestamp() {");
        printStream.println("        return SUBSCHEMA_TIMESTAMP;");
        printStream.println("    }");
        printStream.println();
        printStream.println("    public int isTIPFile() {");
        printStream.println("        return IS_TIP_FILE;");
        printStream.println("    }");
        printStream.println("}");
        printStream.close();
    }

    private void writeObjectImplFile() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputPath + "ObjectFactoryImpl.java");
        PrintStream printStream = new PrintStream(fileOutputStream);
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_RECORD);
        printStream.println("package com.unisys.os2200.dms.custom." + this.packageName + ";");
        printStream.println();
        printStream.println("import java.lang.Integer;");
        printStream.println();
        printStream.println("import com.unisys.os2200.dms.custom.*;");
        printStream.println("public class ObjectFactoryImpl implements ObjectFactory {");
        printStream.println("    private final String[] classNames;");
        printStream.println("    private static String packagePrefix = \"com.unisys.os2200.dms.custom." + this.packageName + ".\";");
        printStream.println();
        printStream.println("    public ObjectFactoryImpl() {");
        printStream.println("        this.classNames = new String[" + nodeList.getLength() + "];");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = ClassUtilities.processClassName(ClassUtilities.getTextNodeValue(element, I_RECORD_NAME));
            printStream.println("        this.classNames[" + i + "] = \"" + string + "Impl\";");
        }
        printStream.println("    }");
        printStream.println();
        printStream.println("    public Object create(Integer classID) {");
        printStream.println("        Object obj = null;");
        printStream.println();
        printStream.println("        try {");
        printStream.println("            java.lang.Class<?> classInfo = java.lang.Class.forName(packagePrefix + this.classNames[classID - 1]);");
        printStream.println("            obj = classInfo.newInstance();");
        printStream.println("        }");
        printStream.println("        catch (Exception e) {");
        printStream.println("            e.printStackTrace();");
        printStream.println("        }");
        printStream.println();
        printStream.println("        return obj;");
        printStream.println("    }");
        printStream.println();
        printStream.println("    public Object create(Integer classID, java.lang.Class<?>[] parameterTypes, Object[] initargs) {");
        printStream.println("        Object obj = null;");
        printStream.println();
        printStream.println("        try {");
        printStream.println("            java.lang.Class<?> classInfo = java.lang.Class.forName(packagePrefix + this.classNames[classID - 1]);");
        printStream.println("            java.lang.reflect.Constructor<?> constructor = classInfo.getConstructor(parameterTypes);");
        printStream.println("            obj = constructor.newInstance(initargs);");
        printStream.println("        }");
        printStream.println("        catch (Exception e) {");
        printStream.println("            e.printStackTrace();");
        printStream.println("        }");
        printStream.println();
        printStream.println("        return obj;");
        printStream.println("    }");
        printStream.println("}");
        printStream.close();
    }

    private void writePackageInterface() throws Exception {
        int n;
        String string;
        Element element;
        int n2;
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputPath + this.packageName + ".java");
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println("package com.unisys.os2200.dms.custom." + this.packageName + ";");
        printStream.println();
        printStream.println("public interface " + this.packageName + " {");
        NodeList nodeList = this.schemaDoc.getElementsByTagName(I_DATABASE_DATA_NAME);
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            element = (Element)nodeList.item(n2);
            string = ClassUtilities.processStaticFinalName(ClassUtilities.getTextNodeValue(element, I_DATA_NAME));
            n = Integer.parseInt(ClassUtilities.getTextNodeValue(element, I_DATA_SUBSCHEMA_CODE));
            printStream.println("    static final int DN_" + string + " = " + n + ";");
        }
        printStream.println();
        nodeList = this.schemaDoc.getElementsByTagName(I_AREA);
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            element = (Element)nodeList.item(n2);
            string = ClassUtilities.processStaticFinalName(ClassUtilities.getTextNodeValue(element, I_AREA_NAME));
            n = Integer.parseInt(ClassUtilities.getTextNodeValue(element, I_AREA_SUBSCHEMA_CODE));
            printStream.println("    static final int A_" + string + " = " + n + ";");
        }
        printStream.println();
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            element = (Element)nodeList.item(n2);
            string = ClassUtilities.getTextNodeValue(element, I_AREA_NAME);
            printStream.println("    static final String AN_" + ClassUtilities.processStaticFinalName(string) + " = \"" + string + "\";");
        }
        printStream.println();
        nodeList = this.schemaDoc.getElementsByTagName(I_RECORD);
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            element = (Element)nodeList.item(n2);
            string = ClassUtilities.processStaticFinalName(ClassUtilities.getTextNodeValue(element, I_RECORD_NAME));
            n = Integer.parseInt(ClassUtilities.getTextNodeValue(element, I_RECORD_SUBSCHEMA_CODE));
            printStream.println("    static final int R_" + ClassUtilities.processStaticFinalName(string) + " = " + n + ";");
        }
        printStream.println();
        nodeList = this.schemaDoc.getElementsByTagName(I_SET);
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            element = (Element)nodeList.item(n2);
            string = ClassUtilities.getTextNodeValue(element, I_SET_NAME);
            n = Integer.parseInt(ClassUtilities.getTextNodeValue(element, I_SET_SUBSCHEMA_CODE));
            printStream.println("    static final int S_" + ClassUtilities.processStaticFinalName(string) + " = " + n + ";");
        }
        printStream.println("}");
        printStream.close();
    }
}

