/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.dms.classBuilder;

import com.unisys.os2200.dms.classBuilder.ClassGenerator;
import com.unisys.os2200.dms.classBuilder.ClassUtilities;
import java.io.File;

public final class ClassBuilder {
    private String inputFilePath;
    private String outputPath;
    private boolean onlyAccessors = false;
    private boolean overwriteFiles = false;
    private ClassGenerator classGenerator;

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].toLowerCase().split("=");
                if (stringArray2[0].startsWith("input")) {
                    string = stringArray2[1];
                    continue;
                }
                if (stringArray2[0].startsWith("output")) {
                    string2 = stringArray2[1];
                    continue;
                }
                if (stringArray2[0].startsWith("overwrite")) {
                    if (!stringArray2[1].equals("true")) continue;
                    bl = true;
                    continue;
                }
                if (!stringArray2[0].startsWith("onlyaccessors") || !stringArray2[1].equals("true")) continue;
                bl2 = true;
            }
            ClassBuilder classBuilder = new ClassBuilder(string, string2);
            classBuilder.overwriteFiles = bl;
            classBuilder.onlyAccessors = bl2;
            classBuilder.generateCustomClasses();
            System.out.println(ClassUtilities.getLocalizedMessage("0100"));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public ClassBuilder(String string, String string2) throws Exception {
        this.inputFilePath = string;
        this.outputPath = string2;
        if (string == null || string.length() == 0) {
            throw new Exception(ClassUtilities.getLocalizedMessage("0010"));
        }
        if (string2 == null || string2.length() == 0) {
            throw new Exception(ClassUtilities.getLocalizedMessage("0020"));
        }
        File file = new File(string);
        if (!this.outputPath.endsWith(File.separator)) {
            this.outputPath = this.outputPath + File.separator;
        }
        if (!file.exists()) {
            throw new Exception(ClassUtilities.getLocalizedMessage("0030", string));
        }
    }

    public void generateCustomClasses() throws Exception {
        this.classGenerator = new ClassGenerator(this.inputFilePath, this.outputPath);
        this.classGenerator.writeClasses(this.overwriteFiles, this.onlyAccessors);
        this.classGenerator.writeBuildXml();
    }

    public void setFileOverwriteAbility(boolean bl) {
        this.overwriteFiles = bl;
    }
}

