/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.logging.core;

import com.unisys.logging.core.LoggingPlugin;
import com.unisys.logging.core.PluginFileAppender;
import com.unisys.logging.core.PluginLogAppender;
import com.unisys.logging.core.PluginLogListener;
import com.unisys.os2200.i18nSupport.Messages;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class PluginLogManager {
    private Plugin plugIn;
    private ILog log;
    private IPath stateLocation;
    private Hierarchy hierarchy;
    private HashMap hookedPlugins = new HashMap();
    private final String DEFAULT_LOG_CONFIG = "logger.properties";

    public PluginLogManager(Plugin plugin) {
        this.plugIn = plugin;
        this.log = this.plugIn.getLog();
        this.stateLocation = this.plugIn.getStateLocation();
        this.hierarchy = new Hierarchy((Logger)new RootLogger(Level.DEBUG));
        this.hierarchy.addHierarchyEventListener((HierarchyEventListener)new PluginEventListener());
        URL uRL = LoggingPlugin.getDefault().getBundle().getEntry("/logger.properties");
        this.configure(uRL);
    }

    public void configure(String string) {
        URL uRL = this.plugIn.getBundle().getEntry("/" + string);
        this.configure(uRL);
    }

    private void configure(URL uRL) {
        Properties properties = null;
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception exception) {
            String string = String.valueOf(Messages.getString((String)"PluginLogManager.initError")) + exception.getMessage();
            Status status = new Status(4, LoggingPlugin.getDefault().getBundle().getSymbolicName(), 4, string, (Throwable)exception);
            LoggingPlugin.getDefault().getLog().log((IStatus)status);
            throw new RuntimeException(Messages.getString((String)"PluginLogManager.initError"), exception);
        }
        new PropertyConfigurator().doConfigure(properties, (LoggerRepository)this.hierarchy);
        LoggingPlugin.getDefault().addLogManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hookPlugin(String string, ILog iLog) {
        HashMap hashMap = this.hookedPlugins;
        synchronized (hashMap) {
            block4: {
                if (iLog != null && string != null && !this.hookedPlugins.containsKey(string)) break block4;
                return false;
            }
            PluginLogListener pluginLogListener = new PluginLogListener(iLog, this.getLogger(string));
            this.hookedPlugins.put(string, pluginLogListener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unHookPlugin(String string) {
        HashMap hashMap = this.hookedPlugins;
        synchronized (hashMap) {
            block4: {
                if (string != null && this.hookedPlugins.containsKey(string)) break block4;
                return false;
            }
            PluginLogListener pluginLogListener = (PluginLogListener)this.hookedPlugins.get(string);
            pluginLogListener.dispose();
            this.hookedPlugins.remove(string);
        }
        return true;
    }

    public boolean isDisabled(int n) {
        return this.hierarchy.isDisabled(n);
    }

    public void setThreshold(Level level) {
        this.hierarchy.setThreshold(level);
    }

    public void setThreshold(String string) {
        this.hierarchy.setThreshold(string);
    }

    public Level getThreshold() {
        return this.hierarchy.getThreshold();
    }

    public Logger getLogger(String string) {
        return this.hierarchy.getLogger(string);
    }

    public void shutdown() {
        this.internalShutdown();
        LoggingPlugin.getDefault().removeLogManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalShutdown() {
        HashMap hashMap = this.hookedPlugins;
        synchronized (hashMap) {
            for (String string : this.hookedPlugins.keySet()) {
                PluginLogListener pluginLogListener = (PluginLogListener)this.hookedPlugins.get(string);
                pluginLogListener.dispose();
            }
            this.hookedPlugins.clear();
        }
        this.hierarchy.shutdown();
    }

    public Logger getLogger(String string, LoggerFactory loggerFactory) {
        return this.hierarchy.getLogger(string, loggerFactory);
    }

    public Logger getRootLogger() {
        return this.hierarchy.getRootLogger();
    }

    public Logger exists(String string) {
        return this.hierarchy.exists(string);
    }

    public Enumeration getCurrentLoggers() {
        return this.hierarchy.getCurrentLoggers();
    }

    public void resetConfiguration() {
        this.hierarchy.resetConfiguration();
    }

    private class PluginEventListener
    implements HierarchyEventListener {
        private PluginEventListener() {
        }

        public void addAppenderEvent(Category category, Appender appender) {
            if (appender instanceof PluginLogAppender) {
                ((PluginLogAppender)appender).setLog(PluginLogManager.this.log);
            }
            if (appender instanceof PluginFileAppender) {
                ((PluginFileAppender)appender).setStateLocation(PluginLogManager.this.stateLocation);
            }
        }

        public void removeAppenderEvent(Category category, Appender appender) {
        }
    }
}

