/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.logging.core;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

class PluginLogListener
implements ILogListener {
    private ILog log;
    private Logger logger;

    PluginLogListener(ILog iLog, Logger logger) {
        this.log = iLog;
        this.logger = logger;
        iLog.addLogListener((ILogListener)this);
    }

    void dispose() {
        if (this.log != null) {
            this.log.removeLogListener((ILogListener)this);
            this.log = null;
            this.logger = null;
        }
    }

    public void logging(IStatus iStatus, String string) {
        if (this.logger == null || iStatus == null) {
            return;
        }
        int n = iStatus.getSeverity();
        Level level = Level.DEBUG;
        if (n == 4) {
            level = Level.ERROR;
        } else if (n == 2) {
            level = Level.WARN;
        } else if (n == 1) {
            level = Level.INFO;
        } else if (n == 8) {
            level = Level.FATAL;
        }
        string = PluginLogListener.formatText(string);
        String string2 = PluginLogListener.formatText(iStatus.getPlugin());
        String string3 = PluginLogListener.formatText(iStatus.getMessage());
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" - ");
        }
        if (!(string2 == null || string != null && string2.equals(string))) {
            stringBuffer.append(string2);
            stringBuffer.append(" - ");
        }
        stringBuffer.append(iStatus.getCode());
        if (string3 != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(string3);
        }
        this.logger.log((Priority)level, (Object)stringBuffer.toString(), iStatus.getException());
    }

    private static String formatText(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }
}

