/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.logging.core;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PluginLogAppender
extends AppenderSkeleton {
    private ILog pluginLog;

    void setLog(ILog iLog) {
        this.pluginLog = iLog;
    }

    public void append(LoggingEvent loggingEvent) {
        ThrowableInformation throwableInformation;
        if (this.layout == null) {
            this.errorHandler.error("Missing layout for appender " + this.name, null, 5);
            return;
        }
        String string = this.layout.format(loggingEvent);
        Throwable throwable = null;
        if (this.layout.ignoresThrowable() && (throwableInformation = loggingEvent.getThrowableInformation()) != null) {
            throwable = throwableInformation.getThrowable();
        }
        throwableInformation = loggingEvent.getLevel();
        int n = 0;
        if (throwableInformation.toInt() >= 40000) {
            n = 4;
        } else if (throwableInformation.toInt() >= 30000) {
            n = 2;
        } else if (throwableInformation.toInt() >= 10000) {
            n = 1;
        }
        this.pluginLog.log((IStatus)new Status(n, this.pluginLog.getBundle().getSymbolicName(), throwableInformation.toInt(), string, throwable));
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }
}

