/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.logging.core;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private int _handle = 0;
    private String source = null;
    private String server = null;

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String string) {
        this(null, string, null);
    }

    public NTEventLogAppender(String string, String string2) {
        this(string, string2, null);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public NTEventLogAppender(String string, Layout layout) {
        this(null, string, layout);
    }

    public NTEventLogAppender(String string, String string2, Layout layout) {
        if (string2 == null) {
            string2 = "com.unisys.logging.core";
        }
        this.layout = layout == null ? new TTCCLayout() : layout;
        try {
            this._handle = this.registerEventSource(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._handle = 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.source != null) {
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception exception) {
                LogLog.error((String)"Could not register event source.", (Throwable)exception);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent loggingEvent) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
        }
        int n = loggingEvent.getLevel().toInt();
        this.reportEvent(this._handle, stringBuffer.toString(), n);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String string) {
        this.source = string.trim();
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);
}

