/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.AllVariables;
import com.unisys.tde.debug.core.comm.DebugSocketControl;
import com.unisys.tde.debug.core.comm.MemoryDumpModule;
import com.unisys.tde.debug.core.comm.OS2200RegisterSets;
import com.unisys.tde.debug.core.comm.OneVarValue;
import com.unisys.tde.debug.core.comm.ProcedureList;
import com.unisys.tde.debug.core.comm.ProgramContext;
import com.unisys.tde.debug.core.comm.ProgramPoint;
import com.unisys.tde.debug.core.comm.StartLineInfo;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.SyncOutputQueues;
import com.unisys.tde.debug.core.comm.SyncSocketControl;
import com.unisys.tde.debug.core.comm.TaskInfo;
import com.unisys.tde.debug.core.comm.WalkbackPoint;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.osgi.util.NLS;

public class WriterTo2200 {
    public static final String PADSLIBPROCLEVEL = "# PADSLIBPROCLEVEL: ";
    static final String sep = "\",\"";
    static final String sepnq = "',";
    static final String sepns2 = "',\"";
    static final String allProcs = "getallprocs(\"{0}\",\"{1}\",\"{2}\",\"{3}\")\n";
    static final String changeOneVariable = "CHGONEVAR(\" {0} \",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\" \",\" \",\" \",\" \")\n";
    static final String getOneVariable = "DISP1VAR2(\" {0} \",\"{1}\",\"{2}\",\"{3}\")\n";
    static final String getOneVariableJ = "DISP1VAR2J(\"{0}\",\"{1}\",\"{2}\",\"{3}\")\n";
    static final String getArray = "DISPARRAY(\" {0} \",{1},{2},\"{3}\",\"{4}\",\"{5}\",{6})\n";
    static final String getArrayJ = "DISPARRAYJ(\"{0}\",{1},{2},\"{3}\",\"{4}\",\"{5}\",{6})\n";
    static final String getOneVariableExp = "DISP1VAR3(\" {0} \",\"{1}\",\"{2}\",\"{3}\")\n";
    static final String allVars = "varinfo(\"{0}\",\"{1}\",\"{2}\",\"\",\" \",\" \",\" \",\"{3}\")\n";
    static final String allVarsFormat = "varinfo(\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\")";
    static final String getVarChildren = "varGetChild({0},{1},{2})\n";
    static final String getVarName = "varGetName({0})\n";
    static final String testStr = "TESTSTRPASS (\"{0}\")\n";
    static final String getStrInfoInArray = "getStrInArr({0},\"{1}\")\n";
    static final String cmdStepOver = "stepovr\n";
    static final String cmdStepInto = "step$\n";
    static final String cmdStepOut = "stepout \n";
    static final String cmdRemoveStep = "RemoveStep\n";
    static final String cmdRun = "go$\n";
    static final String cmdJustGoOn = Messages.getString((String)"WriterTo2200_66");
    static final String cmdStopGoFlag = "STOPGOFLAG\n";
    static final String getStarter = "getstart\n";
    static final String cmdStep = "step$\n";
    static final String exit = "EXIT PROGRAM\n";
    static final String taskList = "LISTTASKS\n";
    static final String getRegs = "dumpregs \n";
    static final String getRags = "dampregs(\"{0}\",\"{1}\",\"{2}\") \n";
    static final String dumpMemory = "dmpaddr(\"{0}\",\"{1}\",\"X\",\"132\")\n";
    static final String getContext = "inq profile\n";
    static final String getStack = "inq walkback\n";
    static final String dmpOMSDD = "DumpOMSDD(\"{0}\")\n";
    static final String setPadsTask = "task {0} \n";
    static final String interruptTask = "interrupt task {0}\n";
    static final String getSrcName = "SRCNAM({0},{1})\n";
    static final String setTrap = "settrap(\"{0}\",\"{1}\",\"{2}\")\n";
    static final String setTrapVar = "pcwatch(\"{0}\",\"TRAP${1}\",\"{2}\",\"{3}\",\"{4}\",\" \",\" \",\" \",\" \")\n";
    static final String removeBrkpt = "remove at line {0} [prog={1}, elt={2}]\n";
    static final String removeAllBrkpts = "remove all trap execution";
    static final String removeAllTrapChange = "remove all trap change";
    static final String removeTrapVar = "remove ID TRAP${0} \n";
    static final String listSource = "listsrc(\"{0}\",\"{1}\")\n";
    static final String getPadsProcLevel = "PADSLBPRCLVL\n";
    static final String varElement = "P$A$D$$S/V$A$R$$ELT";
    static final String varEltAsFile = "P$A$D$$S.V$A$R$$ELT";
    static final String dispCString = "COMVAR({0})\n";
    OutputStream ostream;
    Object syncObject;
    SyncSocketControl syncer;
    DebugSocketControl dbs;
    SyncOutputQueues soQueues;
    private boolean walkingB = false;

    public WriterTo2200(OutputStream outputStream, SyncOutputQueues syncOutputQueues, DebugSocketControl debugSocketControl) {
        OS2200CorePlugin.logger.debug((Object)"write to 2200", null);
        this.soQueues = syncOutputQueues;
        this.ostream = outputStream;
        this.dbs = debugSocketControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncNotify(Object object) {
        this.syncObject = object;
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncNotify() {
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            this.notifyAll();
        }
    }

    public boolean EndSession() throws IOException {
        OS2200CorePlugin.logger.debug((Object)"writing end");
        this.ostream.write(exit.getBytes());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String stepOver() throws IOException {
        this.dbs.setLastErrorMessage("");
        this.dbs.setDoingStep(true);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)"writing step over");
            this.ostream.write(cmdStepOver.getBytes());
            try {
                this.wait();
                if (this.syncObject instanceof String) return (String)this.syncObject;
                this.syncNotify(this.syncObject);
                return "";
            }
            catch (InterruptedException interruptedException) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String stepOut() throws IOException {
        this.dbs.setLastErrorMessage("");
        this.dbs.setDoingStep(true);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)"writing step out");
            this.ostream.write(cmdStepOut.getBytes());
            try {
                this.wait();
                if (this.syncObject instanceof String) return (String)this.syncObject;
                this.syncNotify(this.syncObject);
                return "";
            }
            catch (InterruptedException interruptedException) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String stepInto() throws IOException {
        this.dbs.setLastErrorMessage("");
        this.dbs.setDoingStep(true);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)"writing step into");
            this.ostream.write("step$\n".getBytes());
            try {
                this.wait();
                if (this.syncObject instanceof String) return (String)this.syncObject;
                this.syncNotify(this.syncObject);
                return "";
            }
            catch (InterruptedException interruptedException) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeStep() {
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                this.dbs.setLastErrorMessage("");
                this.dbs.setDoingStep(true);
                OS2200CorePlugin.logger.debug((Object)"writing remove step");
                this.ostream.write(cmdRemoveStep.getBytes());
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)"error writing remove step", (Throwable)iOException);
            }
            try {
                this.wait();
                String string = (String)this.syncObject;
                return string;
            }
            catch (InterruptedException interruptedException) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String step() throws IOException {
        this.dbs.setLastErrorMessage("");
        this.dbs.setDoingStep(true);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)"doing step");
            this.ostream.write("step$\n".getBytes());
            try {
                this.wait();
                String string = (String)this.syncObject;
                return string;
            }
            catch (InterruptedException interruptedException) {
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run() throws IOException {
        OS2200CorePlugin.logger.debug((Object)("starting go in task " + this.dbs.getTaskId()));
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            this.ostream.write(cmdRun.getBytes());
            try {
                this.wait(10000L);
                if (this.syncObject == null || !(this.syncObject instanceof String) || !((String)this.syncObject).trim().equals("# GO PERFORMED")) {
                    OS2200CorePlugin.logger.debug((Object)"starting run timed out");
                    if (this.syncObject != null && this.syncObject instanceof String) {
                        OS2200CorePlugin.logger.debug((Object)("starting run bad string: " + (String)this.syncObject));
                    } else {
                        this.logBadObject("Bad object on run ", this.syncObject);
                        this.syncNotify(this.syncObject);
                    }
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                OS2200CorePlugin.logger.debug((Object)">>>>Run timeout <<<<<<<", (Throwable)interruptedException);
                this.dbs.setSynchWait(DebugSocketControl.SynchWaiter.waitNone);
                return false;
            }
            return true;
        }
    }

    void logBadObject(String string, Object object) {
        String string2 = "";
        string2 = object == null ? "Null sync object" : "Object is " + object.getClass().getName();
        OS2200CorePlugin.logger.debug((Object)(String.valueOf(string) + string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalkbackPoint getStack() throws IOException {
        WalkbackPoint walkbackPoint = null;
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)"getting stack");
                this.walkingB = true;
                this.ostream.write(getStack.getBytes());
                walkbackPoint = this.soQueues.getWBQueued();
                this.walkingB = false;
                return walkbackPoint;
            }
            catch (InterruptedException interruptedException) {
                this.walkingB = false;
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartLineInfo getStart() throws IOException {
        StartLineInfo startLineInfo = null;
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            block6: {
                OS2200CorePlugin.logger.debug((Object)"Writing getstart");
                this.ostream.write(getStarter.getBytes());
                this.syncObject = this.soQueues.getSLQueued();
                if (this.syncObject != null && this.syncObject instanceof StartLineInfo) break block6;
                OS2200CorePlugin.logger.debug((Object)"getStart syncObject not right");
                return null;
            }
            try {
                startLineInfo = (StartLineInfo)this.syncObject;
                return startLineInfo;
            }
            catch (InterruptedException interruptedException) {
                this.dbs.setSynchWait(DebugSocketControl.SynchWaiter.waitNone);
                OS2200CorePlugin.logger.debug((Object)"timeout getting start line");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramContext getContext() throws IOException {
        ProgramContext programContext = null;
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)"Writing getcontext");
                this.ostream.write(getContext.getBytes());
                this.wait();
                programContext = this.syncObject != null && this.syncObject instanceof ProgramContext ? (ProgramContext)this.syncObject : null;
                return programContext;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPadsLibProcLevel() throws IOException {
        OS2200CorePlugin.logger.debug((Object)"getPadsLibProcLevel");
        this.dbs.setGettingPadsProcLevel(true);
        this.dbs.setLastErrorMessage("");
        this.syncObject = null;
        String string = getPadsProcLevel;
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                int n = 3;
                int n2 = 0;
                this.ostream.write(string.getBytes());
                String string2 = null;
                while (n2 < n) {
                    this.wait(10000L);
                    if (this.syncObject != null) {
                        String string3;
                        if (this.syncObject instanceof String) {
                            string3 = (String)this.syncObject;
                            if (string3.startsWith(PADSLIBPROCLEVEL)) {
                                int n3 = PADSLIBPROCLEVEL.length();
                                string2 = string3.substring(n3).trim();
                                break;
                            }
                            if (string3.indexOf("Procedure PADSLBPRCLVL not found") > -1) {
                                string2 = string3;
                                break;
                            }
                            OS2200CorePlugin.logger.debug((Object)("get pad proc try " + n2++));
                            continue;
                        }
                        string3 = this.syncObject.getClass().getName();
                        OS2200CorePlugin.logger.debug((Object)("Getomsdd was notified with a " + string3));
                        continue;
                    }
                    OS2200CorePlugin.logger.debug((Object)"Get Pads Proc level timed out");
                }
                this.dbs.setGettingPadsProcLevel(false);
                return string2;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getOMSDD(String string) throws IOException {
        String string2 = this.removeCycle(string);
        String string3 = NLS.bind((String)dmpOMSDD, (Object)string2);
        Hashtable hashtable = null;
        OS2200CorePlugin.logger.debug((Object)("writing get OM SDD list \n" + string3));
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                this.ostream.write(string3.getBytes());
                this.wait(300000L);
                if (this.syncObject != null) {
                    if (this.syncObject instanceof Hashtable) {
                        hashtable = (Hashtable)this.syncObject;
                    } else {
                        String string4 = this.syncObject.getClass().getName();
                        OS2200CorePlugin.logger.debug((Object)("Getomsdd was notified with a " + string4));
                        hashtable = null;
                    }
                } else {
                    hashtable = null;
                }
                return hashtable;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OS2200RegisterSets getRegisterSets() throws IOException {
        Object object = null;
        int n = 0;
        OS2200RegisterSets oS2200RegisterSets = null;
        OS2200CorePlugin.logger.debug((Object)"writing get regsiters \ndumpregs \n");
        if (this.syncObject != null) {
            OS2200CorePlugin.logger.debug((Object)("regsets: syncObject before is " + this.syncObject.getClass().getName()));
            object = this.syncObject;
        }
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                this.ostream.write(getRegs.getBytes());
                if (n >= 2) return null;
                this.syncObject = this.soQueues.getRegQueued();
                ++n;
                if (this.syncObject == null) {
                    OS2200CorePlugin.logger.debug((Object)"regsets: get has timed out, object null");
                    return null;
                }
                if (this.syncObject instanceof OS2200RegisterSets) {
                    OS2200CorePlugin.logger.debug((Object)"get registers: right type");
                    return (OS2200RegisterSets)this.syncObject;
                }
                if (object != null && object == this.syncObject) {
                    OS2200CorePlugin.logger.debug((Object)"regsets: get has timed out, object equal");
                    return null;
                }
                String string = this.syncObject.getClass().getName();
                OS2200CorePlugin.logger.debug((Object)("regsets: get has timed out: object is" + string));
                return null;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    public void onWithPads() {
        try {
            OS2200CorePlugin.logger.debug((Object)"doing on with pads");
            this.ostream.write(cmdJustGoOn.getBytes());
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"error writing on with pads", (Throwable)iOException);
        }
    }

    public void taskInterrupt(String string) {
        try {
            String string2 = NLS.bind((String)interruptTask, (Object)string);
            OS2200CorePlugin.logger.debug((Object)("interrupt task " + string2));
            this.ostream.write(string2.getBytes());
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"error writing interrupt task", (Throwable)iOException);
        }
    }

    public void taskSelect(String string) {
        try {
            String string2 = NLS.bind((String)setPadsTask, (Object)string);
            OS2200CorePlugin.logger.debug((Object)("select task " + string2));
            this.ostream.write(string2.getBytes());
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"error writing select task", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllVariables getVariableChildren(String string, String string2, String string3) {
        AllVariables allVariables = null;
        String string4 = NLS.bind((String)getVarChildren, (Object[])new String[]{string, string2, string3});
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)("writing get all variables for task " + this.dbs.getTaskId() + "\n " + string4));
            try {
                this.ostream.write(string4.getBytes());
                allVariables = this.soQueues.getAVQueued();
                if (allVariables != null && this.syncObject instanceof AllVariables) {
                    allVariables.processBlock();
                    return allVariables;
                }
                if (allVariables == null) {
                    OS2200CorePlugin.logger.debug((Object)"GetVariables: syncObject is Null");
                } else {
                    OS2200CorePlugin.logger.debug((Object)("GetVaraibles: wrongObject: " + this.syncObject.getClass().getName()));
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)("GetVaraibles: IOError " + string + iOException.getMessage()));
            }
            return allVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllVariables getVariableName(String string) {
        AllVariables allVariables = null;
        String string2 = NLS.bind((String)getVarName, (Object)string);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)("writing get Variable Name for task " + this.dbs.getTaskId() + "\n " + string2));
            try {
                this.ostream.write(string2.getBytes());
                allVariables = this.soQueues.getAVQueued();
                if (allVariables != null && this.syncObject instanceof AllVariables) {
                    allVariables.processBlock();
                    return allVariables;
                }
                if (allVariables == null) {
                    OS2200CorePlugin.logger.debug((Object)"GetVariable Name: syncObject is Null");
                } else {
                    OS2200CorePlugin.logger.debug((Object)("GetVariable Name: wrongObject: " + this.syncObject.getClass().getName()));
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)("GetVariable Name: IOError " + string + iOException.getMessage()));
            }
            return allVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllVariables getVariables(ProgramPoint programPoint) throws IOException {
        AllVariables allVariables = null;
        String string = this.removeCycle(programPoint.getOmElt());
        this.syncObject = null;
        int n = programPoint.getBlockNumber();
        int n2 = 0;
        this.dbs.getMainConnect().getProjFileName();
        String string2 = Integer.toString(n);
        Object[] objectArray = new String[]{string, programPoint.getOmPart(), string2, "VARIABLES"};
        String string3 = NLS.bind((String)allVars, (Object[])objectArray);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)("writing get all variables for task " + this.dbs.getTaskId() + "\n " + string3));
            this.ostream.write(string3.getBytes());
            try {
                while (n2 < 2) {
                    this.syncObject = this.soQueues.getAVQueued();
                    ++n2;
                    if (this.syncObject != null && this.syncObject instanceof AllVariables) {
                        allVariables = (AllVariables)this.syncObject;
                        allVariables.processBlock();
                        return allVariables;
                    }
                    if (this.syncObject == null) {
                        OS2200CorePlugin.logger.debug((Object)"GetVariables: syncObject is Null");
                        continue;
                    }
                    OS2200CorePlugin.logger.debug((Object)("GetVaraibles: wrongObject: " + this.syncObject.getClass().getName()));
                }
                return null;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    boolean isCalc(String string) {
        if (string.contains("+")) {
            return true;
        }
        if (string.contains("-")) {
            return true;
        }
        if (string.contains("*")) {
            return true;
        }
        if (string.contains("/")) {
            return true;
        }
        if (string.contains("^")) {
            return true;
        }
        return string.contains("^^");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneVarValue getVariableJ(String string, String string2, String string3, int n) throws IOException {
        String string4;
        this.dbs.setLastErrorMessage("");
        OneVarValue oneVarValue = null;
        String string5 = Integer.toString(n);
        String string6 = this.removeCycle(string2);
        String string7 = "";
        byte[] byArray = string.getBytes();
        int n2 = 2;
        while (n2 < byArray.length - 2) {
            string4 = Integer.toHexString(byArray[n2]);
            string7 = String.valueOf(string7) + string4.substring(string4.length() - 2);
            ++n2;
        }
        Object[] objectArray = new String[]{string7, string6, string3, string5};
        string4 = NLS.bind((String)getOneVariableJ, (Object[])objectArray);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)("writing one variable \n" + string4));
                this.ostream.write(string4.getBytes());
                oneVarValue = this.soQueues.getOVQueued();
                return oneVarValue;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneVarValue getVariable(String string, String string2, String string3, int n) throws IOException {
        this.dbs.setLastErrorMessage("");
        OneVarValue oneVarValue = null;
        String string4 = Integer.toString(n);
        String string5 = this.removeCycle(string2);
        String string6 = string.replaceAll("\\x5b", "(");
        string6 = string6.replaceAll("\\x5d", ")");
        Object[] objectArray = new String[]{string6, string5, string3, string4};
        String string7 = NLS.bind((String)getOneVariable, (Object[])objectArray);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)("writing one variable \n" + string7));
                this.ostream.write(string7.getBytes());
                oneVarValue = this.soQueues.getOVQueued();
                return oneVarValue;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneVarValue getArray(String string, int n, int n2, String string2, String string3, int n3, int n4) throws IOException {
        this.dbs.setLastErrorMessage("");
        OneVarValue oneVarValue = null;
        String string4 = Integer.toString(n3);
        String string5 = this.removeCycle(string2);
        String string6 = Integer.toString(n);
        String string7 = Integer.toString(n2);
        String string8 = Integer.toString(n4);
        String string9 = string.replaceAll("\\x5b", "(");
        string9 = string9.replaceAll("\\x5d", ")");
        Object[] objectArray = new String[]{string9, string6, string7, string5, string3, string4, string8};
        String string10 = NLS.bind((String)getArray, (Object[])objectArray);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)("writing one variable \n" + string10));
                this.ostream.write(string10.getBytes());
                oneVarValue = this.soQueues.getOVQueued();
                return oneVarValue;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneVarValue getArrayJ(String string, int n, int n2, String string2, String string3, int n3, int n4) throws IOException {
        this.dbs.setLastErrorMessage("");
        OneVarValue oneVarValue = null;
        String string4 = Integer.toString(n3);
        String string5 = this.removeCycle(string2);
        String string6 = Integer.toString(n);
        String string7 = Integer.toString(n2);
        String string8 = Integer.toString(n4);
        String string9 = string.replaceAll("\\x5b", "(");
        string9 = string9.replaceAll("\\x5d", ")");
        Object[] objectArray = new String[]{string9, string6, string7, string5, string3, string4, string8};
        String string10 = NLS.bind((String)getArrayJ, (Object[])objectArray);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)("writing one variable \n" + string10));
                this.ostream.write(string10.getBytes());
                oneVarValue = this.soQueues.getOVQueued();
                return oneVarValue;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneVarValue getCSring(String string, int n) throws IOException {
        this.dbs.setLastErrorMessage("");
        OneVarValue oneVarValue = null;
        String string2 = string.replaceAll("\\x5b", "(");
        string2 = string2.replaceAll("\\x5d", ")");
        String string3 = Integer.toString(n);
        String string4 = NLS.bind((String)dispCString, (Object)string3);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)("writing CString \n" + string4));
                this.ostream.write(string4.getBytes());
                oneVarValue = this.soQueues.getOVQueued();
                return oneVarValue;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    public void changeVariable(String string, String string2, String string3, String string4, int n) throws IOException {
        String string5 = string2;
        String string6 = Integer.toString(n);
        String string7 = this.removeCycle(string3);
        Object[] objectArray = new String[]{string, string5, string7, string4, string6};
        String string8 = NLS.bind((String)changeOneVariable, (Object[])objectArray);
        OS2200CorePlugin.logger.debug((Object)("writing change variable \n" + string8));
        this.ostream.write(string8.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryDumpModule dumpMemory(long l, int n) throws IOException {
        MemoryDumpModule memoryDumpModule = null;
        Long l2 = l;
        String string = "00000000000" + Long.toOctalString(l2);
        string = string.substring(string.length() - 12);
        String string2 = String.valueOf(string.substring(0, 6)) + "T=>" + string.substring(6) + "T";
        String string3 = Integer.toString(n);
        String string4 = NLS.bind((String)dumpMemory, (Object)string2, (Object)string3);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)"writing get memory \ndumpregs \n");
                this.ostream.write(string4.getBytes());
                this.wait();
                memoryDumpModule = this.syncObject != null && this.syncObject instanceof MemoryDumpModule ? (MemoryDumpModule)this.syncObject : null;
                return memoryDumpModule;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryDumpModule dumpMemoryFromPadsAdd(String string, int n) throws IOException {
        MemoryDumpModule memoryDumpModule = null;
        String string2 = Integer.toString(n);
        String string3 = NLS.bind((String)dumpMemory, (Object)string, (Object)string2);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                OS2200CorePlugin.logger.debug((Object)"writing get memory \ndumpregs \n");
                this.ostream.write(string3.getBytes());
                this.wait();
                memoryDumpModule = this.syncObject != null && this.syncObject instanceof MemoryDumpModule ? (MemoryDumpModule)this.syncObject : null;
                return memoryDumpModule;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    public synchronized ProcedureList getAllProcs(StopPoint stopPoint, ProcedureList procedureList) throws IOException {
        ProcedureList procedureList2 = null;
        String string = stopPoint.getOmElt();
        if (string != null && string.length() > 0) {
            string = this.removeCycle(string);
            String string2 = stopPoint.getOmPart();
            String string3 = stopPoint.getStopLineNumber();
            int n = string3.indexOf(".");
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            Object[] objectArray = new String[]{string, string2, string3, " "};
            String string4 = NLS.bind((String)allProcs, (Object[])objectArray);
            try {
                OS2200CorePlugin.logger.debug((Object)("writing get all procs \n" + string4));
                this.ostream.write(string4.getBytes());
                procedureList2 = this.soQueues.getPLQueued();
                if (procedureList2 != null) {
                    procedureList2.mergeList(procedureList);
                    return procedureList2;
                }
                OS2200CorePlugin.logger.debug((Object)"bad object for procs");
                return null;
            }
            catch (InterruptedException interruptedException) {
                OS2200CorePlugin.logger.debug((Object)"timeout waiting for procs");
                this.dbs.setSynchWait(DebugSocketControl.SynchWaiter.waitNone);
                return null;
            }
        }
        return null;
    }

    protected void getSourceName(String string, String string2) throws IOException {
        String string3 = "'" + this.removeCycle(string) + "'";
        String string4 = "'" + string2 + "'";
        String string5 = NLS.bind((String)getSrcName, (Object)string3, (Object)string4);
        OS2200CorePlugin.logger.debug((Object)("writing get getSrc \n" + string5));
        this.ostream.write(string5.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TaskInfo> getTaskList() throws IOException {
        ArrayList arrayList = null;
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            block6: {
                OS2200CorePlugin.logger.debug((Object)"get task listLISTTASKS\n");
                this.ostream.write(taskList.getBytes());
                this.wait(30000L);
                if (this.syncObject != null && this.syncObject instanceof ArrayList) break block6;
                return null;
            }
            try {
                arrayList = (ArrayList)this.syncObject;
                return arrayList;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setBrkpt(String string, String string2, String string3) throws IOException {
        String string4 = this.removeCycle(string);
        Object[] objectArray = new String[]{string4, string2, string3};
        String string5 = NLS.bind((String)setTrap, (Object[])objectArray);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            block6: {
                OS2200CorePlugin.logger.debug((Object)("writing set trap" + string5));
                this.ostream.write(string5.getBytes());
                this.syncObject = this.soQueues.getBPQueued();
                if (this.syncObject != null && this.syncObject instanceof String) break block6;
                return "# *Error: timeout calling";
            }
            try {
                String string6 = (String)this.syncObject;
                return string6;
            }
            catch (InterruptedException interruptedException) {
                return "";
            }
        }
    }

    public void setVariableTrap(String string, int n, String string2, String string3, int n2) throws IOException {
        String string4 = this.removeCycle(string2);
        Object[] objectArray = new String[]{string, Integer.toString(n), string4, string3, Integer.toString(n2)};
        String string5 = NLS.bind((String)setTrapVar, (Object[])objectArray);
        OS2200CorePlugin.logger.debug((Object)("writing set trap variable: " + string5));
        this.ostream.write(string5.getBytes());
    }

    public void stopGoFlag() throws IOException {
        OS2200CorePlugin.logger.debug((Object)"writing set Stop go flag");
        this.ostream.write(cmdStopGoFlag.getBytes());
    }

    public void removeBrkpt(String string, String string2, String string3) throws IOException {
        String string4 = this.removeCycle(string);
        Object[] objectArray = new String[]{string3, string2, string4};
        String string5 = NLS.bind((String)removeBrkpt, (Object[])objectArray);
        OS2200CorePlugin.logger.debug((Object)("writing remove brkpt" + string5));
        this.ostream.write(string5.getBytes());
    }

    public void removeAllBrkpts() throws IOException {
        OS2200CorePlugin.logger.debug((Object)"writing remove  all brkpts");
        this.ostream.write(removeAllBrkpts.getBytes());
    }

    public void removeTrapChange(int n) throws IOException {
        String string = NLS.bind((String)removeTrapVar, (Object)Integer.toString(n));
        OS2200CorePlugin.logger.debug((Object)("writing remove  trap change" + string));
        this.ostream.write(string.getBytes());
    }

    public void removeAllTrapChange() throws IOException {
        OS2200CorePlugin.logger.debug((Object)"writing remove  all trap cnange");
        this.ostream.write(removeAllTrapChange.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object listSource(String string, int n) {
        String string2 = NLS.bind((String)listSource, (Object)(String.valueOf(Integer.toString(n)) + ".C1"), (Object)this.removeCycle(string));
        AllVariables allVariables = null;
        try {
            OS2200CorePlugin.logger.debug((Object)("writing list Source: " + string2));
            this.ostream.write(string2.getBytes());
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"error writing writing list Source", (Throwable)iOException);
        }
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                this.wait();
                allVariables = (AllVariables)this.syncObject;
                return allVariables;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    public String removeCycle(String string) {
        int n;
        int n2 = string.indexOf("(");
        if (n2 > 0 && (n = string.indexOf(")", n2)) > 0) {
            String string2 = String.valueOf(string.substring(0, n2)) + string.substring(n + 1);
            return string2;
        }
        return string;
    }

    protected boolean walkingBack() {
        return this.walkingB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllVariables getStructureInfoInArray(String string, String string2) {
        AllVariables allVariables = null;
        String string3 = NLS.bind((String)getStrInfoInArray, (Object)string, (Object)string2);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            OS2200CorePlugin.logger.debug((Object)("writing get Variable Name for task " + this.dbs.getTaskId() + "\n " + string3));
            try {
                this.ostream.write(string3.getBytes());
                allVariables = this.soQueues.getAVQueued();
                if (allVariables != null && this.syncObject instanceof AllVariables) {
                    allVariables.processBlock();
                    return allVariables;
                }
                if (allVariables == null) {
                    OS2200CorePlugin.logger.debug((Object)"GetVariable Name: syncObject is Null");
                } else {
                    OS2200CorePlugin.logger.debug((Object)("GetVariable Name: wrongObject: " + this.syncObject.getClass().getName()));
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)("GetVariable Name: IOError " + string + iOException.getMessage()));
            }
            return allVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String TestString(String string) {
        OS2200CorePlugin.logger.debug((Object)("starting go in task " + this.dbs.getTaskId()));
        String string2 = NLS.bind((String)testStr, (Object)string);
        WriterTo2200 writerTo2200 = this;
        synchronized (writerTo2200) {
            try {
                this.ostream.write(string2.getBytes());
            }
            catch (IOException iOException) {
                return iOException.getLocalizedMessage();
            }
            try {
                this.wait(10000L);
                if (this.syncObject == null || !(this.syncObject instanceof String)) {
                    String string3 = (String)this.syncObject;
                    return string3;
                }
                return "Bad Thing";
            }
            catch (InterruptedException interruptedException) {
                OS2200CorePlugin.logger.debug((Object)">>>>Run timeout <<<<<<<", (Throwable)interruptedException);
                this.dbs.setSynchWait(DebugSocketControl.SynchWaiter.waitNone);
                return "Bad Thing";
            }
        }
    }
}

