/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.StopPoint;

public class WalkbackPoint
extends StopPoint {
    String offset;
    private static final String subLine = "# Called from line %s offset %s in %s [%s].";
    private static final String mainLine = "# Called from %s [%s].";
    private WalkbackPoint nextPoint;
    int level;

    public WalkbackPoint(String string) {
        if (string.indexOf("].") > -1) {
            this.level = 0;
            this.nextPoint = null;
            this.startMod = null;
            this.offset = null;
            this.ParseLine(string);
        } else {
            this.completed = false;
        }
    }

    @Override
    public void ParseLine(String string) {
        if (string.indexOf("# Called from line") > -1) {
            Object[] objectArray = FormatMan.sscanf(subLine, string.trim());
            if (objectArray.length == 4) {
                this.stopLineNumber = (String)objectArray[0];
                this.offset = (String)objectArray[1];
                this.stopElement = (String)objectArray[2];
                String string2 = (String)objectArray[3];
                this.parseBrackets(string2);
                this.hasSDD = true;
            }
        } else {
            Object[] objectArray = FormatMan.sscanf(mainLine, string);
            if (objectArray.length == 2) {
                this.startMod = (String)objectArray[0];
                String string3 = (String)objectArray[1];
                this.parseBrackets(string3);
            }
        }
    }

    @Override
    public String getStartMod() {
        return this.startMod;
    }

    public String getOffset() {
        return this.offset;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void addNextWalkbackPoint(WalkbackPoint walkbackPoint) {
        if (this.nextPoint != null) {
            this.nextPoint.addNextWalkbackPoint(walkbackPoint);
        } else {
            walkbackPoint.setLevel(this.level + 1);
            this.nextPoint = walkbackPoint;
        }
    }

    public WalkbackPoint getNextWalkbackPoint() {
        return this.nextPoint;
    }
}

