/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.VariableSet;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Point;

public class VariableInfo {
    private String variableType = "";
    private String storage = "";
    private String value = "";
    private String variableName;
    ArrayList<VariableInfo> subVariables = new ArrayList();
    VariableInfo currentSubVariable;
    private boolean complete = false;
    private ArrayList<String> errorMsgs;
    private ArrayList<String> totalNames = new ArrayList();
    private ArrayList<VariableInfo> ancestry;
    private String childInfo;
    private boolean hasChildren;
    private String sddOffset;
    private String llaString;
    private String llaBDI;
    private String llaOffsetS;
    private int llaOffset;
    Hashtable<String, String> valueTable;
    private boolean isArray;
    private String[] values;
    private String variableLine;
    private static final String varFormat = "%s %b[%s] [%s]%b[%s][%s] \\%s ||";
    private static final String arryFormat = "(%s..%s)";
    private static final String hsChildren = "HAS CHILDREN,";
    private String stIndex;
    private String enIndex;
    private int stInd;
    private int enInd;
    private int nDim;
    private Point[] dimLimits;

    public ArrayList<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public void setErrorMsgs(ArrayList<String> arrayList) {
        this.errorMsgs = arrayList;
    }

    public int getnDim() {
        return this.nDim;
    }

    public Point[] getDimLimits() {
        return this.dimLimits;
    }

    public VariableInfo() {
        this.ancestry = new ArrayList();
        this.ancestry.add(this);
        this.currentSubVariable = null;
    }

    public VariableInfo(ArrayList<String> arrayList, ArrayList<VariableInfo> arrayList2) {
        this.totalNames.addAll(arrayList);
        this.ancestry = new ArrayList();
        this.ancestry.addAll(arrayList2);
        this.ancestry.add(this);
        this.currentSubVariable = null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public void parseStart(String string) {
        this.variableLine = string;
        String string2 = this.variableLine.trim();
        if (!string2.endsWith("||")) {
            this.complete = false;
        } else {
            this.variableLine = string2;
            this.parseTheLine();
            this.complete = true;
        }
    }

    public void parseEnd(String string) {
        this.variableLine = String.valueOf(this.variableLine) + string;
        String string2 = this.variableLine.trim();
        if (!string2.endsWith("||")) {
            this.complete = false;
        } else {
            this.variableLine = string2;
            this.parseTheLine();
            this.complete = true;
        }
    }

    public String getSegmentedName() {
        String string = "";
        if (this.totalNames != null) {
            for (String string2 : this.totalNames) {
                if (string2 == null) continue;
                string = String.valueOf(string) + "." + string2;
            }
            if (string.length() > 1) {
                string = string.substring(1);
            }
        }
        return string;
    }

    public ArrayList<String> getNameTree() {
        return this.totalNames;
    }

    public void parseTheLine() {
        Object[] objectArray = FormatMan.sscanf(varFormat, this.variableLine);
        if (objectArray.length < 3) {
            this.variableName = "Dummy";
            this.variableType = "none";
            this.storage = "none";
        }
        this.variableName = (String)objectArray[0];
        this.totalNames.add(this.variableName);
        this.variableType = (String)objectArray[1];
        this.storage = (String)objectArray[2];
        if (objectArray.length > 3) {
            this.childInfo = (String)objectArray[3];
            int n = this.childInfo.indexOf(hsChildren);
            if (n >= 0) {
                this.hasChildren = true;
                int n2 = this.childInfo.indexOf(",", n + hsChildren.length());
                if (n2 > -1) {
                    this.sddOffset = this.childInfo.substring(n + hsChildren.length(), n2);
                    this.llaString = this.childInfo.substring(n2 + 1).trim();
                    this.parseLLa();
                } else {
                    this.sddOffset = this.childInfo.substring(n + hsChildren.length());
                    this.llaString = "";
                }
            } else {
                this.hasChildren = false;
            }
        }
        if (objectArray.length > 4) {
            String string = (String)objectArray[4];
            this.parseArrayInfo(string);
        }
        if (objectArray.length == 6) {
            this.setValueFromTable(((String)objectArray[5]).trim());
        } else {
            this.value = "";
        }
    }

    void parseArrayInfo(String string) {
        int n;
        int n2;
        this.isArray = false;
        if (string.indexOf("<NONE>") > 0) {
            return;
        }
        if (string.indexOf("]") > -1 && (n2 = string.indexOf("]")) != -1) {
            string = string.substring(0, n2);
        }
        n2 = string.length();
        int n3 = string.indexOf(";");
        if (n3 > 0 && (n = string.indexOf(";", n3 + 1)) > 0) {
            this.sddOffset = string.substring(n3 + 1, n).trim();
            int n4 = string.indexOf(";", n + 1);
            if (n4 > 0) {
                String string2 = string.substring(n + 1, n4).trim();
                this.nDim = Integer.parseInt(string2);
                int n5 = 0;
                this.dimLimits = new Point[this.nDim];
                int n6 = n4;
                int n7 = n4;
                while (n5 < this.nDim) {
                    n6 = string.indexOf(",", n7 + 1);
                    if (n6 > 0 || n5 == this.nDim - 1) {
                        String string3;
                        int n8;
                        if (n6 < 0) {
                            n6 = n2;
                        }
                        if ((n8 = (string3 = string.substring(n7 + 1, n6)).indexOf(":")) > 0) {
                            String string4 = string3.substring(0, n8);
                            String string5 = string3.substring(n8 + 1);
                            int n9 = 0;
                            int n10 = 0;
                            try {
                                n9 = Integer.parseInt(string4);
                                n10 = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("bad array info" + string);
                            }
                            this.dimLimits[n5] = new Point(n9, n10);
                        }
                    }
                    n7 = n6;
                    ++n5;
                }
                this.isArray = true;
            }
        }
    }

    public void parseLLa() {
        this.llaOffset = 0;
        this.llaOffsetS = "";
        this.llaBDI = "";
    }

    public String getLBDI() {
        return this.llaBDI;
    }

    public String getOffset() {
        return this.llaOffsetS;
    }

    public VariableInfo createLeafVariable(int n) {
        if (n == 0) {
            this.currentSubVariable = new VariableInfo(this.totalNames, this.ancestry);
            this.subVariables.add(this.currentSubVariable);
            return this.currentSubVariable;
        }
        if (this.currentSubVariable != null) {
            int n2 = --n;
            return this.currentSubVariable.createLeafVariable(n2);
        }
        return null;
    }

    public String makeSegmentedName() {
        String string = this.totalNames.get(0);
        int n = this.totalNames.size();
        int n2 = 1;
        while (n2 < n) {
            string = "." + this.totalNames.get(n2);
            ++n2;
        }
        return string;
    }

    public Hashtable<String, String> getBaseValueTable() {
        VariableInfo variableInfo = this.ancestry.get(0);
        if (variableInfo instanceof VariableSet) {
            VariableSet variableSet = (VariableSet)variableInfo;
            return variableSet.getValueTable();
        }
        return null;
    }

    public void setValueFromTable(String string) {
        this.value = "";
        if (string == null || string.equals("")) {
            return;
        }
        boolean bl = false;
        String string2 = string;
        if (string2.startsWith("'")) {
            bl = true;
            if (string2.length() > 2) {
                string2 = string2.substring(1, string2.length() - 1).trim();
            } else {
                OS2200CorePlugin.logger.debug((Object)("input string value not found: " + string + ", " + this.variableName));
                return;
            }
        }
        if (string2.startsWith("%%&")) {
            int n = string2.indexOf("%%&", 2);
            if (n != -1) {
                String string3 = string2.substring(2, n);
                Hashtable<String, String> hashtable = this.getBaseValueTable();
                if (hashtable != null) {
                    String string4;
                    if (this.varIsArray()) {
                        string3 = string3.substring(0, string3.indexOf("("));
                        this.values = new String[this.enInd - this.stInd + 1];
                        int n2 = this.stInd;
                        while (n2 <= this.enInd) {
                            String string5 = String.valueOf(string3) + "(" + Integer.toString(n2) + ")";
                            String string6 = hashtable.get(string5);
                            this.values[n2 - this.stInd] = string6 != null ? string6 : "";
                            ++n2;
                        }
                    }
                    if ((string4 = hashtable.get(string3)) != null) {
                        this.value = bl ? "'" + string4 + "'" : string4;
                        return;
                    }
                }
            }
        } else {
            this.value = string2;
        }
    }

    boolean varIsArray() {
        this.isArray = false;
        int n = this.variableName.indexOf("(");
        try {
            String string;
            Object[] objectArray;
            if (n > 0 && (objectArray = FormatMan.sscanf(arryFormat, string = this.variableName.substring(n))).length > 0) {
                this.stIndex = (String)objectArray[0];
                this.stInd = Integer.parseInt(this.stIndex);
                if (objectArray.length > 1) {
                    this.enIndex = (String)objectArray[1];
                    this.enInd = Integer.parseInt(this.enIndex);
                    this.isArray = true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            OS2200CorePlugin.logger.info((Object)("indexes for array values did not parse " + this.stIndex + " " + this.enIndex));
        }
        return this.isArray;
    }

    public String[] getArrayString() {
        return this.values;
    }

    public int getArrayStartIndex() {
        return this.stInd;
    }

    public int getArrayEndIndex() {
        return this.enInd;
    }

    public ArrayList<VariableInfo> getSubVariables() {
        return this.subVariables;
    }

    public Hashtable<String, String> getValueTable() {
        return this.valueTable;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public void setVariableType(String string) {
        this.variableType = string;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String string) {
        this.storage = string;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isLocal() {
        if (this instanceof VariableSet) {
            VariableSet variableSet = (VariableSet)this;
            return variableSet.getType() == 1;
        }
        VariableInfo variableInfo = this.ancestry.get(0);
        if (variableInfo instanceof VariableSet) {
            VariableSet variableSet = (VariableSet)variableInfo;
            return variableSet.getType() == 1;
        }
        return false;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public String getSddOffset() {
        return this.sddOffset;
    }
}

