/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.StopPoint;

public class TrapPoint
extends StopPoint {
    String stopElement;
    String stopLineNumber;
    boolean completed = true;
    String lineForm;
    String lineTrapPlain = "# TRAP EXECUTION at line %s in %s [%s].";
    String lineTrapChange = "# TRAP CHANGE %s in %s at line %s in %s [%s].";
    String lineTrapStep = "# TRAP EXECUTION STEPID at line %s in %s [%s].";
    String lineNoSDDTRAP = "# TRAP EXECUTION STEPID at %s [%s].";

    public TrapPoint() {
    }

    public TrapPoint(String string) {
        this.ParseLine(string);
    }

    @Override
    public void ParseLine(String string) {
        block9: {
            if (string.indexOf("].") > -1) {
                try {
                    if (string.indexOf(" line ") > 0) {
                        this.lineForm = this.lineTrapPlain;
                        if (string.indexOf("TRAP EXECUTION STEPID") > 0) {
                            this.lineForm = this.lineTrapStep;
                        }
                        Object[] objectArray = FormatMan.sscanf(this.lineForm, string);
                        this.stopLineNumber = (String)objectArray[0];
                        this.stopElement = (String)objectArray[1];
                        String string2 = (String)objectArray[2];
                        this.parseBrackets(string2);
                        this.hasSDD = true;
                        break block9;
                    }
                    this.lineForm = this.lineNoSDDTRAP;
                    Object[] objectArray = FormatMan.sscanf(this.lineForm, string);
                    if (objectArray.length > 1) {
                        this.stopLineNumber = "0";
                        this.stopElement = (String)objectArray[0];
                        String string3 = (String)objectArray[1];
                        this.parseBrackets(string3);
                    } else if (objectArray.length > 1) {
                        this.stopLineNumber = "0";
                        this.stopElement = "No SDD";
                    }
                    this.hasSDD = false;
                }
                catch (Throwable throwable) {
                    OS2200CorePlugin.logger.info((Object)"unable to parse stop point", throwable);
                    this.stopLineNumber = "0";
                    this.stopElement = "Not Found";
                    this.startMod = "Not Found";
                    this.hasSDD = false;
                }
            } else {
                this.completed = false;
            }
        }
    }

    @Override
    public String getStopElement() {
        return this.stopElement;
    }

    @Override
    public String getStopLineNumber() {
        return this.stopLineNumber;
    }

    @Override
    public boolean complete() {
        return this.completed;
    }

    @Override
    public String prefixText() {
        return "Suspended Breakpoint";
    }
}

