/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.StopPoint;

public class TrapCondition
extends StopPoint {
    private String errorCode = "";
    private String errorMessage = "";
    private String stopLineOffset = "";
    private String parens = "";
    private String fullLine;
    private String trapError;
    private static final String tcFormat = "# TRAP CONDITION(%s) Code %s in line %s offset %s in %s [%s].";
    private String taskName;

    public TrapCondition(String string) {
        this.stopLineNumber = "";
        this.stopElement = "";
        this.taskName = "";
        this.trapError = "";
        this.ParseLine(string);
    }

    @Override
    public void ParseLine(String string) {
        if (string.indexOf("].") > -1) {
            this.fullLine = string;
            this.lookForError();
            Object[] objectArray = FormatMan.sscanf(tcFormat, string);
            if (objectArray.length == 6) {
                this.parens = (String)objectArray[0];
                this.errorCode = (String)objectArray[1];
                this.stopLineNumber = (String)objectArray[2];
                this.stopLineOffset = (String)objectArray[3];
                this.taskName = (String)objectArray[4];
                String string2 = (String)objectArray[5];
                this.parseBrackets(string2);
                this.hasSDD = true;
            }
            this.completed = true;
            return;
        }
        this.completed = false;
    }

    private void lookForError() {
        int n;
        int n2 = this.fullLine.indexOf("*E");
        if (n2 > -1 && (n = this.fullLine.indexOf(".", n2 + 5)) > -1) {
            this.trapError = this.fullLine.substring(n2, n);
        }
    }

    @Override
    public String getStopElement() {
        String string = super.getStopElement();
        string = String.valueOf(string) + this.trapError;
        return string;
    }

    @Override
    public String prefixText() {
        return "Trap Condition ";
    }
}

