/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.StopPoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IWatchpoint;

public class TrapChangePoint
extends StopPoint {
    String stopElement;
    String stopLineNumber;
    String trapID;
    String trapLoc;
    boolean completed = true;
    String varName;
    public static final String WatchPoint = "com.unisys.tde.debug.core.os2200WatchpointMarker";
    private static final String VarNameKey = "com.unisys.tde.debug.core.variableName";
    private static final String TrapNumKey = "com.unisys.tde.debug.core.trapNumber";
    String lineTrapChange = "# TRAP CHANGE %s in %s at line %s in %s [%s].";

    public TrapChangePoint() {
    }

    public TrapChangePoint(String string) {
        this.ParseLine(string);
    }

    @Override
    public void ParseLine(String string) {
        if (string.indexOf("].") > -1) {
            Object[] objectArray = FormatMan.sscanf(this.lineTrapChange, string);
            this.trapID = (String)objectArray[0];
            this.findVarName(this.trapID);
            this.trapLoc = (String)objectArray[1];
            this.stopLineNumber = (String)objectArray[2];
            if (this.stopLineNumber.indexOf(".") >= 0) {
                int n = this.stopLineNumber.indexOf(".");
                this.stopLineNumber = this.stopLineNumber.substring(0, n);
            }
            this.stopElement = (String)objectArray[3];
            String string2 = (String)objectArray[4];
            this.parseBrackets(string2);
            this.hasSDD = true;
        } else {
            this.completed = false;
        }
    }

    @Override
    public String getStopElement() {
        return this.stopElement;
    }

    @Override
    public String getStopLineNumber() {
        return this.stopLineNumber;
    }

    public String getTrapID() {
        return this.trapID;
    }

    public String getTrapLoc() {
        return this.trapLoc;
    }

    @Override
    public boolean complete() {
        return this.completed;
    }

    @Override
    public String prefixText() {
        return "Suspended Watchpoint for " + this.varName + " ";
    }

    private void findVarName(String string) {
        this.varName = "unknown";
        if (string.startsWith("TRAP$")) {
            IBreakpoint[] iBreakpointArray;
            String string2 = string.substring(5);
            DebugPlugin debugPlugin = DebugPlugin.getDefault();
            IBreakpointManager iBreakpointManager = debugPlugin.getBreakpointManager();
            IBreakpoint[] iBreakpointArray2 = iBreakpointArray = iBreakpointManager.getBreakpoints();
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint iBreakpoint = iBreakpointArray2[n2];
                if (iBreakpoint instanceof IWatchpoint) {
                    String string3 = null;
                    IMarker iMarker = iBreakpoint.getMarker();
                    try {
                        if (iMarker.getType().equals(WatchPoint)) {
                            string3 = (String)iMarker.getAttribute(TrapNumKey);
                            this.varName = (String)iMarker.getAttribute(VarNameKey);
                        }
                    }
                    catch (CoreException coreException) {
                        OS2200CorePlugin.logger.info((Object)"error reading watchpoint marker", (Throwable)coreException);
                    }
                    if (string3 != null && string3.equals(string2)) {
                        return;
                    }
                }
                ++n2;
            }
        }
    }
}

