/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.FormatMan;

public class TaskInfo {
    TaskState taskState = TaskState.WaitingPads;
    String taskID;
    String lsID;
    String SysUniqueID;
    private static final String taskL1 = "#    PADS Task ID: %s,  System Added: %s,  Activity ID: %s";
    private static final String taskL2 = "#    Linking System ID: %s";
    private static final String taskL3 = "#    System-Unique ID: %s";
    private static final String taskL4 = "#    Status: %s";
    private static final String inPads = "Executing PADS Commands";
    private static final String executing = "Executing";
    private static final String waitingForPads = "Awaiting PADS Command Processor";

    public void parsePadsLine(String string) {
        Object[] objectArray = FormatMan.sscanf(taskL1, string);
        if (objectArray.length > 1) {
            this.taskID = (String)objectArray[0];
        }
    }

    public void parseLSIDLine(String string) {
        Object[] objectArray = FormatMan.sscanf(taskL2, string);
        if (objectArray.length == 1) {
            this.lsID = (String)objectArray[0];
        }
    }

    public void parseSysUniqueID(String string) {
        Object[] objectArray = FormatMan.sscanf(taskL3, string);
        if (objectArray.length == 1) {
            this.SysUniqueID = (String)objectArray[0];
        }
    }

    public void parseTaskState(String string) {
        Object[] objectArray = FormatMan.sscanf(taskL4, string);
        if (objectArray.length == 1) {
            String string2 = (String)objectArray[0];
            OS2200CorePlugin.logger.debug((Object)("parse Task State: " + string2));
            if (string2.endsWith(executing)) {
                this.taskState = TaskState.Exectuing;
                OS2200CorePlugin.logger.debug((Object)"parse Task State. State set to Executing");
            } else if (string2.endsWith(inPads)) {
                this.taskState = TaskState.PadsCommand;
                OS2200CorePlugin.logger.debug((Object)"parse Task State. State set to PadsCommand");
            } else if (string2.endsWith(waitingForPads)) {
                this.taskState = TaskState.WaitingPads;
                OS2200CorePlugin.logger.debug((Object)"parse Task State. State set to WaitingPads");
            } else {
                OS2200CorePlugin.logger.debug((Object)"parse Task State. State set to WaitingPads by Default");
                this.taskState = TaskState.WaitingPads;
            }
        }
    }

    public String getLinkingSystemID() {
        return this.lsID;
    }

    public String getSystemUniqueID() {
        return this.SysUniqueID;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public static enum TaskState {
        Exectuing(0),
        PadsCommand(1),
        WaitingPads(2);

        private final int value;

        private TaskState(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }
}

