/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.ProgramPoint;

public class StopPoint
extends ProgramPoint {
    String stopElement;
    String stopLineNumber;
    boolean completed = true;
    boolean hasSDD = false;
    String startMod;
    String lineForm = "# Step completed. Next executable statement at line %s in %s [%s].";
    static final String formNoSDD = "# Step completed. Next executable statement at%b%s[%s]";
    static final String formPlain = "# Step completed. Next executable statement at%bline %s in %s [%s]";
    static final String formOffset = "# Step completed. Next executable statement at%bline %s offset %s in %s [%s]";
    String ErrorMessage;

    public StopPoint() {
    }

    public StopPoint(String string) {
        this.ErrorMessage = "";
        this.startMod = "";
        this.ParseLine(string);
    }

    public void setErrorMessage(String string) {
        this.ErrorMessage = string;
    }

    public String getErrorMessage() {
        return this.ErrorMessage;
    }

    public void ParseLine(String string) {
        block7: {
            if (string.indexOf("]") > -1) {
                try {
                    if (string.indexOf(" offset ") > 0) {
                        this.lineForm = formOffset;
                        Object[] objectArray = FormatMan.sscanf(formOffset, string);
                        this.stopLineNumber = (String)objectArray[0];
                        this.stopElement = (String)objectArray[2];
                        String string2 = (String)objectArray[3];
                        this.parseBrackets(string2);
                        this.hasSDD = true;
                        break block7;
                    }
                    if (string.indexOf(" in ") > 0) {
                        Object[] objectArray = FormatMan.sscanf(formPlain, string);
                        this.stopLineNumber = (String)objectArray[0];
                        this.stopElement = (String)objectArray[1];
                        String string3 = (String)objectArray[2];
                        this.parseBrackets(string3);
                        this.hasSDD = true;
                        break block7;
                    }
                    Object[] objectArray = FormatMan.sscanf(formNoSDD, string);
                    if (objectArray.length > 1) {
                        this.stopLineNumber = "0";
                        this.startMod = this.stopElement = (String)objectArray[0];
                        String string4 = (String)objectArray[1];
                        this.parseBrackets(string4);
                        this.hasSDD = false;
                        break block7;
                    }
                    this.stopLineNumber = "0";
                    this.stopElement = "Not Found";
                    this.startMod = "Not Found";
                    this.hasSDD = false;
                }
                catch (Throwable throwable) {
                    OS2200CorePlugin.logger.info((Object)"unable to parse stop point", throwable);
                    this.stopLineNumber = "0";
                    this.stopElement = "Not Found";
                    this.startMod = "Not Found";
                    this.hasSDD = false;
                }
            } else {
                this.completed = false;
            }
        }
    }

    public String getStopElement() {
        return this.stopElement;
    }

    public String getStopLineNumber() {
        return this.stopLineNumber;
    }

    public boolean complete() {
        return this.completed;
    }

    public String getStartMod() {
        return this.startMod;
    }

    public String prefixText() {
        return "End Step";
    }

    public boolean hasSDD() {
        return this.hasSDD;
    }
}

