/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.debug.core.comm.FormatMan;
import java.util.ArrayList;

public class ProcedureList {
    private static final String PROCEDURE = "PROCEDURE";
    private static final String FUNCTION = "FUNCTION";
    ArrayList<Integer> blocks = new ArrayList();
    int count = 0;
    ArrayList<String> procName = new ArrayList();
    boolean complete = false;
    String lnFmt = "# [%s] BLOCK%b%d %s";

    public void addProc(String string) {
        Object[] objectArray = FormatMan.sscanf(this.lnFmt, string);
        this.blocks.add((Integer)objectArray[1]);
        String string2 = (String)objectArray[2];
        if (string2.startsWith(PROCEDURE)) {
            string2 = string2.substring(PROCEDURE.length() + 1).trim();
        }
        if (string2.startsWith(FUNCTION)) {
            string2 = string2.substring(FUNCTION.length() + 1).trim();
        }
        this.procName.add(string2);
        ++this.count;
    }

    public void mergeList(ProcedureList procedureList) {
        if (procedureList == null) {
            return;
        }
        for (String string : procedureList.procName) {
            int n = this.procName.indexOf(string);
            if (n != -1) continue;
            int n2 = procedureList.getBlock(string);
            this.blocks.add(n2);
            this.procName.add(string);
        }
    }

    public void done() {
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public ArrayList<String> getAllProcs() {
        return this.procName;
    }

    public int getBlock(int n) {
        if (n < this.count) {
            return this.blocks.get(n);
        }
        return -1;
    }

    public int getBlock(String string) {
        int n = this.procName.indexOf(string);
        if (n > -1) {
            return this.blocks.get(n);
        }
        return -1;
    }

    public String getProcName(int n) {
        if (n < this.count) {
            return this.procName.get(n);
        }
        return null;
    }
}

