/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.DebugSocketControl;
import com.unisys.tde.debug.core.comm.FormatMan;
import java.util.ArrayList;

public class OneVarValue {
    String varName;
    String varValue;
    String lineDo;
    String parent;
    String rest1;
    String varType;
    String length;
    String modifierss;
    String storage;
    String varn2;
    String rest2;
    ArrayList<String> errorMsgs;
    DebugSocketControl dbs;
    private static final String oneVarFmt = "# VARIABLE VALUE  %s [%s]%b%s";
    private static final String oneVarFmtNoValue = "# VARIABLE VALUE  %s [%s]";
    private static final String oneVarExp = "# VARIABLE EXP%b%s %s";
    private static final String oneVarCStr = " VARIABLE CSTR %s";
    private static final String oneVarBig = "# Variable %s [%s] %s, %s, %s.%bVARIABLE VALUE%b%s [%s] %s";
    private static final String oneVarBig2 = "# Variable %s [%s] %s, %s.%bVARIABLE VALUE%b%s [%s] %s";
    private static final String oneVarBigoF = "# Variable %s of %s [%s] %s, %s, %s.%bVARIABLE VALUE%b%s [%s] %s";

    public OneVarValue(String string, DebugSocketControl debugSocketControl) {
        this.dbs = debugSocketControl;
        this.errorMsgs = new ArrayList();
        if (!this.dbs.getLastErrorMessage().equals("")) {
            this.errorMsgs.add(this.scrubError(this.dbs.getLastErrorMessage()));
            this.dbs.setLastErrorMessage("");
        }
        this.lineDo = string;
    }

    public void addErrorMessage(String string) {
        if (string != null && string.equals("")) {
            this.errorMsgs.add(this.scrubError(string));
        }
    }

    protected void addString(String string) {
        if (string.startsWith("*E")) {
            this.errorMsgs.add(string);
        } else {
            if (!this.dbs.getLastErrorMessage().equals("")) {
                this.errorMsgs.add(this.scrubError(this.dbs.getLastErrorMessage()));
                this.dbs.setLastErrorMessage("");
            }
            this.lineDo = String.valueOf(this.lineDo) + string.substring(2);
        }
    }

    protected void parseString() {
        try {
            if (this.lineDo.indexOf("CSTR") > 0) {
                Object[] objectArray = FormatMan.sscanf(oneVarCStr, this.lineDo);
                if (objectArray.length == 1) {
                    this.varName = "";
                    this.parent = "";
                    this.varType = "";
                    this.length = "";
                    this.storage = "";
                    this.varValue = (String)objectArray[0];
                }
            } else if (this.lineDo.indexOf("EXP") > 0) {
                Object[] objectArray = FormatMan.sscanf(oneVarExp, this.lineDo);
                if (objectArray.length == 2) {
                    this.varName = (String)objectArray[0];
                    this.parent = "";
                    this.varType = "";
                    this.length = "";
                    this.storage = "";
                    this.varValue = (String)objectArray[1];
                }
            } else if (this.lineDo.startsWith("# VARIABLE VALUE ")) {
                if (this.lineDo.trim().endsWith("]")) {
                    Object[] objectArray = FormatMan.sscanf(oneVarFmtNoValue, this.lineDo);
                    if (objectArray.length == 9) {
                        this.varName = (String)objectArray[0];
                        this.parent = (String)objectArray[1];
                        this.varValue = "--no-value--";
                    }
                } else {
                    Object[] objectArray = FormatMan.sscanf(oneVarFmt, this.lineDo);
                    if (objectArray.length == 9) {
                        this.varName = (String)objectArray[0];
                        this.parent = (String)objectArray[1];
                        this.varValue = (String)objectArray[2];
                    }
                }
            } else if (this.lineDo.indexOf(" of ") > 0) {
                Object[] objectArray = FormatMan.sscanf(oneVarBigoF, this.lineDo);
                if (objectArray.length == 9) {
                    this.varName = (String)objectArray[0];
                    this.parent = (String)objectArray[1];
                    this.varType = (String)objectArray[3];
                    this.length = (String)objectArray[4];
                    this.storage = (String)objectArray[5];
                    this.varValue = (String)objectArray[8];
                }
            } else {
                Object[] objectArray = FormatMan.sscanf(oneVarBig, this.lineDo);
                if (objectArray.length == 8) {
                    this.varName = (String)objectArray[0];
                    this.parent = "";
                    this.varType = (String)objectArray[2];
                    this.length = (String)objectArray[3];
                    this.storage = (String)objectArray[4];
                    this.varValue = (String)objectArray[7];
                } else {
                    objectArray = FormatMan.sscanf(oneVarBig2, this.lineDo);
                    if (objectArray.length == 7) {
                        this.varName = (String)objectArray[0];
                        this.parent = "";
                        this.varType = (String)objectArray[2];
                        this.length = "uk";
                        this.storage = (String)objectArray[3];
                        this.varValue = (String)objectArray[6];
                    }
                }
            }
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.error((Object)"UNISYS Internal ERROR parsing input line", throwable);
            OS2200CorePlugin.logger.info((Object)("ERROR parsing input line.\n" + this.lineDo), throwable);
        }
    }

    String scrubError(String string) {
        int n;
        int n2 = string.indexOf(" line ");
        if (n2 > 0 && (n = string.indexOf(" ", n2 + 6)) > 0) {
            String string2 = string.substring(n + 1);
            return string2;
        }
        return string;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String string) {
        this.varName = string;
    }

    public String getVarValue() {
        return this.varValue;
    }

    public void setVarValue(String string) {
        this.varValue = string;
    }

    public String getParent() {
        return this.parent;
    }

    public String getVarType() {
        return this.varType;
    }

    public String getLength() {
        return this.length;
    }

    public ArrayList<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public String[] getErrorMsgArray() {
        int n = this.errorMsgs.size();
        String[] stringArray = new String[n];
        stringArray = this.errorMsgs.toArray(stringArray);
        return stringArray;
    }

    public String getStorage() {
        return this.storage;
    }
}

