/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.debug.core.comm.DebugCallback;
import com.unisys.tde.debug.core.comm.DebugListener;
import com.unisys.tde.debug.core.comm.DebugSocketControl;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class OS2200DebugConnect {
    public static final String NoPadsProcError = "Procedure PADSLBPRCLVL not found";
    Socket talkSocket;
    DebugSocketControl dbSock;
    DebugListener dbListen;
    DebugCallback dbCallClass;
    IProject targProject;
    Properties projProperties = null;
    String padsLibLevel;
    Hashtable<String, DebugSocketControl> socketControls = new Hashtable();

    public OS2200DebugConnect(IProject iProject) {
        this.targProject = iProject;
        this.projProperties = this.getProjProperties();
        this.padsLibLevel = "";
    }

    public void startDebug(int n, String string, DebugListener debugListener) {
        this.padsLibLevel = null;
        this.socketControls = null;
        this.socketControls = new Hashtable();
        this.dbListen = debugListener;
        this.dbSock = new DebugSocketControl(n, string, true, this);
        this.dbSock.addDebugListener(debugListener);
        this.dbSock.start();
    }

    public void writeStop() {
        if (this.dbSock != null) {
            this.dbSock.writeStop();
        }
    }

    public String getProjFileName() {
        if (this.getProjProperties() != null) {
            String string = (String)this.projProperties.get("workFile");
            return string;
        }
        return null;
    }

    public void setPadsLibLevel(String string) {
        this.padsLibLevel = string;
    }

    public String getPadsLibLevel() {
        return this.padsLibLevel;
    }

    public String getProjFilePath() {
        String string = OS2200FileInterface.getCIFSDir((Properties)this.getProjProperties());
        return string;
    }

    public Properties getProjProperties() {
        if (this.projProperties == null) {
            try {
                this.projProperties = OS2200ProjectUpdate.getProperties((IProject)this.targProject);
            }
            catch (CoreException coreException) {
                OS2200CorePlugin.logger.debug((Object)"Error getting project properites in Connector", (Throwable)coreException);
                this.projProperties = null;
            }
        }
        return this.projProperties;
    }

    public DebugListener getDebugListner() {
        return this.dbListen;
    }

    public InitState getInitState() {
        return this.dbSock.getInitState();
    }

    public IProject getProject() {
        return this.targProject;
    }

    public void addDebugListener(DebugListener debugListener) {
        this.dbSock.addDebugListener(debugListener);
    }

    public void setTaskState(String string, boolean bl) {
        DebugSocketControl debugSocketControl = this.socketControls.get(string);
        if (debugSocketControl != null) {
            debugSocketControl.setSuspendState(bl);
        } else {
            OS2200CorePlugin.logger.debug((Object)"null socket control returned");
        }
    }

    public void addDebugSocketControl(String string, DebugSocketControl debugSocketControl) {
        this.socketControls.put(string, debugSocketControl);
    }

    public Hashtable<String, DebugSocketControl> getSocketControls() {
        return this.socketControls;
    }

    public void terminateIt() {
        try {
            if (this.dbSock != null) {
                this.dbSock.interrupt();
                this.dbSock.join();
            }
        }
        catch (InterruptedException interruptedException) {
            OS2200CorePlugin.logger.info((Object)"Error terminating Program", (Throwable)interruptedException);
        }
    }

    public WriterTo2200 get2200Writer() {
        if (this.dbSock.getTaskOneWriter() == null) {
            OS2200CorePlugin.logger.debug((Object)"Using task 0 writer");
            return this.dbSock.getWriter();
        }
        OS2200CorePlugin.logger.debug((Object)"using task one writer");
        return this.dbSock.getTaskOneWriter();
    }

    public void removeFromChain(DebugSocketControl debugSocketControl) {
        if (this.dbSock != debugSocketControl) {
            DebugSocketControl debugSocketControl2;
            DebugSocketControl debugSocketControl3 = debugSocketControl2 = this.dbSock;
            while (debugSocketControl2 != null && debugSocketControl2 != debugSocketControl) {
                debugSocketControl3 = debugSocketControl2;
                debugSocketControl2 = debugSocketControl2.getNextSockControl();
            }
            if (debugSocketControl2 != null) {
                DebugSocketControl debugSocketControl4 = debugSocketControl2.getNextSockControl();
                debugSocketControl3.setNextSockControl(debugSocketControl4);
                debugSocketControl2.setNextSockControl(null);
                debugSocketControl2.interrupt();
                String string = debugSocketControl2.getTaskId();
                this.socketControls.remove(string);
                OS2200CorePlugin.logger.debug((Object)("Task " + string + "Socket control removed."));
            }
        }
    }

    public WriterTo2200 get2200Writer(String string) {
        DebugSocketControl debugSocketControl;
        if (this.socketControls.size() > 0 && (debugSocketControl = this.socketControls.get(string)) != null) {
            return debugSocketControl.getWriter();
        }
        return this.dbSock.writer;
    }

    public void setLastErrorMessage(String string) {
        this.dbSock.setLastErrorMessage(string);
    }

    static void NOLogit(String string, Throwable throwable) {
        if (throwable != null) {
            OS2200CorePlugin.logger.error((Object)string, throwable);
            OS2200CorePlugin.logger.info((Object)string, throwable);
        } else {
            OS2200CorePlugin.logger.info((Object)string);
        }
    }

    static void Logit(String string) {
        OS2200CorePlugin.logger.info((Object)string);
    }

    public static enum InitState {
        preConnect(1),
        Connect(2),
        Validated(3),
        Rejected(4);

        private final int value;

        private InitState(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }
}

