/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.debug.core.comm.FormatMan;
import java.util.ArrayList;

public class MemoryDumpModule {
    private ArrayList<Long> wordLong = new ArrayList();
    private ArrayList<String> wordString = new ArrayList();
    private static final String lineForm = "# %s %s %s %s %s %s %s %s %s %s %s %s %s %s";

    public void parseALine(String string) {
        if (string.trim().length() > 2) {
            Object[] objectArray = FormatMan.sscanf(lineForm, string);
            int n = 1;
            while (n < objectArray.length) {
                String string2 = (String)objectArray[n];
                if (!string2.equals("")) {
                    try {
                        Long l = Long.parseLong(string2, 16);
                        this.wordString.add(string2);
                        Long.toHexString(l);
                        this.wordLong.add(l);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++n;
            }
        }
    }

    byte[] wordToBytes(String string) {
        byte[] byArray = new byte[9];
        int n = 0;
        while (n < 9) {
            byArray[n] = Byte.parseByte(string.substring(n, n + 1), 16);
            ++n;
        }
        return byArray;
    }

    byte[] wordToBytes(Long l) {
        Long l2 = l;
        byte[] byArray = new byte[9];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = l2.byteValue();
            l2 = Long.rotateRight(l2, 8);
            ++n;
        }
        return byArray;
    }

    public ArrayList<Long> getListofLongs() {
        return this.wordLong;
    }

    public int getLength() {
        return this.wordString.size() * 9;
    }

    public byte[] getThemInBytes() {
        byte[] byArray = new byte[this.wordString.size() * 9];
        int n = 0;
        for (String string : this.wordString) {
            int n2 = 0;
            while (n2 < 9) {
                byArray[n++] = Byte.parseByte(string.substring(n2, n2 + 1), 16);
                ++n2;
            }
        }
        return byArray;
    }
}

