/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.Entry;
import com.unisys.tde.debug.core.comm.ErrorCondtionPoint;
import com.unisys.tde.debug.core.comm.ErrorMessage;
import com.unisys.tde.debug.core.comm.MessageType;
import com.unisys.tde.debug.core.comm.ProgramContext;
import com.unisys.tde.debug.core.comm.ProgramInfo;
import com.unisys.tde.debug.core.comm.StartLineInfo;
import com.unisys.tde.debug.core.comm.StatementStructure;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.TrapChangePoint;
import com.unisys.tde.debug.core.comm.TrapCondition;
import com.unisys.tde.debug.core.comm.TrapPoint;

public class InMessage {
    public static final String ECPADS_FILE_BLOCK = "##ECPADS FILE BLOCK";
    static final StatementStructure[] statement_array = new StatementStructure[]{new StatementStructure("# Statement ", 12, MessageType.tpSTATEMENT, 1, "]"), new StatementStructure("# Step ", 7, MessageType.tpSTEP, 1, "]"), new StatementStructure("# TRAP EXECUTION", 16, MessageType.tpTRAP_EXECUTION, 1, "]"), new StatementStructure("# SETTRAP", 8, MessageType.tpTRAP_SET, 0, ""), new StatementStructure("# PADS ", 7, MessageType.tpPADS_ACTIVE, 0, " "), new StatementStructure("# PADSLIB_LEVEL ", 16, MessageType.tpPADSLIB_LEVEL, 0, " "), new StatementStructure("# PADSLIBPROCLEVEL: ", 20, MessageType.tpPADSLIBPROC_LEVEL, 0, " "), new StatementStructure("# TRAP CONDITION", 16, MessageType.tpTRAP_CONDITION, 1, "]"), new StatementStructure("# TRAP CHANGE", 13, MessageType.tpTRAP_CHANGE, 1, "]."), new StatementStructure("# Exit in", 9, MessageType.tpPROGRAM_EXIT, 1, "]"), new StatementStructure("# TASK Initialization at ", 25, MessageType.tpTaskInit, 0, " "), new StatementStructure("#    PADS Task ID:", 25, MessageType.tpTaskPadsID, 0, " "), new StatementStructure("#    Linking System ID:", 30, MessageType.tpTaskLSID, 0, " "), new StatementStructure("#    System-Unique ID:", 29, MessageType.tpTaskSysID, 0, " "), new StatementStructure("# TASKLIST STARTING", 25, MessageType.tpTaskListStart, 0, " "), new StatementStructure("# TASKLIST ENDING", 23, MessageType.tpTaskListEnd, 0, " "), new StatementStructure("#    Status:", 12, MessageType.tpTaskStatus, 0, " "), new StatementStructure("# *E", 4, MessageType.tpERROR_MSG, 0, " "), new StatementStructure("# TASK_ID", 9, MessageType.tpTaskId, 0, " "), new StatementStructure("# Called from", 13, MessageType.tpWALKBACK, 1, "]"), new StatementStructure("# Walkback is complete.", 23, MessageType.tpWALKBACK_COMPLETE, 0, " "), new StatementStructure("# Entry ", 8, MessageType.tpMULTIPLE_ENTRY, 0, " "), new StatementStructure("# STARTLINE:", 12, MessageType.tpSTART_LINE, 1, "\\"), new StatementStructure("# Variable ", 11, MessageType.tpVARIABLE_VALUE, 1, "|"), new StatementStructure("# VARIABLE ", 11, MessageType.tpVARIABLE_VALUE, 1, "|"), new StatementStructure("# END VARIABLE VALUE", 21, MessageType.tpEnd_Variable_Value, 0, ""), new StatementStructure("# PROF ENV", 10, MessageType.tpProfEnv, 0, ""), new StatementStructure("# START LISTSRC", 15, MessageType.tpLISTSRC, 0, " "), new StatementStructure("# *W", 4, MessageType.tpWARNING_MSG, 0, " "), new StatementStructure("# START VAR DISPLAY", 19, MessageType.tpALL_VARS, 1, "||"), new StatementStructure("# END VAR DISPLAY", 17, MessageType.tpAllVarsEnd, 0, ""), new StatementStructure("# |||GLOBAL|||", 14, MessageType.tpVarGlobal, 0, ""), new StatementStructure("# |||LOCAL|||", 13, MessageType.tpVarLocal, 0, ""), new StatementStructure("# VARIABLE VALUES START", 23, MessageType.tpStartValues, 0, ""), new StatementStructure("# GETALLPROCS END", 17, MessageType.tpAllProcsEnd, 0, ""), new StatementStructure("# GETALLPROCS", 13, MessageType.tpALL_PROCS, 0, " "), new StatementStructure("#     CLARIFICATION", 19, MessageType.tpCONTEXT, 1, "]"), new StatementStructure("# Next executable", 17, MessageType.tpSTEP2, 1, "]"), new StatementStructure("# GETADDR", 9, MessageType.tpVARADDRESS, 0, " "), new StatementStructure("# START DMPADDR", 15, MessageType.tpMEMDUMP, 0, " "), new StatementStructure("# GO PERFORMED", 14, MessageType.tpGoDone, 0, " "), new StatementStructure("# END DMPADDR", 12, MessageType.tpENDMEMDUMP, 0, " "), new StatementStructure("# PCWATCH", 9, MessageType.tpPCWATCH_ECHO, 0, " "), new StatementStructure("# SETTRAP", 9, MessageType.tpSETTRAP_ECHO, 0, " "), new StatementStructure("# STEP END", 10, MessageType.tpStep_Set, 0, " "), new StatementStructure("# BANKLST", 9, MessageType.tpBANKLIST, 0, " "), new StatementStructure("# FILE BLOCK START", 18, MessageType.tpFileBlockStart, 0, " "), new StatementStructure("# FILE BLOCK END", 18, MessageType.tpFileBlockEnd, 0, " "), new StatementStructure("# Contingency", 13, MessageType.tpCONTINGENCY, 2, "."), new StatementStructure("# Error CONDITION", 17, MessageType.tpERROR_CONDITION, 1, "]"), new StatementStructure("# STMTRNG", 9, MessageType.tpSTATEMENT_RANGE, 0, " "), new StatementStructure("# START INHERITS", 16, MessageType.tpHIERARCHY, 0, " "), new StatementStructure("# User task terminated.", 23, MessageType.tpTASKTERMINATE, 0, " "), new StatementStructure("# User program and PADS terminated.", 35, MessageType.tpSimpleExit, 0, " "), new StatementStructure("# HNTOCLS", 9, MessageType.tpHANDLE_CLASS, 1, "||"), new StatementStructure("# SYNC ", 7, MessageType.tpSYNC, 1, "||"), new StatementStructure("# ERR in", 8, MessageType.tpERROR_NO_CONDITION, 1, "]"), new StatementStructure("# IDSTRING ", 11, MessageType.tpIDSTRING, 0, " "), new StatementStructure("# Initial invocation at ", 24, MessageType.tpINITIAL, 1, "]"), new StatementStructure("# CMD", 5, MessageType.tpCommand, 1, ""), new StatementStructure("# PROCEDURE TABLE DISPLAY", 25, MessageType.tpProcedureList, 0, "]"), new StatementStructure("# Register ", 11, MessageType.tpRegister, 0, ""), new StatementStructure("Call Timeout", 12, MessageType.tpCallTimerTimeout, 0, ""), new StatementStructure("# Start Registers X", 19, MessageType.tpXRegStart, 0, ""), new StatementStructure("# Start Registers R", 19, MessageType.tpRRegStart, 0, ""), new StatementStructure("# Start Registers A", 19, MessageType.tpARegStart, 0, ""), new StatementStructure("# End Registers", 17, MessageType.tpEndRegister, 0, ""), new StatementStructure("# [", 3, MessageType.tpBracket, 0, ""), new StatementStructure("# |", 3, MessageType.tpBar, 0, ""), new StatementStructure("# ,", 3, MessageType.tpComma, 0, ""), new StatementStructure("# DumpOMSDD-Start", 17, MessageType.tpSDDBankListStart, 0, ""), new StatementStructure("# DumpOMSDD-End", 15, MessageType.tpSDDBankListEnd, 0, ""), new StatementStructure("# The source of element ", 24, MessageType.tpSourceMap, 0, ""), new StatementStructure("# ", 2, MessageType.tpUKPound, 0, "")};
    static final int Num_Statements = statement_array.length;
    static final String justEndBars = "# ||";
    public static int[] variableSet;
    static MessageType[] allVarMsgTypes;
    String MsgIn;
    char[] msgBytes;
    boolean rawbytes;
    MessageType type;
    Object oby;
    int statementIndex;
    boolean completed = true;
    private int rawCount;

    static {
        allVarMsgTypes = new MessageType[]{MessageType.tpVarGlobal, MessageType.tpVarLocal, MessageType.tpComma, MessageType.tpAllVarsEnd, MessageType.tpStartValues, MessageType.tpBar, MessageType.tpProfEnv};
        variableSet = new int[allVarMsgTypes.length];
        int n = 0;
        int n2 = 0;
        while (n2 < allVarMsgTypes.length) {
            int n3 = 0;
            while (n3 < Num_Statements) {
                if (InMessage.statement_array[n3].index == allVarMsgTypes[n2]) {
                    InMessage.variableSet[n++] = n3;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public InMessage(String string) {
        this.MsgIn = string;
        this.type = null;
        this.oby = null;
        this.rawbytes = false;
    }

    public InMessage(char[] cArray, int n) {
        this.msgBytes = cArray;
        this.rawCount = n;
        this.type = null;
        this.oby = null;
        this.rawbytes = true;
    }

    public String getMessage() {
        return this.MsgIn;
    }

    public MessageType getType() {
        return this.type;
    }

    public Object getObject() {
        return this.oby;
    }

    public void setFake(MessageType messageType) {
        this.type = messageType;
        this.oby = this.MsgIn;
    }

    public boolean parseType() {
        if (this.rawbytes && this.msgBytes.length > ECPADS_FILE_BLOCK.length()) {
            String string;
            if (this.rawCount > 15000) {
                OS2200CorePlugin.logger.debug((Object)("probably file block, length: " + this.msgBytes.length));
            }
            if ((string = new String(this.msgBytes, 0, ECPADS_FILE_BLOCK.length())).equals(ECPADS_FILE_BLOCK)) {
                this.type = MessageType.tpFileBlock;
                this.MsgIn = ECPADS_FILE_BLOCK;
                OS2200CorePlugin.logger.debug((Object)"File Block");
                this.oby = new String(this.msgBytes, 30, this.rawCount);
                return true;
            }
            this.MsgIn = new String(this.msgBytes, 0, this.rawCount);
        }
        if (this.type != null) {
            return true;
        }
        if (this.MsgIn.charAt(0) != '>' && this.MsgIn.charAt(0) != '#') {
            this.type = MessageType.tpPPROGRAM_OUTPUT;
            return true;
        }
        int n = 0;
        while (n < Num_Statements) {
            if (this.MsgIn.startsWith(InMessage.statement_array[n].name)) {
                this.type = InMessage.statement_array[n].index;
                this.statementIndex = n;
                return true;
            }
            ++n;
        }
        this.type = MessageType.tpBadType;
        return false;
    }

    public boolean complete() {
        return this.completed;
    }

    public void mergeMsg(String string) {
        this.MsgIn = string.startsWith("# ") ? String.valueOf(this.MsgIn) + string.substring(2).trim() : String.valueOf(this.MsgIn) + string;
    }

    public void parse() {
        block38: {
            block37: {
                OS2200CorePlugin.logger.debug((Object)("In message is: " + this.MsgIn), null);
                if (this.type == null) {
                    this.parseType();
                }
                if (this.type == null) break block37;
                switch (this.type) {
                    case tpPPROGRAM_OUTPUT: {
                        break;
                    }
                    case tpPADS_ACTIVE: 
                    case tpIDSTRING: {
                        int n = InMessage.statement_array[this.statementIndex].name_length;
                        String string = this.MsgIn.substring(n).trim();
                        this.oby = string;
                        break;
                    }
                    case tpINITIAL: {
                        ProgramInfo programInfo = new ProgramInfo(this.MsgIn, 0);
                        if (programInfo.complete()) {
                            this.oby = programInfo;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpTaskId: {
                        int n = InMessage.statement_array[this.statementIndex].name_length;
                        String string = this.MsgIn.substring(n);
                        int n2 = string.indexOf("\n");
                        if (n2 > 0) {
                            string = string.substring(0, n2);
                        }
                        string = string.trim();
                        this.oby = string;
                        break;
                    }
                    case tpFileBlock: {
                        break;
                    }
                    case tpFileBlockStart: 
                    case tpFileBlockEnd: {
                        break;
                    }
                    case tpCONTEXT: {
                        ProgramContext programContext = new ProgramContext(this.MsgIn);
                        this.oby = programContext;
                        break;
                    }
                    case tpPROGRAM_EXIT: {
                        ProgramInfo programInfo = new ProgramInfo(this.MsgIn, 1);
                        this.oby = programInfo;
                        break;
                    }
                    case tpSTART_LINE: {
                        StartLineInfo startLineInfo = new StartLineInfo(this.MsgIn);
                        this.oby = startLineInfo;
                        break;
                    }
                    case tpVARIABLE_VALUE: 
                    case tpALL_PROCS: 
                    case tpProcedureList: 
                    case tpBracket: 
                    case tpAllProcsEnd: 
                    case tpTASKTERMINATE: 
                    case tpSimpleExit: {
                        break;
                    }
                    case tpERROR_CONDITION: {
                        ErrorCondtionPoint errorCondtionPoint = new ErrorCondtionPoint(this.MsgIn);
                        if (errorCondtionPoint.complete()) {
                            this.oby = errorCondtionPoint;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpTRAP_CONDITION: {
                        TrapCondition trapCondition = new TrapCondition(this.MsgIn);
                        if (trapCondition.complete()) {
                            this.oby = trapCondition;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpTRAP_CHANGE: {
                        TrapChangePoint trapChangePoint = new TrapChangePoint(this.MsgIn);
                        if (trapChangePoint.complete()) {
                            this.oby = trapChangePoint;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpCallTimerTimeout: {
                        OS2200CorePlugin.logger.debug((Object)"call timer dequeued");
                        break;
                    }
                    case tpMULTIPLE_ENTRY: {
                        Entry entry = new Entry(this.MsgIn);
                        if (entry.completed()) {
                            this.oby = entry.getObject();
                            this.completed = true;
                            this.type = entry.getMessageType();
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpTRAP_EXECUTION: {
                        TrapPoint trapPoint = new TrapPoint(this.MsgIn);
                        if (trapPoint.complete()) {
                            this.oby = trapPoint;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpSTEP: {
                        StopPoint stopPoint = new StopPoint(this.MsgIn);
                        if (stopPoint.complete()) {
                            this.oby = stopPoint;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpERROR_MSG: {
                        ErrorMessage errorMessage = new ErrorMessage(this.MsgIn);
                        if (errorMessage.complete()) {
                            this.oby = errorMessage;
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpWALKBACK_COMPLETE: 
                    case tpALL_VARS: 
                    case tpMEMDUMP: 
                    case tpUKPound: 
                    case tpVarLocal: 
                    case tpVarGlobal: 
                    case tpAllVarsEnd: 
                    case tpComma: 
                    case tpTRAP_SET: 
                    case tpRegister: 
                    case tpXRegStart: 
                    case tpARegStart: 
                    case tpRRegStart: 
                    case tpEndRegister: 
                    case tpENDMEMDUMP: 
                    case tpTaskInit: 
                    case tpTaskPadsID: 
                    case tpTaskLSID: 
                    case tpTaskSysID: 
                    case tpTaskStatus: 
                    case tpTaskListStart: 
                    case tpTaskListEnd: 
                    case tpStep_Set: 
                    case tpGoDone: 
                    case tpPADSLIB_LEVEL: 
                    case tpPADSLIBPROC_LEVEL: {
                        break;
                    }
                    case tpBadType: {
                        OS2200CorePlugin.logger.debug((Object)("bad message is: " + this.MsgIn), null);
                        break;
                    }
                    case tpWALKBACK: {
                        if (this.MsgIn.indexOf("].") > -1) {
                            this.completed = true;
                            break;
                        }
                        this.completed = false;
                        break;
                    }
                    case tpBar: {
                        if (this.MsgIn.equals(justEndBars)) {
                            this.type = MessageType.tpVarEndBars;
                            break;
                        }
                        break block38;
                    }
                    case tpCommand: {
                        this.oby = "";
                    }
                }
                break block38;
            }
            OS2200CorePlugin.logger.debug((Object)("Strange message type is: " + this.MsgIn), null);
            this.type = MessageType.tpPassType;
        }
    }
}

