/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.MessageType;
import com.unisys.tde.debug.core.comm.ProgramPoint;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.TrapChangePoint;
import com.unisys.tde.debug.core.comm.TrapPoint;

public class Entry
extends ProgramPoint {
    String stopElement;
    String stopLineNumber;
    boolean completed = true;
    String lineForm = "# Step completed. Next executable statement at line %s in %s [%s].";
    static final String formPlain = "# Step completed. Next executable statement at%bline %s in %s [%s]";
    static final String formOffset = "# Step completed. Next executable statement at%bline %s offset %s in %s [%s]";
    static final String entryForm = "# Entry %s: %s";
    static final String trapCEntry = "TRAP CHANGE";
    static final String trapEEntry = "TRAP EXECUTION";
    static final String stepEntry = "STEP";
    Object objReturn;
    MessageType tp;

    public Entry() {
    }

    public Entry(String string) {
        this.ParseLine(string);
    }

    public void ParseLine(String string) {
        if (string.indexOf("]") > -1) {
            Object[] objectArray = FormatMan.sscanf(entryForm, string);
            if (objectArray.length == 2) {
                String string2 = (String)objectArray[1];
                string2 = string2.trim();
                String string3 = string2.toUpperCase();
                string2 = "# " + string2;
                if (string3.startsWith(trapCEntry)) {
                    this.objReturn = new TrapChangePoint(string2);
                    this.tp = MessageType.tpTRAP_CHANGE;
                } else if (string3.startsWith(trapEEntry)) {
                    this.objReturn = new TrapPoint(string2);
                    this.tp = MessageType.tpTRAP_EXECUTION;
                } else if (string3.startsWith(stepEntry)) {
                    this.objReturn = new StopPoint(string2);
                    this.tp = MessageType.tpSTEP;
                }
            }
        } else {
            this.completed = false;
        }
    }

    public Object getObject() {
        return this.objReturn;
    }

    public MessageType getMessageType() {
        return this.tp;
    }

    public boolean completed() {
        return this.completed;
    }
}

