/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.debug.core.comm.AllVariables;
import com.unisys.tde.debug.core.comm.DebugCallback;
import com.unisys.tde.debug.core.comm.DebugInputBuffer;
import com.unisys.tde.debug.core.comm.DebugListener;
import com.unisys.tde.debug.core.comm.DebugSocket;
import com.unisys.tde.debug.core.comm.ErrorCondtionPoint;
import com.unisys.tde.debug.core.comm.IAcceptListener;
import com.unisys.tde.debug.core.comm.IDebugListener;
import com.unisys.tde.debug.core.comm.InMessage;
import com.unisys.tde.debug.core.comm.MemoryDumpModule;
import com.unisys.tde.debug.core.comm.MessageType;
import com.unisys.tde.debug.core.comm.OS2200DebugConnect;
import com.unisys.tde.debug.core.comm.OS2200RegisterSets;
import com.unisys.tde.debug.core.comm.OneVarValue;
import com.unisys.tde.debug.core.comm.ProcedureList;
import com.unisys.tde.debug.core.comm.ProgramPoint;
import com.unisys.tde.debug.core.comm.SDDBankList;
import com.unisys.tde.debug.core.comm.StartLineInfo;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.SyncOutputQueues;
import com.unisys.tde.debug.core.comm.SyncSocketControl;
import com.unisys.tde.debug.core.comm.TaskInfo;
import com.unisys.tde.debug.core.comm.TrapChangePoint;
import com.unisys.tde.debug.core.comm.TrapCondition;
import com.unisys.tde.debug.core.comm.TrapPoint;
import com.unisys.tde.debug.core.comm.WalkbackPoint;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugSocketControl
extends Thread {
    private int listenPort;
    private String programID;
    DebugSocket msgSocket;
    private IAcceptListener acceptor;
    private boolean endThis = false;
    private ArrayList<IDebugListener> dbListeners;
    private OutputStream os;
    private ProcedureList pl;
    private AllVariables allVars;
    private boolean varsGoing = false;
    private boolean procListGoing = false;
    private boolean SDDbankListGoing = false;
    private boolean EltMapGoing = false;
    private boolean oneVarGoing = false;
    WriterTo2200 writer;
    private SDDBankList sddBanks;
    private WalkbackPoint wbPoint = null;
    private ProgramPoint sPoint = null;
    private StartLineInfo startPoint = null;
    private String omEltName = "";
    private TrapPoint trpPoint;
    private TrapChangePoint trpChgPt;
    private ErrorCondtionPoint ecdPt;
    private TrapCondition trpCnd;
    private boolean gettingWalkback = false;
    private OneVarValue oneVarV;
    private SyncSocketControl SyncSC;
    Hashtable<String, String> omTable;
    private ServerSocket listenSocket;
    private ServerSocket listenSocket2;
    private Socket writeSocket;
    private OutputStream taskOneStream;
    private WriterTo2200 taskOneWriter;
    private OS2200RegisterSets rSets;
    private MemoryDumpModule memDumpMod;
    private boolean doingMemDump = false;
    private boolean doingStep = false;
    private boolean gettingTasks = false;
    private ArrayList<TaskInfo> taskList = null;
    private TaskInfo currentTask;
    private String lastErrorMessage;
    private CallTimer CQN;
    private boolean connectFailed;
    private ConnectSocketTwo connSck2;
    private DebugListener myDl;
    private boolean taskSuspended;
    private boolean gettingPadsProcLevel;
    int fileBlockCount;
    OS2200DebugConnect.InitState initState;
    SynchWaiter synchWait;
    private Socket eventSocket;
    private String currentSDDBank;
    private boolean waitControl;
    private OS2200DebugConnect dbgConnect;
    private String owner_task_id;
    private DebugSocketControl nextSockControl;
    private DebugSocketControl mySocketControl;
    private String fileBlock = "";
    private boolean fileBlockGoing;
    private DebugInputBuffer bufferControl;
    private boolean interrupting;
    private SyncOutputQueues dscSynchs;

    public boolean isGettingPadsProcLevel() {
        return this.gettingPadsProcLevel;
    }

    public void setGettingPadsProcLevel(boolean bl) {
        this.gettingPadsProcLevel = bl;
    }

    DebugSocketControl(int n, String string, boolean bl, OS2200DebugConnect oS2200DebugConnect) {
        this.listenPort = n;
        this.programID = string;
        this.dbListeners = new ArrayList();
        this.initState = OS2200DebugConnect.InitState.preConnect;
        this.lastErrorMessage = "";
        this.synchWait = SynchWaiter.waitNone;
        this.waitControl = bl;
        this.dbgConnect = oS2200DebugConnect;
        this.nextSockControl = null;
        this.writeSocket = null;
        this.taskOneStream = null;
        this.mySocketControl = this;
        this.taskOneWriter = null;
        this.fileBlockGoing = true;
        this.fileBlock = "";
        this.varsGoing = false;
        this.taskSuspended = false;
        this.gettingPadsProcLevel = false;
        this.interrupting = false;
    }

    public void setSynchWait(SynchWaiter synchWaiter) {
        this.synchWait = synchWaiter;
    }

    public DebugSocketControl getNextSockControl() {
        return this.nextSockControl;
    }

    public void setNextSockControl(DebugSocketControl debugSocketControl) {
        this.nextSockControl = debugSocketControl;
    }

    public String getOwner_task_id() {
        return this.owner_task_id;
    }

    public void setSuspendState(boolean bl) {
        this.taskSuspended = bl;
    }

    void addAcceptListener(IAcceptListener iAcceptListener) {
        this.acceptor = iAcceptListener;
    }

    void sendErrorMsgWithTerm(String string) {
        this.sendErrorMsg(string);
        InMessage inMessage = new InMessage(string);
        inMessage.setFake(MessageType.tpPrestartAbort);
        this.callDebugListeners(new DebugCallback(MessageType.tpPrestartAbort, string));
    }

    void addDebugListener(DebugListener debugListener) {
        this.dbListeners.add(debugListener);
        this.myDl = debugListener;
    }

    public OutputStream getTaskOneStream() {
        return this.taskOneStream;
    }

    public boolean isPrimaryTaskHandler() {
        return this.waitControl;
    }

    public boolean procListGoing() {
        return this.procListGoing;
    }

    void sendErrorMsg(String string) {
        Display display = Display.getDefault();
        final String string2 = string;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"DebugSocketControl_0"), (String)string2);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.info((Object)"error posting debug message", (Throwable)exception);
                }
            }
        });
    }

    static void sendErrorMsgStatic(String string) {
        Display display = Display.getDefault();
        final String string2 = string;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"DebugSocketControl_1"), (String)string2);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.info((Object)"error posting debug message", (Throwable)exception);
                }
            }
        });
    }

    void callDebugListeners(DebugCallback debugCallback) {
        debugCallback.setCallerControl(this);
        final DebugCallback debugCallback2 = debugCallback;
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (DebugSocketControl.this.dbListeners.size() > 0) {
                    for (IDebugListener iDebugListener : DebugSocketControl.this.dbListeners) {
                        iDebugListener.debugCall(debugCallback2);
                    }
                }
            }
        };
        thread.start();
    }

    void removeDebugListener(DebugListener debugListener) {
        if (this.dbListeners.size() > 0) {
            this.dbListeners.remove(debugListener);
        }
    }

    protected void readSocketError(Exception exception) {
        OS2200CorePlugin.logger.info((Object)"Socket error sent", (Throwable)exception);
        this.sendErrorMsg(String.valueOf(Messages.getString((String)"DebugSocketControl_2")) + exception.getLocalizedMessage());
        InMessage inMessage = new InMessage(Messages.getString((String)"DebugSocketControl_3"));
        inMessage.setFake(MessageType.tpPrecipitousTerminate);
        this.callDebugListeners(new DebugCallback(inMessage.getType(), inMessage.getObject()));
    }

    protected void sendMonitorMessage(String string) {
        OS2200CorePlugin.logger.debug((Object)"monitor message");
        InMessage inMessage = new InMessage(string);
        inMessage.setFake(MessageType.tpMonitorMessage);
        this.callDebugListeners(new DebugCallback(inMessage.getType(), string));
    }

    protected OS2200DebugConnect getMainConnect() {
        return this.dbgConnect;
    }

    @Override
    public void run() {
        this.eventSocket = null;
        OS2200CorePlugin.logger.debug((Object)"listening for debug program");
        int n = this.listenPort + 1;
        try {
            this.sendMonitorMessage(Messages.getString((String)"DebugSocketControl_4"));
            this.listenSocket = new ServerSocket(this.listenPort);
            this.eventSocket = this.listenSocket.accept();
            OS2200CorePlugin.logger.debug((Object)("first socket connection response using port " + this.listenPort));
            this.sendMonitorMessage(Messages.getString((String)"DebugSocketControl_5"));
            this.initState = OS2200DebugConnect.InitState.Connect;
            OS2200CorePlugin.logger.debug((Object)"Connected to program");
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string.indexOf("JVM_Bind") >= 0) {
                this.sendErrorMsg(String.valueOf(Messages.getString((String)"DebugSocketControl_6")) + Integer.toString(this.listenPort) + Messages.getString((String)"DebugSocketControl_7"));
            }
            if (!this.interrupting) {
                if (!(iOException instanceof SocketException)) {
                    OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)iOException);
                }
                OS2200CorePlugin.logger.info((Object)"Error listening for debug program", (Throwable)iOException);
                this.callDebugListeners(new DebugCallback(MessageType.tpPrestartAbort, "e.getMessage"));
            } else {
                OS2200CorePlugin.logger.debug((Object)"Exception closing", (Throwable)iOException);
            }
            return;
        }
        this.bufferControl = new DebugInputBuffer();
        this.msgSocket = new DebugSocket(this.eventSocket, this.bufferControl, this);
        this.msgSocket.start();
        this.nextSockControl = new DebugSocketControl(n, this.programID, false, this.dbgConnect);
        this.nextSockControl.addDebugListener(this.dbgConnect.getDebugListner());
        this.nextSockControl.start();
        OS2200CorePlugin.logger.debug((Object)"Message reader started");
        try {
            this.os = this.eventSocket.getOutputStream();
            this.dscSynchs = new SyncOutputQueues();
            this.writer = new WriterTo2200(this.os, this.dscSynchs, this);
            String string = "\n";
            this.os.write(string.getBytes());
            OS2200CorePlugin.logger.debug((Object)"Return sent");
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)iOException);
            OS2200CorePlugin.logger.info((Object)"Error kicking off communication", (Throwable)iOException);
        }
        this.handleMessages();
    }

    private void handleMessages() {
        try {
            while (!this.endThis) {
                InMessage inMessage = this.bufferControl.getNextMessage();
                inMessage.parse();
                while (!inMessage.complete()) {
                    InMessage inMessage2 = this.bufferControl.getNextMessage();
                    if (inMessage2 == null) continue;
                    inMessage.mergeMsg(inMessage2.getMessage());
                    inMessage.parse();
                }
                if (inMessage == null) continue;
                this.branchMessageType(inMessage);
            }
        }
        catch (InterruptedException interruptedException) {
            this.endThis = true;
            OS2200CorePlugin.logger.debug((Object)"handle messages interrupted");
        }
    }

    public void writeStop() {
        if (this.msgSocket != null) {
            this.msgSocket.doingStop();
        }
        if (this.nextSockControl != null) {
            this.nextSockControl.writeStop();
        }
    }

    @Override
    public void interrupt() {
        OS2200CorePlugin.logger.debug((Object)("Interrupting " + this.owner_task_id));
        this.interrupting = true;
        try {
            if (this.initState != OS2200DebugConnect.InitState.preConnect) {
                this.endThis = true;
                if (this.msgSocket != null) {
                    this.msgSocket.interrupt();
                    this.msgSocket.join(10L);
                    this.msgSocket = null;
                }
                if (this.writer != null) {
                    this.writer = null;
                }
                OS2200CorePlugin.logger.debug((Object)"Listener Thread interrupted");
                try {
                    if (this.writeSocket != null) {
                        this.writeSocket.shutdownOutput();
                        this.os.close();
                        this.writeSocket.close();
                    }
                    this.os = null;
                    this.writeSocket = null;
                    OS2200CorePlugin.logger.debug((Object)"Writing shut down");
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.info((Object)"exception closing writer", (Throwable)iOException);
                }
                if (this.connSck2 != null) {
                    this.connSck2.interrupt();
                }
                if (this.listenSocket2 != null) {
                    this.listenSocket2.close();
                    this.listenSocket2 = null;
                }
                if (this.listenSocket != null) {
                    this.listenSocket.close();
                    this.listenSocket = null;
                }
            } else if (this.initState == OS2200DebugConnect.InitState.preConnect && this.listenSocket != null) {
                this.listenSocket.close();
                this.listenSocket = null;
                if (this.listenSocket2 != null && this.listenSocket2.isBound()) {
                    this.listenSocket2.close();
                }
                this.listenSocket2 = null;
            }
            if (this.nextSockControl != null) {
                this.nextSockControl.interrupt();
            }
            super.interrupt();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Unable to End Debug Session", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error ending debug session", (Throwable)exception);
        }
    }

    public void setDoingStep(boolean bl) {
        this.doingStep = bl;
    }

    public OS2200DebugConnect.InitState getInitState() {
        return this.initState;
    }

    protected void branchMessageType(InMessage inMessage) {
        MessageType messageType = inMessage.getType();
        switch (messageType) {
            case tpPPROGRAM_OUTPUT: {
                break;
            }
            case tpPADS_ACTIVE: {
                break;
            }
            case tpPROGRAM_EXIT: 
            case tpSimpleExit: {
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpSTART_LINE: {
                this.dscSynchs.addSLQueue((StartLineInfo)inMessage.getObject());
                break;
            }
            case tpINITIAL: {
                if (this.writer.walkingBack() || this.initState != OS2200DebugConnect.InitState.Validated) break;
                this.sPoint = (ProgramPoint)inMessage.getObject();
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpTaskId: {
                this.owner_task_id = (String)inMessage.getObject();
                String string = this.owner_task_id.substring(7);
                Integer n = Integer.parseInt(string);
                this.owner_task_id = n.toString();
                this.dbgConnect.addDebugSocketControl(this.owner_task_id, this);
                break;
            }
            case tpERROR_CONDITION: {
                if (this.writer.walkingBack()) break;
                if (this.doingStep) {
                    this.writer.syncNotify(this.lastErrorMessage);
                    this.doingStep = false;
                }
                this.ecdPt = (ErrorCondtionPoint)inMessage.getObject();
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpSTEP: {
                if (this.writer.walkingBack()) break;
                if (this.doingStep) {
                    this.writer.syncNotify(this.lastErrorMessage);
                    this.doingStep = false;
                }
                this.sPoint = (StopPoint)inMessage.getObject();
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpTRAP_CHANGE: {
                if (this.writer.walkingBack()) break;
                if (this.doingStep) {
                    this.writer.syncNotify(this.lastErrorMessage);
                    this.doingStep = false;
                }
                this.trpChgPt = (TrapChangePoint)inMessage.getObject();
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpTRAP_EXECUTION: {
                if (this.writer.walkingBack()) break;
                if (this.doingStep) {
                    this.writer.syncNotify(this.lastErrorMessage);
                    this.doingStep = false;
                } else if (this.CQN != null) {
                    this.CQN.interrupt();
                    this.CQN = null;
                }
                this.trpPoint = (TrapPoint)inMessage.getObject();
                if (this.lastErrorMessage != null && !this.lastErrorMessage.equals("")) {
                    ErrorCondtionPoint errorCondtionPoint = new ErrorCondtionPoint(this.trpPoint);
                    String string = errorCondtionPoint.getOmElt();
                    if (string != null && string.length() > 0) {
                        this.callDebugListeners(new DebugCallback(MessageType.tpERROR_CONDITION, errorCondtionPoint));
                        this.lastErrorMessage = "";
                        break;
                    }
                    this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                    break;
                }
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpTRAP_SET: {
                this.dscSynchs.addBPQueue(this.lastErrorMessage);
            }
            case tpStep_Set: {
                if (!this.doingStep) break;
                this.writer.syncNotify(this.lastErrorMessage);
                this.doingStep = false;
                break;
            }
            case tpTRAP_CONDITION: {
                OS2200CorePlugin.logger.debug((Object)("trap condition, task  " + this.owner_task_id));
                if (this.writer.walkingBack()) break;
                if (this.doingStep) {
                    this.writer.syncNotify(this.lastErrorMessage);
                    this.doingStep = false;
                }
                this.trpCnd = (TrapCondition)inMessage.getObject();
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpERROR_MSG: {
                this.lastErrorMessage = inMessage.getMessage();
                if (this.gettingPadsProcLevel) {
                    this.writer.syncNotify(this.lastErrorMessage);
                    this.gettingPadsProcLevel = false;
                    break;
                }
                this.checkForWaiters(this.lastErrorMessage);
                break;
            }
            case tpMEMDUMP: {
                this.doingMemDump = true;
                this.memDumpMod = new MemoryDumpModule();
                break;
            }
            case tpENDMEMDUMP: {
                this.doingMemDump = false;
                this.writer.syncNotify(this.memDumpMod);
                break;
            }
            case tpTASKTERMINATE: {
                this.callDebugListeners(new DebugCallback(messageType, inMessage.getObject()));
                break;
            }
            case tpXRegStart: {
                if (this.rSets == null) {
                    this.rSets = new OS2200RegisterSets();
                }
                this.rSets.setX();
                break;
            }
            case tpARegStart: {
                if (this.rSets == null) {
                    this.rSets = new OS2200RegisterSets();
                }
                this.rSets.setA();
                break;
            }
            case tpRRegStart: {
                if (this.rSets == null) {
                    this.rSets = new OS2200RegisterSets();
                }
                this.rSets.setR();
                break;
            }
            case tpRegister: {
                this.rSets.addReg(inMessage.getMessage());
                break;
            }
            case tpEndRegister: {
                this.dscSynchs.addRegQueue(this.rSets);
                this.rSets = null;
                break;
            }
            case tpIDSTRING: {
                this.sendMonitorMessage(Messages.getString((String)"DebugSocketControl_8"));
                String string = (String)inMessage.getObject();
                if (!this.programID.equals(string)) {
                    try {
                        this.initState = OS2200DebugConnect.InitState.Rejected;
                        DebugCallback debugCallback = new DebugCallback(MessageType.tpWrongID, string);
                        this.callDebugListeners(debugCallback);
                    }
                    catch (Exception exception) {
                        this.endThis = true;
                    }
                    break;
                }
                this.initState = OS2200DebugConnect.InitState.Validated;
                OS2200DebugConnect.Logit("ID okay");
                break;
            }
            case tpPADSLIB_LEVEL: {
                String string = inMessage.MsgIn;
                int n = InMessage.statement_array[inMessage.statementIndex].name_length;
                String string2 = string.substring(n).trim();
                this.dbgConnect.setPadsLibLevel(string2);
                OS2200CorePlugin.logger.debug((Object)"padslib level set");
                break;
            }
            case tpPADSLIBPROC_LEVEL: {
                String string = inMessage.getMessage();
                this.gettingPadsProcLevel = false;
                this.writer.syncNotify(string);
                break;
            }
            case tpCONTEXT: {
                this.writer.syncNotify(inMessage.getObject());
                break;
            }
            case tpCommand: {
                this.callDebugListeners(new DebugCallback(messageType, null));
                break;
            }
            case tpProcedureList: {
                this.pl = new ProcedureList();
                this.procListGoing = true;
                break;
            }
            case tpBracket: {
                if (!this.procListGoing) break;
                this.pl.addProc(inMessage.getMessage());
                break;
            }
            case tpAllProcsEnd: {
                this.pl.complete = true;
                this.procListGoing = false;
                this.dscSynchs.addPLQueue(this.pl);
                break;
            }
            case tpWALKBACK: {
                if (!this.gettingWalkback || this.wbPoint == null) {
                    this.wbPoint = new WalkbackPoint(inMessage.getMessage());
                } else {
                    WalkbackPoint walkbackPoint = new WalkbackPoint(inMessage.getMessage());
                    this.wbPoint.addNextWalkbackPoint(walkbackPoint);
                }
                this.gettingWalkback = true;
                break;
            }
            case tpWALKBACK_COMPLETE: {
                OS2200CorePlugin.logger.debug((Object)"returning walkback");
                this.gettingWalkback = false;
                if (this.wbPoint != null) {
                    this.dscSynchs.addWBQueue(this.wbPoint);
                    break;
                }
                this.wbPoint = new WalkbackPoint(inMessage.getMessage());
                this.dscSynchs.addWBQueue(this.wbPoint);
                break;
            }
            case tpFileBlockStart: {
                this.fileBlock = "";
                this.fileBlockGoing = true;
                this.fileBlockCount = 0;
                break;
            }
            case tpFileBlockEnd: {
                this.fileBlockGoing = false;
                break;
            }
            case tpFileBlock: {
                ++this.fileBlockCount;
                if (this.fileBlockCount > 32) {
                    OS2200CorePlugin.logger.debug((Object)"file blockcount nearing end");
                }
                this.fileBlock = String.valueOf(this.fileBlock) + (String)inMessage.getObject();
                break;
            }
            case tpALL_VARS: {
                this.allVars = new AllVariables();
                this.varsGoing = true;
                break;
            }
            case tpAllVarsEnd: {
                this.varsGoing = false;
                this.allVars.setArrray(this.fileBlock);
                this.dscSynchs.addAVQueue(this.allVars);
                break;
            }
            case tpComma: {
                if (!this.varsGoing || this.allVars.initIsComplete()) break;
                this.allVars.addLine(inMessage.getMessage());
                break;
            }
            case tpVarLocal: {
                if (!this.varsGoing) break;
                this.allVars.addLocalVariableSet();
                break;
            }
            case tpVarGlobal: {
                if (!this.varsGoing) break;
                this.allVars.addGlobalVariableSet();
                break;
            }
            case tpVarEndBars: {
                if (!this.varsGoing || !this.allVars.incompleteVariable()) break;
                this.allVars.addToVariable(inMessage.getMessage());
                break;
            }
            case tpVARIABLE_VALUE: {
                if (!this.oneVarGoing) {
                    this.oneVarGoing = true;
                    this.oneVarV = new OneVarValue(inMessage.getMessage(), this);
                    break;
                }
                this.oneVarV.addString(inMessage.getMessage());
                break;
            }
            case tpEnd_Variable_Value: {
                this.oneVarGoing = false;
                if (this.oneVarV == null) {
                    this.oneVarV = new OneVarValue(inMessage.getMessage(), this);
                }
                if (this.lastErrorMessage != null && !this.lastErrorMessage.equals("")) {
                    this.oneVarV.addErrorMessage(this.lastErrorMessage);
                    this.lastErrorMessage = "";
                }
                this.oneVarV.parseString();
                this.dscSynchs.addOVQueue(this.oneVarV);
                break;
            }
            case tpGoDone: {
                this.writer.syncNotify(inMessage.getMessage());
            }
            case tpTaskListStart: {
                this.gettingTasks = true;
                this.taskList = new ArrayList();
                this.currentTask = null;
                break;
            }
            case tpTaskListEnd: {
                this.gettingTasks = false;
                if (this.currentTask != null) {
                    this.taskList.add(this.currentTask);
                }
                this.writer.syncNotify(this.taskList);
                this.currentTask = null;
                break;
            }
            case tpTaskPadsID: {
                if (this.currentTask != null) {
                    this.taskList.add(this.currentTask);
                }
                this.currentTask = new TaskInfo();
                this.currentTask.parsePadsLine(inMessage.getMessage());
                break;
            }
            case tpTaskLSID: {
                this.currentTask.parseLSIDLine(inMessage.getMessage());
                break;
            }
            case tpTaskSysID: {
                this.currentTask.parseSysUniqueID(inMessage.getMessage());
                break;
            }
            case tpTaskStatus: {
                this.currentTask.parseTaskState(inMessage.getMessage());
                break;
            }
            case tpTaskInit: {
                this.callDebugListeners(new DebugCallback(messageType, null));
                break;
            }
            case tpSDDBankListStart: {
                this.SDDbankListGoing = true;
                this.sddBanks = new SDDBankList();
                break;
            }
            case tpSDDBankListEnd: {
                this.SDDbankListGoing = false;
                this.EltMapGoing = true;
                this.omTable = new Hashtable();
                String string = this.sddBanks.getFirst();
                if (this.sPoint != null) {
                    this.omEltName = this.sPoint.omElt;
                } else if (this.startPoint != null) {
                    this.omEltName = this.startPoint.startElement;
                }
                if (string != null && !this.omEltName.equals("")) {
                    try {
                        this.writer.getSourceName(this.sPoint.omElt, string);
                        this.currentSDDBank = string;
                        this.CQN = new CallTimer(TimerCall.sourceName);
                        this.CQN.start();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on getting task List", (Throwable)iOException);
                        this.sendErrorMsg(String.valueOf(Messages.getString((String)"DebugSocketControl_9")) + iOException.getLocalizedMessage());
                        InMessage inMessage2 = new InMessage(Messages.getString((String)"DebugSocketControl_10"));
                        inMessage2.setFake(MessageType.tpPrecipitousTerminate);
                        this.callDebugListeners(new DebugCallback(inMessage2.getType(), inMessage2.getObject()));
                    }
                    break;
                }
                this.EltMapGoing = false;
                break;
            }
            case tpCallTimerTimeout: {
                TimerCall timerCall = null;
                this.CQN.interrupt();
                try {
                    timerCall = (TimerCall)((Object)inMessage.getObject());
                    this.CQN.join();
                    this.CQN = new CallTimer(timerCall);
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.debug((Object)"interruped while joining", (Throwable)interruptedException);
                }
                try {
                    switch (timerCall) {
                        case sourceName: {
                            if (this.currentSDDBank == null) break;
                            OS2200CorePlugin.logger.debug((Object)("second call for " + this.currentSDDBank));
                            this.writer.getSourceName(this.omEltName, this.currentSDDBank);
                            this.CQN.start();
                            break;
                        }
                        case firstGo: {
                            OS2200CorePlugin.logger.debug((Object)"second call for first go");
                            this.writer.run();
                        }
                    }
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.info((Object)"IOError on getting task List", (Throwable)iOException);
                    this.sendErrorMsg(String.valueOf(Messages.getString((String)"DebugSocketControl_11")) + iOException.getLocalizedMessage());
                    InMessage inMessage3 = new InMessage(Messages.getString((String)"DebugSocketControl_12"));
                    inMessage3.setFake(MessageType.tpPrecipitousTerminate);
                    this.callDebugListeners(new DebugCallback(inMessage3.getType(), inMessage3.getObject()));
                }
                break;
            }
            case tpSourceMap: {
                if (this.CQN != null) {
                    this.CQN.interrupt();
                    try {
                        this.CQN.join();
                        this.CQN = null;
                    }
                    catch (InterruptedException interruptedException) {
                        OS2200CorePlugin.logger.debug((Object)"interruped while joining", (Throwable)interruptedException);
                    }
                }
                SDDBankList.addEltToOMMap(inMessage.getMessage(), this.omTable);
                String string = this.sddBanks.getNext();
                if (string != null) {
                    try {
                        this.writer.getSourceName(this.omEltName, string);
                        this.currentSDDBank = string;
                        this.CQN = new CallTimer(TimerCall.sourceName);
                        this.CQN.start();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on getting task List", (Throwable)iOException);
                        this.sendErrorMsg(String.valueOf(Messages.getString((String)"DebugSocketControl_13")) + iOException.getLocalizedMessage());
                        InMessage inMessage4 = new InMessage(Messages.getString((String)"DebugSocketControl_14"));
                        inMessage4.setFake(MessageType.tpPrecipitousTerminate);
                        this.callDebugListeners(new DebugCallback(inMessage4.getType(), inMessage4.getObject()));
                    }
                    break;
                }
                this.EltMapGoing = false;
                this.writer.syncNotify(this.omTable);
                break;
            }
            case tpEltMapEnd: {
                break;
            }
            case tpBar: {
                if (!this.varsGoing) break;
                this.allVars.addVariable(inMessage.getMessage());
                break;
            }
            case tpUKPound: {
                if (this.varsGoing) {
                    if (!this.allVars.initIsComplete()) {
                        this.allVars.addLine(inMessage.getMessage());
                        break;
                    }
                    if (this.allVars.incompleteVariable()) {
                        this.allVars.addToVariable(inMessage.getMessage());
                        break;
                    }
                    this.allVars.addVariable(inMessage.getMessage());
                }
                if (this.oneVarGoing) {
                    this.oneVarV.addString(inMessage.getMessage());
                }
                if (this.SDDbankListGoing) {
                    this.sddBanks.addSDDBank(inMessage.getMessage());
                }
                if (!this.doingMemDump) break;
                this.memDumpMod.parseALine(inMessage.getMessage());
                break;
            }
        }
    }

    public WriterTo2200 getWriter() {
        return this.writer;
    }

    public WriterTo2200 getTaskOneWriter() {
        return this.taskOneWriter;
    }

    public void stopThis() {
        this.endThis = true;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void setLastErrorMessage(String string) {
        this.lastErrorMessage = string;
    }

    void checkForWaiters(String string) {
        String string2 = string.toLowerCase();
        if ((string2.indexOf("procedure disp1var3 not found") > 0 || string2.indexOf("procedure disp1var2 not found") > 0) && this.dscSynchs.ovWaits()) {
            this.oneVarGoing = false;
            if (this.oneVarV == null) {
                this.oneVarV = new OneVarValue("# VARIABLE VALUE  bad [bad]", this);
            }
            this.oneVarV.addErrorMessage(this.lastErrorMessage);
            this.lastErrorMessage = "";
            this.oneVarV.parseString();
            this.dscSynchs.addOVQueue(this.oneVarV);
        }
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public String getTaskId() {
        return this.owner_task_id;
    }

    class CallTimer
    extends Thread {
        private static final String CALL_TIMEOUT = "Call Timeout";
        TimerCall tCall;

        public CallTimer(TimerCall timerCall) {
            this.tCall = timerCall;
        }

        @Override
        public void run() {
            int n = 20000;
            OS2200CorePlugin.logger.debug((Object)"start call timer");
            while (!DebugSocketControl.this.endThis) {
                try {
                    Thread.sleep(n);
                    InMessage inMessage = new InMessage(CALL_TIMEOUT);
                    inMessage.setFake(MessageType.tpCallTimerTimeout);
                    inMessage.oby = this.tCall;
                    OS2200CorePlugin.logger.debug((Object)"call timer enqueued");
                    DebugSocketControl.this.bufferControl.addQueue(CALL_TIMEOUT.toCharArray(), CALL_TIMEOUT.length());
                    OS2200CorePlugin.logger.debug((Object)"timeout message queued");
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.debug((Object)"ending the timer");
                    return;
                }
            }
        }
    }

    class ConnectSocketTwo
    extends Thread {
        ConnectSocketTwo() {
        }

        @Override
        public void run() {
            try {
                DebugSocketControl.this.listenSocket2 = new ServerSocket(DebugSocketControl.this.listenPort + 1);
                DebugSocketControl.this.writeSocket = DebugSocketControl.this.listenSocket2.accept();
                DebugSocketControl.this.taskOneStream = DebugSocketControl.this.writeSocket.getOutputStream();
                DebugSocketControl.this.taskOneWriter = new WriterTo2200(DebugSocketControl.this.taskOneStream, DebugSocketControl.this.dscSynchs, DebugSocketControl.this.mySocketControl);
                OS2200CorePlugin.logger.debug((Object)"second socket connection response");
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)"IO Error connecting to socket 2", (Throwable)iOException);
            }
        }
    }

    static enum SynchWaiter {
        waitNone(0),
        waitRun(1),
        waitFirstLine(2),
        waitProcs(3),
        waitSetTrap(4);

        private final int value;

        private SynchWaiter(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }

    static enum TimerCall {
        sourceName(1),
        firstGo(2);

        private final int value;

        private TimerCall(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }
}

