/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.DebugInputBuffer;
import com.unisys.tde.debug.core.comm.DebugSocketControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.ui.services.IDisposable;

public class DebugSocket
extends Thread
implements IDisposable {
    private DebugInputBuffer dbBuffer;
    ServerSocket listenSocket;
    Socket eventSocket;
    boolean loopOK;
    boolean writingStop;
    DebugSocketControl socketControl;
    private int portOn;
    private String tskID;
    private boolean shutDown;
    private char[] inputBytes;
    private InputStream byteStream;
    private InputStreamReader charStream;

    public DebugSocket(Socket socket, DebugInputBuffer debugInputBuffer, DebugSocketControl debugSocketControl) {
        this.eventSocket = socket;
        this.dbBuffer = debugInputBuffer;
        this.socketControl = debugSocketControl;
        this.portOn = this.socketControl.getListenPort();
        this.tskID = this.socketControl.getTaskId();
        this.loopOK = true;
        this.shutDown = true;
        this.inputBytes = new char[120000];
        try {
            this.byteStream = this.eventSocket.getInputStream();
            this.charStream = new InputStreamReader(this.byteStream);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)"error creating socket ", (Throwable)exception);
        }
    }

    @Override
    public void interrupt() {
        OS2200CorePlugin.logger.debug((Object)"Debug Socket interrupted", null);
        this.loopOK = false;
        try {
            if (this.dbBuffer != null) {
                this.dbBuffer.notifyQueue();
            }
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.debug((Object)"error emptying queue on close", throwable);
        }
        try {
            if (!this.shutDown) {
                this.shutDown = true;
                this.charStream = null;
                if (this.eventSocket != null) {
                    if (!this.eventSocket.isClosed() && !this.eventSocket.isInputShutdown()) {
                        this.eventSocket.shutdownInput();
                    }
                    if (!this.eventSocket.isClosed()) {
                        this.eventSocket.close();
                    }
                    this.eventSocket = null;
                }
                super.interrupt();
            }
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"error closing socket reader", (Throwable)iOException);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)"general error closing socket reader", (Throwable)exception);
        }
    }

    @Override
    public void run() {
        block8: {
            try {
                OS2200CorePlugin.logger.debug((Object)"debug socket run started");
                this.shutDown = false;
                while (this.loopOK) {
                    this.inputBytes = new char[120000];
                    int n = this.charStream.read(this.inputBytes);
                    if (this.dbBuffer == null) continue;
                    this.dbBuffer.addQueue(this.inputBytes, n);
                }
                OS2200CorePlugin.logger.debug((Object)"outside Socket read loop");
            }
            catch (IOException iOException) {
                if (!this.loopOK) {
                    OS2200CorePlugin.logger.debug((Object)"end of buffer read");
                } else if (!this.socketControl.isPrimaryTaskHandler() || this.writingStop) {
                    OS2200CorePlugin.logger.debug((Object)("ending socket listen for task " + this.socketControl.getTaskId()));
                    this.loopOK = false;
                    this.shutDown = true;
                    this.socketControl.getMainConnect().removeFromChain(this.socketControl);
                } else {
                    OS2200CorePlugin.logger.error((Object)"Unisys internal debug error", (Throwable)iOException);
                    OS2200CorePlugin.logger.info((Object)("debug socket error: task " + this.socketControl.getTaskId() + " port " + this.portOn), (Throwable)iOException);
                    this.socketControl.readSocketError(iOException);
                }
                this.emptyQueue();
                return;
            }
            catch (Exception exception) {
                if (this.loopOK) break block8;
                OS2200CorePlugin.logger.error((Object)"Unisys internal debug error", (Throwable)exception);
                OS2200CorePlugin.logger.info((Object)"unexpected exception ", (Throwable)exception);
                this.socketControl.readSocketError(exception);
                this.emptyQueue();
            }
        }
    }

    public void doingStop() {
        this.writingStop = true;
    }

    void emptyQueue() {
        if (this.dbBuffer != null) {
            this.dbBuffer.dispose();
            this.dbBuffer = null;
        }
    }

    public void dispose() {
        this.emptyQueue();
    }
}

