/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.InMessage;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.ui.services.IDisposable;

public class DebugInputBuffer
implements IDisposable {
    private ConcurrentLinkedQueue<QueueEntry> InQueue = new ConcurrentLinkedQueue();
    private char[] inputChars;
    private int msgPointer = 0;
    private CharArrayReader charsIn;
    BufferedReader buffy = null;
    private int count = 0;
    QueueEntry currentQEntry = null;

    public void dispose() {
        OS2200CorePlugin.logger.debug((Object)"DBI disposed");
        this.InQueue = null;
    }

    public InMessage getNextMessage() throws InterruptedException {
        boolean bl = false;
        if (this.buffy == null || this.msgPointer >= this.count) {
            this.initBuffer();
        }
        try {
            String string;
            if (this.inputChars[this.msgPointer + 1] == '#') {
                bl = true;
                if (this.msgPointer > 16000) {
                    OS2200CorePlugin.logger.debug((Object)("big Count in getNextMessage " + this.count));
                }
                int n = this.msgPointer + "##ECPADS FILE BLOCK".length();
                String string2 = new String(this.inputChars, this.msgPointer, "##ECPADS FILE BLOCK".length());
                if (string2.equals("##ECPADS FILE BLOCK")) {
                    String string3 = new String(this.inputChars, n, 30 - "##ECPADS FILE BLOCK".length()).trim();
                    int n2 = Integer.parseInt(string3);
                    char[] cArray = new char[n2 + 60];
                    this.fillBlock(cArray, n2);
                    InMessage inMessage = new InMessage(cArray, n2);
                    return inMessage;
                }
                OS2200CorePlugin.logger.debug((Object)("block but not the right stuff " + string2 + " " + n));
            }
            if (bl) {
                OS2200CorePlugin.logger.debug((Object)"still doing block");
            }
            if ((string = this.buffy.readLine()) == null) {
                this.initBuffer();
                string = this.buffy.readLine();
            }
            if (string.startsWith("# ||")) {
                OS2200CorePlugin.logger.debug((Object)("passing a variable line " + string));
            }
            this.findNextCommand(string.length());
            return new InMessage(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void fillBlock(char[] cArray, int n) throws InterruptedException, IOException {
        int n2 = n + 30;
        int n3 = 0;
        int n4 = this.count - this.msgPointer;
        if (n4 >= n2) {
            System.arraycopy(this.inputChars, this.msgPointer, cArray, 0, n2);
            this.msgPointer += n2;
            this.buffy.skip(n2);
            return;
        }
        System.arraycopy(this.inputChars, this.msgPointer, cArray, 0, n4);
        int n5 = n2 - n4;
        this.msgPointer += n4;
        n3 += n4;
        while (n5 > 0) {
            this.initBuffer();
            if (n5 > this.count) {
                System.arraycopy(this.inputChars, this.msgPointer, cArray, n3, this.count);
                n5 -= this.count;
                n3 += this.count;
                this.msgPointer += this.count;
                continue;
            }
            System.arraycopy(this.inputChars, this.msgPointer, cArray, n3, n5);
            this.msgPointer = n5;
            this.buffy.skip(n5);
            n5 = 0;
        }
    }

    private void initBuffer() throws InterruptedException {
        if (this.msgPointer < this.count) {
            OS2200CorePlugin.logger.error((Object)("debug queue left unread characters.  Count left:" + (this.count - this.msgPointer)));
        }
        this.currentQEntry = this.getQueueEntry();
        this.inputChars = this.currentQEntry.qArray;
        this.count = this.currentQEntry.count;
        this.charsIn = new CharArrayReader(this.inputChars, 0, this.count);
        this.buffy = new BufferedReader(this.charsIn);
        this.msgPointer = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueEntry getQueueEntry() throws InterruptedException {
        QueueEntry queueEntry = this.InQueue.poll();
        while (queueEntry == null) {
            ConcurrentLinkedQueue<QueueEntry> concurrentLinkedQueue = this.InQueue;
            synchronized (concurrentLinkedQueue) {
                this.InQueue.wait();
            }
            queueEntry = this.InQueue.poll();
        }
        return queueEntry;
    }

    void findNextCommand(int n) {
        int n2 = this.msgPointer + n;
        while (n2 < this.count) {
            if (this.inputChars[n2] == '#') {
                this.msgPointer = n2;
                return;
            }
            ++n2;
        }
        this.msgPointer = this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyQueue() {
        ConcurrentLinkedQueue<QueueEntry> concurrentLinkedQueue = this.InQueue;
        synchronized (concurrentLinkedQueue) {
            this.InQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(char[] cArray, int n) {
        this.InQueue.add(new QueueEntry(cArray, n));
        ConcurrentLinkedQueue<QueueEntry> concurrentLinkedQueue = this.InQueue;
        synchronized (concurrentLinkedQueue) {
            this.InQueue.notifyAll();
        }
    }

    class QueueEntry {
        char[] qArray;
        int count;

        public QueueEntry(char[] cArray, int n) {
            this.qArray = cArray;
            this.count = n;
        }
    }
}

