/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.comm;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.FormatMan;
import com.unisys.tde.debug.core.comm.InMessage;
import com.unisys.tde.debug.core.comm.MessageType;
import com.unisys.tde.debug.core.comm.VariableInfo;
import com.unisys.tde.debug.core.comm.VariableSet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class AllVariables {
    private static final String EQUALS = "=";
    private static final String OF_Conjunct = " of ";
    private static final String VARIABLE_VALUES_DONE = "# VARIABLE VALUES DONE";
    private static final String VARIABLE_VALUES_START = "VARIABLE VALUES START";
    private String compiler;
    private String element;
    private String procedure;
    private String block;
    private boolean gettingChildren;
    private VariableSet globalSet;
    private VariableSet localSet;
    private VariableSet currentSet;
    private boolean initComplete;
    private VariableInfo currentVariable;
    private String initLine;
    private static final String varFormat = "# START VAR DISPLAY FOR VARIABLES COMPILER=%s %s,%s,%s,%s,%s,%s,%s ||";
    private static final String varChildren = "# START VAR DISPLAY FOR CHILDREN ||";
    private Hashtable<String, String> valueTable;
    private String[] varLines;

    public AllVariables(String string) {
        this.initLine = string;
        this.globalSet = null;
        this.localSet = null;
        if (this.initLine.endsWith("||")) {
            this.initComplete = true;
            this.parseInit();
        } else {
            this.initComplete = false;
        }
    }

    public AllVariables() {
        this.globalSet = null;
        this.localSet = null;
    }

    public void init(String string) {
        this.initLine = string.trim();
        if (this.initLine.endsWith("||")) {
            this.initComplete = true;
            this.parseInit();
        } else {
            this.initComplete = false;
        }
    }

    public boolean initIsComplete() {
        return this.initComplete;
    }

    public void addLine(String string) {
        if (this.initLine != null) {
            this.initLine = String.valueOf(this.initLine) + string.substring(2);
            this.initLine = this.initLine.trim();
            if (this.initLine.endsWith("||")) {
                this.initComplete = true;
                this.parseInit();
            }
        }
    }

    void parseInit() {
        if (this.initLine.indexOf("CHILDREN") > 0) {
            this.gettingChildren = true;
            this.compiler = "";
            this.element = "";
            this.procedure = "";
            this.block = "";
        } else {
            this.gettingChildren = false;
            Object[] objectArray = FormatMan.sscanf(varFormat, this.initLine);
            this.compiler = (String)objectArray[0];
            this.element = (String)objectArray[1];
            this.procedure = (String)objectArray[2];
            this.block = (String)objectArray[3];
        }
    }

    public void addLocalVariableSet() {
        this.currentSet = this.localSet = new VariableSet(1, this.valueTable);
    }

    public VariableSet getLocalVariableSet() {
        return this.localSet;
    }

    public void addGlobalVariableSet() {
        this.currentSet = this.globalSet = new VariableSet(0, this.valueTable);
    }

    public VariableSet getGlobalVariableSet() {
        return this.globalSet;
    }

    public boolean incompleteVariable() {
        if (this.currentVariable != null) {
            return !this.currentVariable.isComplete();
        }
        return false;
    }

    public void addVariable(String string) {
        int n = this.countBars(string);
        String string2 = string.substring(2 + n);
        this.addVariable(string2, n);
    }

    private int countBars(String string) {
        String string2 = string.substring(2);
        int n = 0;
        while (string2.startsWith("|")) {
            ++n;
            string2 = string2.substring(1);
        }
        return n;
    }

    public void addVariable(String string, int n) {
        this.currentVariable = this.currentSet.createLeafVariable(n);
        this.currentVariable.parseStart(string);
    }

    public void addDummyVariable(String string, String string2) {
        this.currentVariable = this.currentSet.createLeafVariable(0);
        this.currentVariable.setVariableName(string);
        this.currentVariable.setValue("'" + string2 + "'");
        this.currentVariable.setComplete(true);
        this.currentVariable.setStorage(" ");
    }

    public void addToVariable(String string) {
        if (this.currentVariable != null) {
            this.currentVariable.parseEnd(string.substring(2));
        }
    }

    public boolean processFile(String string) {
        String string2 = this.readInFile(string);
        if (string2 == null) {
            OS2200CorePlugin.logger.error((Object)"variable file not correct");
            return false;
        }
        this.varLines = string2.split("\n");
        boolean bl = this.processArray(this.varLines);
        return bl;
    }

    public void setArrray(String string) {
        this.varLines = string.split("\n");
    }

    public void processBlock() {
        this.processArray(this.varLines);
    }

    public boolean processArray(String[] stringArray) {
        int n = -1;
        if (stringArray != null) {
            n = stringArray.length;
        }
        OS2200CorePlugin.logger.debug((Object)("starting process array" + n));
        try {
            int cfr_ignored_0 = stringArray.length;
            int n2 = 0;
            this.init(stringArray[0]);
            if (this.gettingChildren) {
                n2 = 1;
            }
            int n3 = n2;
            while (n3 < stringArray.length) {
                String string = stringArray[n3].trim();
                MessageType messageType = this.parseType(string);
                switch (messageType) {
                    case tpStartValues: {
                        n3 = this.parseValues(stringArray, n3);
                        break;
                    }
                    case tpComma: {
                        if (this.initComplete) break;
                        this.addLine(string);
                        break;
                    }
                    case tpVarLocal: {
                        this.addLocalVariableSet();
                        break;
                    }
                    case tpVarGlobal: {
                        this.addGlobalVariableSet();
                        break;
                    }
                    case tpVarEndBars: {
                        if (!this.incompleteVariable()) break;
                        this.addToVariable(string);
                        break;
                    }
                    case tpBar: {
                        this.addVariable(string);
                        break;
                    }
                    case tpProfEnv: {
                        break;
                    }
                    case tpAllVarsEnd: {
                        break;
                    }
                    case tpUKPound: {
                        if (!this.initIsComplete()) {
                            this.addLine(string);
                            break;
                        }
                        if (this.incompleteVariable()) {
                            this.addToVariable(string);
                            break;
                        }
                        this.addVariable(string);
                    }
                }
                ++n3;
            }
            return true;
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.error((Object)"Error processing variables", throwable);
            this.addGlobalVariableSet();
            this.addDummyVariable("Variables cannot be retrieved.", "Unable to get variable values.");
            return false;
        }
    }

    public MessageType parseType(String string) {
        MessageType messageType = MessageType.tpUKPound;
        int n = 0;
        while (n < InMessage.variableSet.length) {
            int n2 = InMessage.variableSet[n];
            String string2 = InMessage.statement_array[n2].name;
            if (string.startsWith(string2)) {
                messageType = InMessage.statement_array[n2].index;
                if (messageType == MessageType.tpBar && string.equals("# ||")) {
                    messageType = MessageType.tpVarEndBars;
                }
                return messageType;
            }
            ++n;
        }
        return messageType;
    }

    public String readInFile(String string) {
        OS2200CorePlugin.logger.debug((Object)string);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = ((InputStream)fileInputStream).available();
            byte[] byArray = new byte[n + 100];
            OS2200CorePlugin.logger.debug((Object)("count " + n + " " + byArray.length));
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n2 != -1) {
                n2 = ((InputStream)fileInputStream).read(byArray, n3, byArray.length - n3);
                OS2200CorePlugin.logger.debug((Object)("cntIn " + n2));
                if (n2 == -1) continue;
                n4 += n2;
                n3 += n2;
            }
            OS2200CorePlugin.logger.debug((Object)("countin " + n4));
            String string2 = new String(byArray, 0, n4);
            return string2;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"Error reading variable file");
            return null;
        }
    }

    int parseValues(String[] stringArray, int n) {
        boolean bl = false;
        this.valueTable = new Hashtable();
        int n2 = n;
        Poster poster = new Poster(n2);
        while (!bl) {
            String string = poster.getNextLine();
            if (string.startsWith(VARIABLE_VALUES_DONE)) {
                n2 = poster.lineNo + 2;
                this.initComplete = true;
                bl = true;
                continue;
            }
            poster = this.parseValueLine(poster);
        }
        return n2;
    }

    int moveBackOfs(String string, int n, int n2) {
        String string2 = string.substring(0, n);
        int n3 = string2.lastIndexOf(OF_Conjunct);
        if (n3 < n2) {
            return -1;
        }
        int n4 = -1;
        if (n3 != -1) {
            while (n3 != -1) {
                n4 = string2.lastIndexOf(" ", n3 - 1);
                if (n4 == -1 || n4 < n2) {
                    n3 = -1;
                    break;
                }
                n3 = (string2 = string2.substring(0, n4 + 1)).lastIndexOf(OF_Conjunct);
                if (n3 >= n2) continue;
                n3 = -1;
            }
        }
        return n4;
    }

    Poster parseValueLine(Poster poster) {
        try {
            Poster poster2 = poster;
            String string = "";
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                TermType termType = poster2.getNextItem();
                switch (termType) {
                    case tmOf: {
                        string = this.prependName(poster2.currentPiece, string);
                        break;
                    }
                    case tmEq: {
                        string = this.prependName(poster2.currentPiece, string);
                        bl2 = true;
                        break;
                    }
                    case tmSp: {
                        String string2 = poster2.currentPiece;
                        if (string.length() > 0) {
                            this.valueTable.put(string, string2);
                        }
                        string = "";
                        bl2 = false;
                        break;
                    }
                    case tmEnd: {
                        if (bl2) {
                            String string3 = poster2.currentPiece;
                            if (string.length() > 0) {
                                this.valueTable.put(string, string3);
                            }
                            string = "";
                            bl2 = false;
                            bl = true;
                            break;
                        }
                        string = this.prependName(poster2.currentPiece, string);
                        poster2.getNextLine();
                        break;
                    }
                    case tmDone: {
                        bl = true;
                        break;
                    }
                    case tmNull: 
                    case tmError: {
                        poster2.getNextLine();
                    }
                }
            }
            return poster2;
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.error((Object)"Error parsing values", throwable);
            return poster;
        }
    }

    String prependName(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        String string3 = string;
        int n = string3.indexOf("(");
        if (n > 0) {
            String string4 = string3.substring(n);
            string3 = string3.substring(0, n);
            return String.valueOf(string3) + "." + string2 + string4;
        }
        return String.valueOf(string3) + "." + string2;
    }

    class Poster {
        String currentPiece;
        String value;
        String lineOn;
        int lineNo;
        int colNo;
        TermType tt;

        Poster(int n) {
            this.lineNo = n;
            this.colNo = 0;
        }

        String getNextLine() {
            ++this.lineNo;
            this.lineOn = AllVariables.this.varLines[this.lineNo].trim();
            this.colNo = 2;
            return this.lineOn;
        }

        TermType getNextItem() {
            try {
                if (this.lineOn.equals(AllVariables.VARIABLE_VALUES_DONE)) {
                    --this.lineNo;
                    return TermType.tmDone;
                }
                if (this.lineOn.startsWith("# *E")) {
                    this.tt = TermType.tmError;
                    this.currentPiece = null;
                    return this.tt;
                }
                if (this.colNo >= this.lineOn.length()) {
                    this.tt = TermType.tmNull;
                    this.currentPiece = null;
                    return this.tt;
                }
                int n = -1;
                int n2 = this.lineOn.indexOf(" ", this.colNo);
                if (n2 != -1 && n2 + AllVariables.OF_Conjunct.length() <= this.lineOn.length() && this.lineOn.substring(n2, n2 + AllVariables.OF_Conjunct.length()).equals(AllVariables.OF_Conjunct)) {
                    n = n2;
                }
                int n3 = this.lineOn.indexOf(AllVariables.EQUALS, this.colNo);
                if (n != -1) {
                    this.currentPiece = this.lineOn.substring(this.colNo, n).trim();
                    this.colNo = n + AllVariables.OF_Conjunct.length();
                    this.tt = TermType.tmOf;
                    return this.tt;
                }
                if (n2 != -1) {
                    if (n3 != -1 && n3 < n2) {
                        this.currentPiece = this.lineOn.substring(this.colNo, n3).trim();
                        this.colNo = n3 + 1;
                        this.tt = TermType.tmEq;
                        return this.tt;
                    }
                    if (n3 != -1) {
                        int n4 = AllVariables.this.moveBackOfs(this.lineOn, n3, n2);
                        if (n4 != -1) {
                            this.currentPiece = this.lineOn.substring(this.colNo, n4);
                            this.colNo = n4 + 1;
                            return TermType.tmSp;
                        }
                        this.currentPiece = this.lineOn.substring(this.colNo, n2);
                        int n5 = this.lineOn.indexOf(" ", n2 + 1);
                        int n6 = n2;
                        while (n5 != -1 && n5 < n3) {
                            n6 = n5;
                            n5 = this.lineOn.indexOf(" ", n6 + 1);
                        }
                        this.currentPiece = this.lineOn.substring(this.colNo, n6);
                        if (n5 != -1) {
                            this.colNo = n6 + 1;
                            return TermType.tmSp;
                        }
                        this.colNo = n6 + 1;
                        return TermType.tmEnd;
                    }
                    this.currentPiece = this.lineOn.substring(this.colNo).trim();
                    this.colNo = this.lineOn.length();
                    this.tt = TermType.tmEnd;
                    return this.tt;
                }
                if (n3 != -1) {
                    this.currentPiece = this.lineOn.substring(this.colNo, n3).trim();
                    this.colNo = n3 + 1;
                    this.tt = TermType.tmEq;
                    return this.tt;
                }
                this.currentPiece = this.lineOn.substring(this.colNo).trim();
                ++this.colNo;
                this.tt = TermType.tmEnd;
                return this.tt;
            }
            catch (Throwable throwable) {
                OS2200CorePlugin.logger.error((Object)"Error getting next item", throwable);
                return TermType.tmNull;
            }
        }
    }

    private static enum TermType {
        tmOf(1),
        tmEq(2),
        tmSp(3),
        tmEnd(4),
        tmNull(5),
        tmDone(6),
        tmError(7);

        private final int value;

        private TermType(int n2) {
            this.value = n2;
        }
    }
}

