/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.util;

import com.unisys.os2200.i18nSupport.Messages;
import java.text.MessageFormat;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.util.StatusUtil;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ValidationManager {
    private static final String DEFAULT_BLANK1_TEXT_ERROR_MSG = Messages.getString((String)"This_field_cannot_be_blank_11");
    private static final String FILE_NAME_ERR = "ValidationManager.file_name.err";
    private static final String TARGET_FILE_NAME_ERR = "ValidationManager.target_name.err";
    private static final String FILE_NAME_LENGTH_ERR = "ValidationManager.file_name.length_Err";
    private static final String TARGET_NAME_LENGTH_ERR = "ValidationManager.target_name.length_Err";
    public static final int FILE_NAME = 0;
    public static final int BLANK_TEXT = 1;
    public static final int FOLDER_NAME = 2;
    public static final int JSP_FILE_NAME = 3;
    public static final int HTML_FILE_NAME = 4;
    public static final int SPT_FILE_NAME = 5;
    public static final int TXT_FILE_NAME = 6;
    public static final int XML_FILE_NAME = 7;
    public static final String DUPLICATE_CLASS_FILE = "Duplicate_Class_File";
    public static final int BLANK_PACKAGE_TEXT = 8;
    public static final int SPECIAL_CHARACTERS = 9;
    private static final String DEFAULT_BLANK_PACKAGE_TEXT_ERROR_MSG = Messages.getString((String)"package_text_cannot_be_blank");

    public static IStatus validate(int n, String string) {
        IStatus iStatus = null;
        switch (n) {
            case 1: {
                iStatus = ValidationManager.validateForBlankString(string);
                break;
            }
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                iStatus = ValidationManager.validateFileName(string);
                break;
            }
            case 4: {
                iStatus = ValidationManager.validateHTMLFileName(string);
                break;
            }
            case 2: {
                iStatus = ValidationManager.validateFolderName(string);
                break;
            }
            case 8: {
                iStatus = ValidationManager.validateForBlankPackage(string);
            }
            case 9: {
                iStatus = ValidationManager.validateForSpecialCharacters(string);
            }
        }
        return iStatus;
    }

    public static final IStatus createStatusForDuplicateFileNameError(String string, String string2) {
        String string3 = MessageFormat.format(Messages.getString((String)DUPLICATE_CLASS_FILE), string, string2);
        return new Status(4, CorePlugin.getPluginId(), -1, string3, null);
    }

    public static final IStatus validateForBlankString(String string) {
        return string != null && string.length() > 0 ? new Status(0, CorePlugin.getPluginId(), -1, Messages.getString((String)"_3"), null) : new Status(4, CorePlugin.getPluginId(), -1, DEFAULT_BLANK1_TEXT_ERROR_MSG, null);
    }

    public static final IStatus validateForBlankPackage(String string) {
        return string != null && string.length() > 0 ? new Status(0, CorePlugin.getPluginId(), -1, Messages.getString((String)"_3"), null) : new Status(4, CorePlugin.getPluginId(), -1, DEFAULT_BLANK_PACKAGE_TEXT_ERROR_MSG, null);
    }

    public static final IStatus validateFileName(String string) {
        IStatus iStatus = ValidationManager.validateForBlankString(string);
        if (iStatus.isOK()) {
            iStatus = CorePlugin.getWorkspace().validateName(string, 1);
            if (iStatus.isOK()) {
                IStatus iStatus2 = ValidationManager.validateFileNameConstraints(string);
                if (iStatus2 != null) {
                    iStatus = iStatus2;
                } else if (string.indexOf(46) != -1) {
                    String string2 = MessageFormat.format(Messages.getString((String)FILE_NAME_ERR), ".");
                    iStatus = StatusUtil.createStatus(4, string2);
                }
            } else {
                String string3 = iStatus.getMessage();
                if (string3.endsWith(".")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String string4 = MessageFormat.format(Messages.getString((String)FILE_NAME_ERR), string);
                iStatus = iStatus.getSeverity() == 4 ? new Status(4, CorePlugin.getPluginId(), -1, string4, null) : new Status(2, CorePlugin.getPluginId(), -1, string4, null);
            }
        }
        return iStatus;
    }

    public static final IStatus validateForSpecialCharacters(String string) {
        Status status = new Status(0, CorePlugin.getPluginId(), -1, "", null);
        boolean bl = true;
        String string2 = "";
        IStatus iStatus = ValidationManager.validateForBlankString(string);
        if (iStatus.isOK()) {
            int n = 32;
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                if (!(n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n == 46 || n >= 48 && n <= 57)) {
                    bl = false;
                    break;
                }
                bl = true;
                ++n2;
            }
            if (bl) {
                n2 = string.charAt(0);
                char c = string.charAt(string.length() - 1);
                bl = n2 >= 48 && n2 <= 57 ? false : (n2 == 46 || c == '.' ? false : (ValidationManager.checkForDots(string) ? false : string.length() <= 129));
            }
            if (!bl) {
                string2 = MessageFormat.format(Messages.getString((String)FILE_NAME_ERR), string);
                return new Status(4, CorePlugin.getPluginId(), -1, string2, null);
            }
        } else {
            return iStatus;
        }
        return status;
    }

    private static boolean checkForDots(String string) {
        boolean bl = false;
        int n = 32;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c;
            n = string.charAt(n3);
            if (n == 46 && n2 > 1 && (c = string.charAt(n3 + 1)) == '.') {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl;
    }

    public static final IStatus validateHTMLFileName(String string) {
        IStatus iStatus = ValidationManager.validateForBlankString(string);
        if (iStatus.isOK() && (iStatus = CorePlugin.getWorkspace().validateName(string, 1)).isOK()) {
            IStatus iStatus2 = ValidationManager.validateFileNameConstraints(string);
            if (iStatus2 != null) {
                iStatus = iStatus2;
            } else {
                int n = string.indexOf(".");
                if (n != -1) {
                    int n2 = string.lastIndexOf(".");
                    boolean bl = false;
                    if (n == n2 && (string.endsWith(".html") || string.endsWith(".htm"))) {
                        bl = true;
                    }
                    if (!bl) {
                        String string2 = MessageFormat.format(Messages.getString((String)FILE_NAME_ERR), ".");
                        iStatus = StatusUtil.createStatus(4, string2);
                    }
                }
            }
        }
        return iStatus;
    }

    public static final IStatus validateTargetFileName(String string, String string2) {
        IStatus iStatus = ValidationManager.validateForBlankString(string);
        if (iStatus.isOK() && (iStatus = ValidationManager.validateTargetName(string)).isOK()) {
            IStatus iStatus2 = ValidationManager.validateTargetNameConstraints(string, string2);
            if (iStatus2 != null) {
                iStatus = iStatus2;
            } else {
                int n = string.indexOf(".");
                if (n != -1) {
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    if (!bl) {
                        String string3 = "";
                        string3 = string2.equals("targetname") ? Messages.getString((String)TARGET_FILE_NAME_ERR) : Messages.getString((String)FILE_NAME_ERR);
                        String string4 = MessageFormat.format(string3, ".");
                        iStatus = StatusUtil.createStatus(4, string4);
                    }
                }
            }
        }
        return iStatus;
    }

    public static IStatus validateTargetName(String string) {
        if (string == null) {
            String string2 = org.eclipse.core.internal.utils.Messages.resources_nameNull;
            return new ResourceStatus(77, null, string2);
        }
        if (string.length() == 0) {
            String string3 = org.eclipse.core.internal.utils.Messages.resources_nameEmpty;
            return new ResourceStatus(77, null, string3);
        }
        if (!OS.isNameValid((String)string)) {
            String string4 = org.eclipse.core.internal.utils.Messages.bind((String)org.eclipse.core.internal.utils.Messages.resources_invalidName, (Object[])new Object[]{string});
            return new ResourceStatus(77, null, string4);
        }
        return ResourceStatus.OK_STATUS;
    }

    public static final IStatus validateFolderName(String string) {
        return CorePlugin.getWorkspace().validateName(string, 2);
    }

    private static IStatus validateFileNameConstraints(String string) {
        IStatus iStatus = null;
        iStatus = ValidationManager.checkFileNameLength(string);
        if (iStatus != null) {
            return iStatus;
        }
        char[] cArray = new char[]{'.', ',', ';', '=', '[', ']', '\\', '/', ' ', '\"', '*', ':', '|', '<', '>', '?'};
        int n = 0;
        while (n < cArray.length) {
            if (string.indexOf(cArray[n]) != -1) {
                String string2 = MessageFormat.format(Messages.getString((String)FILE_NAME_ERR), string);
                iStatus = new Status(4, CorePlugin.getPluginId(), -1, string2, null);
                return iStatus;
            }
            ++n;
        }
        return iStatus;
    }

    private static IStatus validateTargetNameConstraints(String string, String string2) {
        IStatus iStatus = null;
        iStatus = string2.equalsIgnoreCase("filename") ? ValidationManager.checkFileNameLength(string) : ValidationManager.checkTargetNameLength(string);
        if (iStatus != null) {
            return iStatus;
        }
        char[] cArray = new char[]{',', ';', '=', '[', ']', '\\', '/', ' ', '\"', '*', ':', '|', '<', '>', '?', '.'};
        int n = 0;
        while (n < cArray.length) {
            if (string.indexOf(cArray[n]) != -1) {
                String string3 = "";
                string3 = string2.equals("targetname") ? Messages.getString((String)TARGET_FILE_NAME_ERR) : Messages.getString((String)FILE_NAME_ERR);
                String string4 = MessageFormat.format(string3, string);
                iStatus = new Status(4, CorePlugin.getPluginId(), -1, string4, null);
                return iStatus;
            }
            ++n;
        }
        return iStatus;
    }

    public static IStatus checkTargetNameLength(String string) {
        int n = Integer.parseInt(Messages.getString((String)"ValidationManager.target_name.length"));
        if (string.length() > n) {
            String string2 = MessageFormat.format(Messages.getString((String)TARGET_NAME_LENGTH_ERR), String.valueOf(n));
            return new Status(4, CorePlugin.getPluginId(), -1, string2, null);
        }
        return null;
    }

    public static IStatus checkFileNameLength(String string) {
        int n = Integer.parseInt(Messages.getString((String)"ValidationManager.file_name.length"));
        if (string.length() > n) {
            String string2 = MessageFormat.format(Messages.getString((String)FILE_NAME_LENGTH_ERR), String.valueOf(n));
            return new Status(4, CorePlugin.getPluginId(), -1, string2, null);
        }
        return null;
    }
}

