/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards.common;

import org.eclipse.cobol.core.ui.wizards.common.BaseWizardSelectionPage;
import org.eclipse.cobol.core.ui.wizards.common.IBaseWizard;
import org.eclipse.cobol.core.ui.wizards.common.WizardElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardNode
implements IWizardNode {
    private IWizard wizard;
    private BaseWizardSelectionPage parentWizardPage;
    public static final String KEY_CREATION_ERROR_TEXT = "Errors.CreationError.NoWizard";
    public static final String KEY_CREATION_ERROR = "Errors.CreationError";
    protected WizardElement wizardElement;

    public WizardNode(BaseWizardSelectionPage baseWizardSelectionPage, WizardElement wizardElement) {
        this.parentWizardPage = baseWizardSelectionPage;
        this.wizardElement = wizardElement;
    }

    protected abstract IBaseWizard createWizard() throws CoreException;

    public void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }

    public WizardElement getElement() {
        return this.wizardElement;
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        IBaseWizard iBaseWizard;
        if (this.wizard != null) {
            return this.wizard;
        }
        try {
            iBaseWizard = this.createWizard();
        }
        catch (CoreException coreException) {
            this.parentWizardPage.setDescriptionText("");
            this.parentWizardPage.setErrorMessage("Error");
            MessageDialog.openError((Shell)this.parentWizardPage.getWizard().getContainer().getShell(), (String)"KEY_CREATION_ERROR", (String)"KEY_CREATION_ERROR_TEXT");
            return null;
        }
        this.wizard = (IWizard)iBaseWizard;
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

