/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.Iterator;
import org.eclipse.cobol.core.ui.util.UICommonUtility;
import org.eclipse.cobol.core.ui.wizards.common.BaseWizardSelectionPage;
import org.eclipse.cobol.core.ui.wizards.common.ElementList;
import org.eclipse.cobol.core.ui.wizards.common.ListContentProvider;
import org.eclipse.cobol.core.ui.wizards.common.ListUtil;
import org.eclipse.cobol.core.ui.wizards.common.WizardElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class WizardListSelectionPage
extends BaseWizardSelectionPage
implements ISelectionChangedListener {
    protected TableViewer wizardSelectionViewer;
    private ElementList wizardElements;
    private WizardSelectedAction doubleClickAction = new WizardSelectedAction();
    private boolean fHasPages = true;
    private IWizardNode selectedNode = null;
    private int COLUMN_WEIGHT_DATA = 100;
    public WizardElement fCurrentWizardSelection = null;

    public WizardListSelectionPage(ElementList elementList) {
        super("ListSelection");
        this.wizardElements = elementList;
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public ElementList getWizardElements() {
        return this.wizardElements;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite2, 0);
        label.setText(this.getLabel());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.wizardSelectionViewer = new TableViewer(this.createTable(composite2, 2048));
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)ListUtil.TABLE_LABEL_PROVIDER);
        this.wizardSelectionViewer.setSorter(ListUtil.NAME_SORTER);
        this.wizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                WizardListSelectionPage.this.doubleClickAction.run();
            }
        });
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createDescriptionIn(composite2, composite.getBackground());
        this.wizardSelectionViewer.setInput((Object)this.wizardElements);
        this.setControl((Control)composite2);
    }

    private Table createTable(Composite composite, int n) {
        Table table = new Table(composite, n);
        new TableColumn(table, 0);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.COLUMN_WEIGHT_DATA));
        table.setLayout((Layout)tableLayout);
        return table;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        UICommonUtility.dispose();
        this.setErrorMessage(null);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Iterator iterator = iStructuredSelection.iterator();
        if (iterator.hasNext()) {
            this.fCurrentWizardSelection = (WizardElement)iterator.next();
        }
        if (this.fCurrentWizardSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            return;
        }
        String string = this.fCurrentWizardSelection.getConfigurationElement().getAttribute("supported");
        if (string != null && string.trim().length() != 0) {
            try {
                if (!Boolean.valueOf(string).booleanValue()) {
                    String string2 = this.fCurrentWizardSelection.getConfigurationElement().getAttribute("unsupportedmessage");
                    if (string2 == null || string2.trim().length() == 0) {
                        string2 = Messages.getString((String)"OptionUnsupportedMessage");
                    }
                    this.setDescriptionText(this.fCurrentWizardSelection.getDescription());
                    this.setErrorMessage(string2);
                    this.setPageComplete(false);
                    return;
                }
            }
            catch (Exception exception) {}
        }
        this.fHasPages = this.fCurrentWizardSelection.hasPages();
        WizardElement wizardElement = this.fCurrentWizardSelection;
        this.setSelectedNode(this.createWizardNode(wizardElement));
        this.setDescriptionText(wizardElement.getDescription());
    }

    public IWizardPage getNextPage() {
        if (!this.fHasPages) {
            this.selectedNode.getWizard();
            return null;
        }
        return super.getNextPage();
    }

    public void setSelectedNode(IWizardNode iWizardNode) {
        this.selectedNode = iWizardNode;
        super.setSelectedNode(iWizardNode);
    }

    protected void focusAndSelectFirst() {
        Table table = this.wizardSelectionViewer.getTable();
        table.setFocus();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        if (n <= 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        Object object = tableItem.getData();
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem2 = tableItemArray[n2];
            Object object2 = tableItem2.getData();
            WizardElement wizardElement = (WizardElement)new StructuredSelection(object2).iterator().next();
            if (wizardElement.isDefault()) {
                tableItem = tableItem2;
                object = object2;
                break;
            }
            ++n2;
        }
        this.wizardSelectionViewer.setSelection((ISelection)new StructuredSelection(object));
        this.fHasPages = ((WizardElement)new StructuredSelection(object).iterator().next()).hasPages();
    }

    public boolean hasPages() {
        return this.fHasPages;
    }

    private class WizardSelectedAction
    extends Action {
        public WizardSelectedAction() {
            super("wizardSelection");
        }

        public void run() {
            WizardListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)WizardListSelectionPage.this.wizardSelectionViewer, WizardListSelectionPage.this.wizardSelectionViewer.getSelection()));
            WizardListSelectionPage.this.advanceToNextPage();
        }
    }
}

