/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards.common;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ui.wizards.common.IElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Image;

public class WizardElement {
    public static final String ATT_NAME = "name";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String HAS_PAGES = "hasPages";
    public static final String ISDEFAULT = "isDefault";
    private String description;
    private IConfigurationElement configurationElement;
    protected Image image;
    private String name;
    private IElement parent;
    public static final String TAG_NATURE = "nature";
    public static final String ATT_NATURE_ID = "id";
    public static final String ATT_TARGETTYPE = "targettype";
    private String[] fNatures = new String[0];

    public WizardElement(IConfigurationElement iConfigurationElement) {
        this.name = iConfigurationElement.getAttribute(ATT_NAME);
        this.configurationElement = iConfigurationElement;
        this.image = null;
        this.parent = null;
    }

    public WizardElement(String string) {
        this(string, null, null);
    }

    public WizardElement(String string, Image image) {
        this(string, image, null);
    }

    public WizardElement(String string, Image image, IElement iElement) {
        this.name = string;
        this.image = image;
        this.parent = iElement;
    }

    public Object createExecutableExtension() throws CoreException {
        try {
            return this.configurationElement.createExecutableExtension(ATT_CLASS);
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
            return null;
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        try {
            IConfigurationElement[] iConfigurationElementArray;
            if (this.description == null && (iConfigurationElementArray = this.configurationElement.getChildren(TAG_DESCRIPTION)).length > 0) {
                this.description = this.expandDescription(iConfigurationElementArray[0].getValue());
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        return this.description;
    }

    private String expandDescription(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.indexOf(37) == -1) {
            return string;
        }
        ResourceBundle resourceBundle = this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getResourceBundle();
        if (resourceBundle == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '%') {
                char c2 = string.charAt(n2 + 1);
                if (c2 == '%') {
                    ++n2;
                    stringBuffer.append('%');
                } else if (bl) {
                    String string2;
                    bl = false;
                    String string3 = string2 = string.substring(n, n2);
                    try {
                        string3 = resourceBundle.getString(string2);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    stringBuffer.append(string3);
                } else {
                    n = n2 + 1;
                    bl = true;
                }
            } else if (!bl) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getID() {
        try {
            return this.configurationElement.getAttribute("id");
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
            return "";
        }
    }

    public boolean hasPages() {
        try {
            String string = this.configurationElement.getAttribute(HAS_PAGES);
            if (string != null && string.equalsIgnoreCase("no")) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        return true;
    }

    public boolean isDefault() {
        try {
            String string = this.configurationElement.getAttribute(ISDEFAULT);
            if (string != null && string.equalsIgnoreCase("yes")) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        return false;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public String getLabel() {
        return this.name;
    }

    public Object getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getLabel();
    }

    public String[] getNatures() {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        try {
            IConfigurationElement[] iConfigurationElementArray;
            if (this.fNatures != null && this.fNatures.length == 0 && (iConfigurationElementArray = this.configurationElement.getChildren(TAG_NATURE)).length > 0) {
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    arrayList.add(iConfigurationElementArray[n].getAttribute("id"));
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getApplicationTargetType() {
        try {
            return this.configurationElement.getAttribute(ATT_TARGETTYPE);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

