/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.ui.wizards.ContainerSelectionGroup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ResourceAndContainerGroup
implements Listener {
    public static final int PROBLEM_NONE = 0;
    public static final int PROBLEM_RESOURCE_EMPTY = 1;
    public static final int PROBLEM_RESOURCE_EXIST = 2;
    public static final int PROBLEM_RESOURCE_CONTAINS_SEPARATOR = 3;
    public static final int PROBLEM_PATH_INVALID = 4;
    public static final int PROBLEM_CONTAINER_EMPTY = 5;
    public static final int PROBLEM_PROJECT_DOES_NOT_EXIST = 6;
    private Listener client;
    private boolean allowExistingResources = false;
    private String resourceType = IDEWorkbenchMessages.ResourceGroup_resource;
    private boolean showClosedProjects = false;
    private String problemMessage = "";
    private int problemType = 0;
    private static boolean fEnable = true;
    private static String fProjectNature = "";
    private ContainerSelectionGroup containerGroup;
    private Label label;
    private Text resourceNameField;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private int fResourceFilter = -1;
    private boolean fAllowNewContainerName = true;
    private String[] validProjectList = null;

    public ResourceAndContainerGroup(Composite composite, Listener listener, String string, String string2) {
        this(composite, listener, string, string2, false, fEnable, fProjectNature, -1, true);
    }

    public ResourceAndContainerGroup(Composite composite, Listener listener, String string, String string2, boolean bl, boolean bl2, String string3, int n, boolean bl3) {
        this.resourceType = string2;
        this.showClosedProjects = bl;
        fEnable = bl2;
        fProjectNature = string3;
        this.fResourceFilter = n;
        this.fAllowNewContainerName = bl3;
        this.createContents(composite, string);
        this.client = listener;
    }

    public ResourceAndContainerGroup(Composite composite, Listener listener, String string, String string2, boolean bl, boolean bl2, String string3, int n, boolean bl3, String[] stringArray) {
        this.resourceType = string2;
        this.showClosedProjects = bl;
        fEnable = bl2;
        fProjectNature = string3;
        this.validProjectList = stringArray;
        this.fResourceFilter = n;
        this.fAllowNewContainerName = bl3;
        this.createContents(composite, string);
        this.client = listener;
    }

    public boolean areAllValuesValid() {
        return this.problemType == 0;
    }

    protected void createContents(Composite composite, String string) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.containerGroup = new ContainerSelectionGroup(composite2, this, this.fAllowNewContainerName, null, this.showClosedProjects, fProjectNature, this.fResourceFilter, this.validProjectList);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        this.label = new Label(composite3, 0);
        this.label.setText(string);
        this.label.setFont(composite.getFont());
        this.resourceNameField = new Text(composite3, 2048);
        this.resourceNameField.addListener(24, (Listener)this);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.resourceNameField.setLayoutData((Object)gridData);
        if (!fEnable) {
            this.resourceNameField.setVisible(false);
            this.label.setVisible(false);
        }
        this.validateControls();
    }

    public IPath getContainerFullPath() {
        return this.containerGroup.getContainerFullPath();
    }

    public String getProblemMessage() {
        return this.problemMessage;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public String getResource() {
        return this.resourceNameField.getText();
    }

    public void handleEvent(Event event) {
        this.validateControls();
        if (this.client != null) {
            this.client.handleEvent(event);
        }
    }

    public void setAllowExistingResources(boolean bl) {
        this.allowExistingResources = bl;
    }

    public void setContainerFullPath(IPath iPath) {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (iResource != null) {
            if (!(iResource instanceof IContainer)) {
                iResource = iResource.getParent();
            }
            this.containerGroup.setSelectedContainer((IContainer)iResource);
        }
        this.validateControls();
    }

    public void setFocus() {
        this.resourceNameField.setSelection(0, this.resourceNameField.getText().length());
        this.resourceNameField.setFocus();
    }

    public void setResource(String string) {
        this.resourceNameField.setText(string);
        this.validateControls();
    }

    protected boolean validateContainer() {
        IPath iPath = this.containerGroup.getContainerFullPath();
        if (iPath == null) {
            this.problemType = 5;
            this.problemMessage = IDEWorkbenchMessages.ResourceGroup_folderEmpty;
            return false;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = iPath.segment(0);
        boolean bl = false;
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (iProjectArray[n2].getName().equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (string == null || !bl) {
            this.problemType = 6;
            this.problemMessage = Messages.getString((String)"org.eclipse.cobol.core.ui.wizards.common.wizard", (String)"ResourceGroup.noFolderExists");
            return false;
        }
        return true;
    }

    protected boolean validateControls() {
        if (this.containerGroup == null) {
            return false;
        }
        this.problemType = 0;
        this.problemMessage = "";
        if (!this.validateContainer() || !this.validateResourceName()) {
            return false;
        }
        IPath iPath = null;
        try {
            iPath = this.containerGroup.getContainerFullPath().append(this.resourceNameField.getText());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return this.validateFullResourcePath(iPath);
    }

    protected boolean validateFullResourcePath(IPath iPath) {
        if (iPath == null) {
            return false;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 2);
        if (!iStatus.isOK()) {
            this.problemType = 4;
            this.problemMessage = iStatus.getMessage();
            return false;
        }
        if (!this.allowExistingResources && (iWorkspace.getRoot().getFolder(iPath).exists() || iWorkspace.getRoot().getFile(iPath).exists())) {
            this.problemType = 2;
            this.problemMessage = IDEWorkbenchMessages.ResourceGroup_nameExists;
            return false;
        }
        return true;
    }

    protected boolean validateResourceName() {
        String string = this.resourceNameField.getText();
        if (string.equals("")) {
            this.problemType = 1;
            this.problemMessage = IDEWorkbenchMessages.bind((String)IDEWorkbenchMessages.ResourceGroup_emptyName, (Object[])new Object[]{this.resourceType});
            return false;
        }
        return true;
    }

    public Text getFileNameTextControl() {
        return this.resourceNameField;
    }

    public String getFolderName() {
        return this.containerGroup.getFolderName();
    }
}

