/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.cobol.core.ui.guiutility.GUIComponentCreationUtility;
import org.eclipse.cobol.core.ui.guiutility.GUIUtility;
import org.eclipse.cobol.core.ui.wizards.TableLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProjectSelectionDialog
extends Dialog {
    private TableViewer fProjectTable;
    private Button OKButton = null;
    private Button CancelButton = null;
    private String fSelectedProject = "";
    private ArrayList fValidProjects = new ArrayList();
    private Label dialogLabel = null;
    private String dialogTitle = "";
    private String RESOURCE_NAME = "com.unisys.os2200.i18nSupport.messages";
    ResourceBundle fBundle = ResourceBundle.getBundle(this.RESOURCE_NAME);

    public ProjectSelectionDialog(Shell shell, ArrayList arrayList) {
        super(shell);
        this.fValidProjects = arrayList;
    }

    public ProjectSelectionDialog(Shell shell, ArrayList arrayList, String string) {
        super(shell);
        this.fValidProjects = arrayList;
        this.dialogTitle = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle.equals("")) {
            shell.setText(this.fBundle.getString("ProjectSelectionDialog.Title.label"));
        } else {
            shell.setText(this.dialogTitle);
        }
    }

    protected Control createContents(Composite composite) {
        ProjectSelectionDialog.applyDialogFont((Control)composite);
        Composite composite2 = new Composite(composite, 1);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        this.dialogLabel = new Label(composite2, 0);
        this.dialogLabel.setFont(composite2.getFont());
        this.dialogLabel.setText(this.fBundle.getString("ProjectSelectionDialog.SelectProject.label"));
        this.fProjectTable = new TableViewer(composite2, 2816);
        this.fProjectTable.getControl().setFont(composite2.getFont());
        gridData = new GridData(1808);
        GridLayout gridLayout2 = new GridLayout();
        this.fProjectTable.getTable().setLayout((Layout)gridLayout2);
        this.fProjectTable.getTable().setLayoutData((Object)gridData);
        this.fProjectTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fProjectTable.setSorter(TableLabelProvider.NAME_SORTER);
        int n = 0;
        while (n < this.fValidProjects.size()) {
            this.fProjectTable.add(this.fValidProjects.get(n));
            ++n;
        }
        this.fProjectTable.getTable().setHeaderVisible(false);
        this.fProjectTable.getTable().setLinesVisible(false);
        this.fProjectTable.getTable().setSelection(0);
        this.fProjectTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                int n = ((TableViewer)doubleClickEvent.getSource()).getTable().getSelectionIndex();
                String string = ProjectSelectionDialog.this.fProjectTable.getTable().getItem(n).getText();
                if (string != null) {
                    ProjectSelectionDialog.this.fSelectedProject = string;
                    ProjectSelectionDialog.this.okPressed();
                }
            }
        });
        Composite composite3 = GUIComponentCreationUtility.createComposite(composite, 0, new GridData(768));
        GridLayout gridLayout3 = GUIComponentCreationUtility.createGridLayout(composite3, 2);
        composite3.setLayout((Layout)gridLayout3);
        GridData gridData2 = new GridData(128);
        composite3.setLayoutData((Object)gridData2);
        this.OKButton = new Button(composite3, 0);
        this.OKButton.setFont(composite2.getFont());
        this.OKButton.setText(this.fBundle.getString("ProjectSelectionDialog.OKButton.label"));
        if (this.fValidProjects.size() == 0) {
            this.OKButton.setEnabled(false);
        }
        this.CancelButton = new Button(composite3, 0);
        this.CancelButton.setFont(composite2.getFont());
        this.CancelButton.setText(this.fBundle.getString("ProjectSelectionDialog.CancelButton.label"));
        GridData gridData3 = new GridData();
        gridData3.heightHint = GUIUtility.getButtonHeigthHint(this.OKButton);
        gridData3.widthHint = GUIUtility.getButtonWidthHint(this.OKButton);
        this.OKButton.setLayoutData((Object)gridData3);
        GridData gridData4 = new GridData();
        gridData4.heightHint = GUIUtility.getButtonHeigthHint(this.CancelButton);
        gridData4.widthHint = GUIUtility.getButtonWidthHint(this.CancelButton);
        this.CancelButton.setLayoutData((Object)gridData4);
        this.OKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ProjectSelectionDialog.this.fProjectTable.getTable().getSelectionIndex();
                String string = ProjectSelectionDialog.this.fProjectTable.getTable().getItem(n).getText();
                if (string != null) {
                    ProjectSelectionDialog.this.fSelectedProject = string;
                    ProjectSelectionDialog.this.okPressed();
                }
            }
        });
        this.CancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectSelectionDialog.this.cancelPressed();
            }
        });
        return composite2;
    }

    public String openDialog() {
        int n = super.open();
        if (n == 0) {
            return this.fSelectedProject;
        }
        return null;
    }

    public void setLabelText(String string) {
        if (this.dialogLabel != null) {
            this.dialogLabel.setText(string);
        }
    }
}

