/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ui.guiutility.GUIComponentCreationUtility;
import org.eclipse.cobol.core.ui.wizards.IProjectBrowserControl;
import org.eclipse.cobol.core.ui.wizards.IProjectBrowserValidator;
import org.eclipse.cobol.core.ui.wizards.ProjectSelectionDialog;
import org.eclipse.cobol.core.util.ValidationManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectBrowserControl
implements IProjectBrowserControl {
    private IProjectBrowserValidator fValidator = null;
    private String RESOURCE_NAME = "com.unisys.os2200.i18nSupport.messages";
    private ResourceBundle fBundle = ResourceBundle.getBundle(this.RESOURCE_NAME);
    private String project_name_label = "ProjectBrowserControl.ProjectName.errorlabel";
    private Shell fShell = null;
    private Text fProjectNameText = null;
    private Label fLabelName = null;
    private ArrayList fValidProjectList = new ArrayList();
    private ModifyListener fModifyAdapter;
    private String initialProjectName = "";
    private Button fBrowseButton;
    private SelectionListener listener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            ProjectBrowserControl.this.performBrowseOperation();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    public ProjectBrowserControl(IProjectBrowserValidator iProjectBrowserValidator, Shell shell, String string) {
        Assert.isNotNull((Object)iProjectBrowserValidator);
        this.fShell = shell;
        this.fValidator = iProjectBrowserValidator;
        if (string != null) {
            this.initialProjectName = string;
        }
        this.fModifyAdapter = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                IStatus iStatus = ProjectBrowserControl.this.validateText();
                if (ProjectBrowserControl.this.fValidator != null) {
                    ProjectBrowserControl.this.fValidator.updatePageStatus(iStatus);
                }
            }
        };
    }

    @Override
    public void createControl(Composite composite) {
        this.fLabelName = new Label(composite, 16448);
        this.fLabelName.setFont(composite.getFont());
        this.fLabelName.setText(this.fBundle.getString("ProjectBrowserControl.ProjectName.label"));
        this.fLabelName.setFont(composite.getFont());
        Composite composite2 = GUIComponentCreationUtility.createComposite(composite, 0, new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.fProjectNameText = new Text(composite2, 2052);
        this.fProjectNameText.setFont(composite.getFont());
        this.fProjectNameText.addModifyListener(this.fModifyAdapter);
        this.fProjectNameText.setFocus();
        GridData gridData = new GridData();
        gridData.widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics((Control)this.fProjectNameText), (int)20);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fProjectNameText.setLayoutData((Object)gridData);
        this.fBrowseButton = new Button(composite2, 0);
        this.fBrowseButton.setFont(composite2.getFont());
        this.fBrowseButton.setText(this.fBundle.getString("ProjectBrowserControl.ReferenceButton.label"));
        this.fBrowseButton.addSelectionListener(this.listener);
        this.setStatus();
        this.setInitialProjectName();
    }

    private int getHeigthHint(Control control) {
        FontMetrics fontMetrics = this.getFontMetrics(control);
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
    }

    private int getWidthHint(Control control) {
        FontMetrics fontMetrics = this.getFontMetrics(control);
        int n = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(n, control.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private FontMetrics getFontMetrics(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return fontMetrics;
    }

    private void performBrowseOperation() {
        try {
            IProject[] iProjectArray = CorePlugin.getWorkspace().getRoot().getProjects();
            ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(this.fShell, this.getValidatedProjects(iProjectArray));
            String string = projectSelectionDialog.openDialog();
            this.fProjectNameText.setFocus();
            if (string != null) {
                this.fProjectNameText.setText(string);
            }
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
    }

    private ArrayList getValidatedProjects(IProject[] iProjectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (iProjectArray != null && iProjectArray.length > 0) {
            int n = 0;
            while (n < iProjectArray.length) {
                if (this.fValidator.isValidProject(iProjectArray[n])) {
                    arrayList.add(iProjectArray[n].getName());
                }
                ++n;
            }
        }
        this.fValidProjectList = arrayList;
        return arrayList;
    }

    @Override
    public String getSelectedProject() {
        return this.fProjectNameText.getText();
    }

    @Override
    public IStatus validateText() {
        int n;
        Status status = null;
        boolean bl = false;
        boolean bl2 = false;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        ArrayList arrayList = new ArrayList(10);
        arrayList = this.getValidatedProjects(iProjectArray);
        int n2 = iProjectArray.length;
        String string = this.fProjectNameText.getText();
        if (string != null && string.equals("")) {
            string = null;
        }
        if (string != null) {
            n = 0;
            while (n < n2) {
                if (iProjectArray[n].getName().equalsIgnoreCase(string) && iProjectArray[n].getLocation().toFile().exists()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (string != null && string.equals("")) {
            String string2 = ValidationManager.validateForBlankString("").getMessage().concat(":").concat(" ").concat(this.fBundle.getString("ProjectBrowserControl.ProjectName.errorlabel"));
            status = new Status(4, CorePlugin.getPluginId(), -1, string2, null);
        } else if (string == null || !bl) {
            String string3 = this.fBundle.getString("ProjectBrowserControl.project_does_not_exist");
            status = new Status(4, CorePlugin.getPluginId(), -1, string3, null);
        } else {
            n = 0;
            while (n < arrayList.size()) {
                if (string.equals((String)arrayList.get(n))) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            status = bl2 ? new Status(0, CorePlugin.getPluginId(), -1, "", null) : new Status(4, CorePlugin.getPluginId(), -1, this.fBundle.getString("ProjectBrowserControl.invalid_project_type.error.msg"), null);
        }
        return status;
    }

    @Override
    public void setStatus() {
        IProject[] iProjectArray = CorePlugin.getWorkspace().getRoot().getProjects();
        Status status = null;
        status = this.getValidatedProjects(iProjectArray).size() < 1 ? new Status(4, CorePlugin.getPluginId(), -1, this.fBundle.getString("ProjectBrowserControl.NOCOBOL.project.error.msg"), null) : new Status(0, CorePlugin.getPluginId(), -1, "", null);
        this.fValidator.updatePageStatus((IStatus)status);
    }

    private void setInitialProjectName() {
        if (this.initialProjectName != null || this.initialProjectName.length() > 1) {
            this.fProjectNameText.setText(this.initialProjectName);
        }
    }

    @Override
    public void setControlsDisabled() {
        this.fProjectNameText.setEnabled(false);
        this.fBrowseButton.setEnabled(false);
    }

    public void setLabelText(String string) {
        if (this.fLabelName != null) {
            this.fLabelName.setText(string);
        }
    }

    public void setTextControlText(String string) {
        if (this.fProjectNameText != null) {
            this.fProjectNameText.setText(string);
        }
    }

    public void setButtonText(String string) {
        if (this.fBrowseButton != null) {
            this.fBrowseButton.setText(string);
        }
    }

    public void setButtonListener(SelectionListener selectionListener) {
        if (this.fBrowseButton != null) {
            this.fBrowseButton.removeSelectionListener(this.listener);
            this.fBrowseButton.addSelectionListener(selectionListener);
        }
    }

    public void setTextListener(ModifyListener modifyListener) {
        if (this.fProjectNameText != null) {
            this.fProjectNameText.removeModifyListener(this.fModifyAdapter);
            this.fProjectNameText.addModifyListener(modifyListener);
        }
    }

    public boolean isValidSpecificProject() {
        IProject iProject;
        return this.fProjectNameText == null || this.fProjectNameText.getText().equals("") || (iProject = CorePlugin.getWorkspace().getRoot().getProject(this.fProjectNameText.getText())) == null || !iProject.exists() || this.fValidator.isValidProject(iProject);
    }

    public void setWidthHintOfText(int n) {
        GridData gridData;
        if (this.fProjectNameText != null && (gridData = (GridData)this.fProjectNameText.getLayoutData()) != null) {
            gridData.widthHint = n;
        }
    }

    public void setFocusOnTextControl() {
        if (this.fProjectNameText != null) {
            this.fProjectNameText.setFocus();
        }
    }
}

